/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;

public class StorageLabelProvider
extends LabelProvider {
    private IEditorRegistry fEditorRegistry = null;
    private Map fImageMap = new HashMap(10);
    private Image fDefaultImage;

    private IEditorRegistry getEditorRegistry() {
        if (this.fEditorRegistry == null) {
            this.fEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        }
        return this.fEditorRegistry;
    }

    public Image getImage(Object element) {
        if (element instanceof ISourceModule) {
            return this.getImageForEntry((ISourceModule)element);
        }
        if (element instanceof IStorage) {
            return this.getImageForEntry((IStorage)element);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IStorage) {
            return ((IStorage)element).getName();
        }
        return super.getText(element);
    }

    public void dispose() {
        if (this.fImageMap != null) {
            for (Image image : this.fImageMap.values()) {
                image.dispose();
            }
            this.fImageMap = null;
        }
        this.fDefaultImage = null;
    }

    private Image getImageForEntry(IStorage element) {
        if (this.fImageMap == null) {
            return this.getDefaultImage();
        }
        if (element == null || element.getName() == null) {
            return this.getDefaultImage();
        }
        String name = element.getName();
        Image image = (Image)this.fImageMap.get(name);
        if (image != null) {
            return image;
        }
        IFileEditorMapping[] mappings = this.getEditorRegistry().getFileEditorMappings();
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].getLabel().equals(name)) break;
            ++i;
        }
        String key = name;
        if (i == mappings.length) {
            IPath path = element.getFullPath();
            if (path == null) {
                return this.getDefaultImage();
            }
            key = path.getFileExtension();
            if (key != null && (image = (Image)this.fImageMap.get(key)) != null) {
                return image;
            }
        }
        ImageDescriptor desc = null;
        IEditorDescriptor[] descs = this.getEditorRegistry().getEditors(name);
        int e = 0;
        while (e < descs.length) {
            String id = descs[e].getId();
            if (id.indexOf("dltk") > 0) {
                desc = descs[e].getImageDescriptor();
            }
            ++e;
        }
        if (desc == null) {
            desc = this.getEditorRegistry().getImageDescriptor(name);
        }
        image = desc.createImage();
        this.fImageMap.put(key, image);
        return image;
    }

    private Image getImageForEntry(ISourceModule element) {
        if (this.fImageMap == null) {
            return this.getDefaultImage();
        }
        if (element == null || element.getElementName() == null) {
            return this.getDefaultImage();
        }
        String name = element.getElementName();
        Image image = (Image)this.fImageMap.get(name);
        if (image != null) {
            return image;
        }
        IFileEditorMapping[] mappings = this.getEditorRegistry().getFileEditorMappings();
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].getLabel().equals(name)) break;
            ++i;
        }
        String key = name;
        if (i == mappings.length) {
            IPath path = element.getPath();
            if (path == null) {
                return this.getDefaultImage();
            }
            key = path.getFileExtension();
            if (key != null && (image = (Image)this.fImageMap.get(key)) != null) {
                return image;
            }
        }
        ImageDescriptor desc = null;
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)element);
        if (toolkit == null) {
            return null;
        }
        String editorID = toolkit.getEditorId(element);
        IEditorDescriptor ed = this.getEditorRegistry().findEditor(editorID);
        if (ed != null) {
            desc = ed.getImageDescriptor();
        }
        if (desc == null) {
            desc = this.getEditorRegistry().getImageDescriptor(name);
        }
        image = desc.createImage();
        this.fImageMap.put(key, image);
        return image;
    }

    private Image getDefaultImage() {
        if (this.fDefaultImage == null) {
            this.fDefaultImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return this.fDefaultImage;
    }
}

