/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    protected AbstractIndexer indexer;
    protected char[][] enclosingTypeNames = new char[5][];
    protected int depth = 0;
    protected int methodDepth = 0;
    protected char[] pkgName = CharOperation.NO_CHAR;
    protected ISearchFactory searchFactory;
    protected ISearchPatternProcessor searchPatternProcessor;

    public SourceIndexerRequestor(AbstractIndexer indexer) {
        this.indexer = indexer;
    }

    public SourceIndexerRequestor() {
    }

    public void setIndexer(AbstractIndexer indexer) {
        this.indexer = indexer;
    }

    public void setSearchFactory(ISearchFactory searchFactory) {
        this.searchFactory = searchFactory;
        this.searchPatternProcessor = searchFactory != null ? searchFactory.createSearchPatternProcessor() : null;
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        this.indexer.addFieldReference(fieldName);
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[][] tokens, boolean onDemand, int modifiers) {
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
        this.indexer.addMethodReference(methodName, argCount);
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        int i = 0;
        while (i < length - 1) {
            this.acceptUnknownReference(typeName[i], 0);
            ++i;
        }
        this.acceptTypeReference(typeName[length - 1], 0);
    }

    public void acceptTypeReference(char[] simpleTypeName, int sourcePosition) {
        this.indexer.addTypeReference(simpleTypeName);
    }

    public void acceptUnknownReference(char[][] name, int sourceStart, int sourceEnd) {
        int i = 0;
        while (i < name.length) {
            this.acceptUnknownReference(name[i], 0);
            ++i;
        }
    }

    public void acceptUnknownReference(char[] name, int sourcePosition) {
        this.indexer.addNameReference(name);
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] qualification = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superclasses != null) {
            int i = 0;
            int length = typeInfo.superclasses.length;
            while (i < length) {
                typeInfo.superclasses[i] = this.getSimpleName(typeInfo.superclasses[i]);
                ++i;
            }
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add constructore references...");
            }
        }
        char[][] typeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        this.indexer.addTypeDeclaration(typeInfo.modifiers, this.pkgName, typeInfo.name, typeNames, typeInfo.superclasses);
        this.pushTypeName(typeInfo.name.toCharArray());
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.indexer.addConstructorDeclaration(methodInfo.name, methodInfo.parameterNames, methodInfo.exceptionTypes);
        ++this.methodDepth;
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        this.indexer.addFieldDeclaration(fieldInfo.name.toCharArray());
        ++this.methodDepth;
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        this.indexer.addMethodDeclaration(methodInfo.modifiers, this.pkgName, this.enclosingTypeNames(), methodInfo.name, methodInfo.parameterNames, methodInfo.exceptionTypes);
        ++this.methodDepth;
    }

    public void exitType(int declarationEnd) {
        this.popTypeName();
    }

    private String getSimpleName(String typeName) {
        if (this.searchPatternProcessor != null) {
            return this.searchPatternProcessor.extractTypeChars(typeName);
        }
        return typeName;
    }

    public void popTypeName() {
        if (this.depth > 0) {
            this.enclosingTypeNames[--this.depth] = null;
        }
    }

    public void pushTypeName(char[] typeName) {
        if (this.depth == this.enclosingTypeNames.length) {
            char[][] cArrayArray = new char[this.depth * 2][];
            this.enclosingTypeNames = cArrayArray;
            System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = typeName;
    }

    public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo info) {
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add replace method code.");
        }
    }

    public void enterModule() {
    }

    public void exitField(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitMethod(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitModule(int declarationEnd) {
    }

    public void setPackageName(String pkgName) {
        this.pkgName = pkgName.toCharArray();
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
    }

    public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo info) {
        this.indexer.addFieldDeclaration(info.name.toCharArray());
        ++this.methodDepth;
        return true;
    }

    public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
        this.enterMethod(info);
        return true;
    }

    public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
        this.indexer.addFieldDeclaration(info.name.toCharArray());
        ++this.methodDepth;
        return true;
    }

    public boolean enterTypeAppend(ISourceElementRequestor.TypeInfo info, String fullName, String delimiter) {
        this.enterType(info);
        return true;
    }

    public void enterModuleRoot() {
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        return false;
    }

    public void exitModuleRoot() {
    }
}

