/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.structure;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.caching.StructureModelProcessor;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.ModelManager;

public class StructureIndexer
extends AbstractIndexer {
    private final org.eclipse.dltk.core.ISourceModule sourceModule;
    static long maxWorkTime = 0L;

    public StructureIndexer(SearchDocument document, org.eclipse.dltk.core.ISourceModule module) {
        super(document);
        this.sourceModule = module;
    }

    public void indexDocument() {
        long ended;
        boolean performed;
        SourceIndexerRequestor requestor;
        long started;
        block11: {
            IContentCache coreCache;
            InputStream stream;
            started = System.currentTimeMillis();
            IDLTKLanguageToolkit toolkit = this.document.getToolkit();
            if (toolkit == null) {
                toolkit = DLTKLanguageManager.findToolkit((IPath)new Path(this.document.getPath()));
            }
            if (toolkit == null) {
                return;
            }
            requestor = this.document.requestor;
            if (requestor == null) {
                requestor = ModelManager.getModelManager().indexManager.getSourceRequestor(this.sourceModule.getScriptProject());
            }
            requestor.setIndexer(this);
            if (!this.document.isExternal()) {
                String pkgName = "";
                IScriptFolder folder = (IScriptFolder)this.sourceModule.getParent();
                pkgName = folder.getElementName();
                requestor.setPackageName(pkgName);
            } else {
                Path path = new Path(this.document.getPath());
                String ppath = path.toString();
                String pkgName = new Path(ppath.substring(ppath.indexOf("|") + 1)).removeLastSegments(1).toString();
                requestor.setPackageName(pkgName);
            }
            performed = false;
            IFileHandle handle = EnvironmentPathUtils.getFile(this.sourceModule);
            if (handle != null && (stream = (coreCache = ModelManager.getModelManager().getCoreCache()).getCacheEntryAttribute(handle, "_sind")) != null) {
                try {
                    StructureModelProcessor processor = new StructureModelProcessor(stream, requestor);
                    processor.perform();
                    performed = true;
                    stream.close();
                }
                catch (IOException e) {
                    performed = false;
                    if (!DLTKCore.DEBUG) break block11;
                    e.printStackTrace();
                }
            }
        }
        if (!performed) {
            ISourceElementParser parser = this.document.getParser();
            if (parser == null) {
                parser = DLTKLanguageManager.getSourceElementParser(this.sourceModule);
            }
            ISourceModuleInfoCache cache = ModelManager.getModelManager().getSourceModuleInfoCache();
            ISourceModuleInfoCache.ISourceModuleInfo info = cache.get(this.sourceModule);
            parser.setRequestor(requestor);
            parser.parseSourceModule(new ParserInput(this.document, this.sourceModule), info);
        }
        if ((ended = System.currentTimeMillis()) - started > maxWorkTime) {
            maxWorkTime = ended - started;
        }
    }

    private static class ParserInput
    implements ISourceModule {
        private final SearchDocument document;
        private org.eclipse.dltk.core.ISourceModule module;

        public ParserInput(SearchDocument document, org.eclipse.dltk.core.ISourceModule module) {
            this.document = document;
            this.module = module;
        }

        public char[] getContentsAsCharArray() {
            try {
                return this.module.getSourceAsCharArray();
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        public IModelElement getModelElement() {
            return this.module;
        }

        public IPath getScriptFolder() {
            return new Path(this.document.getPath()).removeLastSegments(1);
        }

        public String getSourceContents() {
            if (this.module != null) {
                try {
                    return this.module.getSource();
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            }
            return this.document.getContents();
        }

        public char[] getFileName() {
            return this.document.getPath().toCharArray();
        }
    }
}

