/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

public class ExternalStorageEditorInput
implements IEditorInput,
IStorageEditorInput {
    private IStorage fStorage;

    public ExternalStorageEditorInput(IStorage storage) {
        this.fStorage = storage;
    }

    public boolean exists() {
        return this.fStorage != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fStorage.getName());
    }

    public String getName() {
        return this.fStorage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        IEnvironment environment;
        IPath path = this.fStorage.getFullPath();
        if (path == null) {
            return "";
        }
        if (this.fStorage instanceof IModelElement && (environment = EnvironmentManager.getEnvironment((IModelElement)((IModelElement)this.fStorage))) != null) {
            return environment.convertPathToString(path);
        }
        return path.toOSString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IModelElement.class && this.fStorage instanceof IModelElement) {
            return this.fStorage;
        }
        return null;
    }

    public IStorage getStorage() {
        return this.fStorage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalStorageEditorInput)) {
            return false;
        }
        ExternalStorageEditorInput other = (ExternalStorageEditorInput)obj;
        return this.fStorage.equals(other.fStorage);
    }

    public int hashCode() {
        return this.fStorage.hashCode();
    }

    public IPath getPath(Object element) {
        return this.fStorage.getFullPath();
    }
}

