/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.debug.ui.ScriptDebugImageDescriptor;
import org.eclipse.dltk.debug.ui.ScriptDebugImages;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;

public class JavaScriptDebugModelPresentation
extends ScriptDebugModelPresentation {
    private static final String JS_EDITOR_ID = "org.eclipse.dltk.javascript.ui.editor.JavascriptEditor";
    static ImageRegistry registry = new ImageRegistry(Display.getDefault());

    static {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DLTKPluginImages.get((String)"IMG_OBJS_CONTENDED_MONITOR");
            }
        });
    }

    protected Image getBreakpointImage(IScriptBreakpoint breakpoint) {
        if (breakpoint instanceof IScriptWatchpoint) {
            IScriptWatchpoint w = (IScriptWatchpoint)breakpoint;
            try {
                if (w.isEnabled()) {
                    return DebugUITools.getImage((String)"IMG_OBJS_WATCHPOINT");
                }
            }
            catch (CoreException e) {
                DLTKDebugPlugin.log((Throwable)e);
            }
            return DebugUITools.getImage((String)"IMG_OBJS_WATCHPOINT_DISABLED");
        }
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            IScriptMethodEntryBreakpoint ll = (IScriptMethodEntryBreakpoint)breakpoint;
            int flags = 0;
            try {
                if (ll.breakOnEntry()) {
                    flags |= 8;
                }
                if (ll.breakOnExit()) {
                    flags |= 0x10;
                }
                if (flags == 0) {
                    return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
                }
                if (ll.isEnabled()) {
                    String key = String.valueOf(flags) + "enabled";
                    Image image = registry.get(key);
                    if (image == null) {
                        registry.put(key, (ImageDescriptor)new ScriptDebugImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags));
                        return registry.get(key);
                    }
                    return image;
                }
                String key = String.valueOf(flags) + "disabled";
                Image image = registry.get(key);
                if (image == null) {
                    registry.put(key, (ImageDescriptor)new ScriptDebugImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags));
                    return registry.get(key);
                }
                return image;
            }
            catch (CoreException e) {
                DLTKDebugPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    protected Image getVariableImage(IScriptVariable variable) {
        IScriptValue scriptValue;
        IScriptVariable v = variable;
        try {
            scriptValue = (IScriptValue)v.getValue();
        }
        catch (DebugException debugException) {
            return ScriptDebugImages.get((String)"IMG_OBJS_LOCAL_VARIABLE");
        }
        String typeString = scriptValue.getType().getName();
        if (typeString.equals("function")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methpri_obj.gif");
        }
        if (typeString.equals("javaclass")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.gif");
        }
        if (typeString.equals("javaobject")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methpro_obj.gif");
        }
        if (typeString.equals("javaarray")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methdef_obj.gif");
        }
        String fullName = scriptValue.getEvalName();
        if (fullName != null && (fullName.indexOf(46) >= 0 || fullName.equals("this"))) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methpub_obj.gif");
        }
        return ScriptDebugImages.get((String)"IMG_OBJS_LOCAL_VARIABLE");
    }

    public String getEditorId(IEditorInput input, Object element) {
        return JS_EDITOR_ID;
    }
}

