/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.FakeField;
import org.eclipse.dltk.internal.javascript.typeinference.IProposalHolder;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;

public class UnknownReference
implements IReference,
SelfCompletingReference {
    private String name;
    private final boolean childIsh;
    boolean fRef;
    boolean local;
    protected ModelElement parent;
    private int offset;
    private int length;
    private Map childs;
    private char[][] parameterNames;
    private String proposalInfo;
    protected UnknownReference parentRef;
    private URL imageUrl;
    private String returnType;

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public UnknownReference(String paramOrVarName, boolean childIsh) {
        this.name = paramOrVarName;
        this.childIsh = childIsh;
    }

    public void setLocationInformation(ModelElement parent, int offset, int length) {
        this.parent = parent;
        this.length = length;
        this.offset = offset;
    }

    public Set getChilds(boolean resolveLocals) {
        if (this.childs == null) {
            this.childs = new HashMap(3);
            this.createChilds();
        }
        return new HashSet(this.childs.values());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getParentName() {
        return this.name;
    }

    public IReference getChild(String key, boolean resolveLocals) {
        if (this.childs == null) {
            this.childs = new HashMap(3);
            this.createChilds();
        }
        IReference r = (IReference)this.childs.get(key);
        return r;
    }

    protected void createChilds() {
    }

    public void setChild(String key, IReference ref) {
        if (this.childs == null) {
            this.childs = new HashMap(3);
            this.createChilds();
        }
        ref = this.testRecursion(ref);
        this.childs.put(key, ref);
    }

    private IReference testRecursion(IReference ref) {
        if (ref instanceof UnknownReference) {
            UnknownReference ssr = (UnknownReference)ref;
            ssr.parentRef = this;
            if (this.parentRef != null) {
                HashSet<UnknownReference> set = new HashSet<UnknownReference>();
                set.add(this.parentRef);
                IReference child = this.parentRef.findEqualParent(ref, set);
                if (child != null) {
                    ref = child;
                }
            }
        }
        return ref;
    }

    private IReference findEqualParent(IReference ref, Set parents) {
        if (this.equals(ref)) {
            return this;
        }
        if (this.parentRef != null && !parents.contains(this.parentRef)) {
            parents.add(this.parentRef);
            return this.parentRef.findEqualParent(ref, parents);
        }
        return null;
    }

    public boolean isChildishReference() {
        return this.childIsh;
    }

    public void recordDelete(String fieldId) {
        if (this.childs == null) {
            return;
        }
        this.childs.remove(fieldId);
    }

    public IReference getPrototype(boolean resolveLocals) {
        return this.getChild("prototype", true);
    }

    public void setPrototype(IReference ref) {
        this.setChild("prototype", ref);
    }

    public void addModelElements(Collection toAdd) {
        if (this.parent != null) {
            if (this.isFunctionRef()) {
                String[] params = null;
                char[][] parameterNames = this.getParameterNames();
                if (parameterNames != null) {
                    params = new String[parameterNames.length];
                    int i = 0;
                    while (i < parameterNames.length) {
                        params[i] = new String(parameterNames[i]);
                        ++i;
                    }
                }
                MethodReference method = new MethodReference(this.parent, this.name, params, this.getProposalInfo());
                toAdd.add(method);
            } else {
                FakeField fakeField = new FakeField(this.parent, this.name, this.offset, this.length);
                fakeField.setProposalInfo(this.getProposalInfo());
                toAdd.add(fakeField);
            }
        }
    }

    public boolean isFunctionRef() {
        return this.fRef;
    }

    public UnknownReference setFunctionRef() {
        this.fRef = true;
        return this;
    }

    public char[][] getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(char[][] parameterNames) {
        this.parameterNames = parameterNames;
    }

    public String getProposalInfo() {
        return this.proposalInfo;
    }

    public URL getImageURL() {
        return this.imageUrl;
    }

    public void setImageUrl(URL imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setProposalInfo(String proposalInfo) {
        this.proposalInfo = proposalInfo;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnknownReference) {
            UnknownReference ur = (UnknownReference)obj;
            return ur.name.equals(this.name) && this.fRef == ur.fRef && this.childIsh == ur.childIsh && this.fRef == ur.fRef && this.local == ur.local && ur.offset == this.offset && this.length == ur.length;
        }
        return false;
    }

    public int getKind() {
        return this.isFunctionRef() ? 5 : 4;
    }

    private static class MethodReference
    extends SourceMethod
    implements IProposalHolder {
        private final String[] parameters;
        private final String proposalInfo;

        public MethodReference(ModelElement parent, String name, String[] parameters, String proposalInfo) {
            super(parent, name);
            this.parameters = parameters;
            this.proposalInfo = proposalInfo;
        }

        public String[] getParameters() throws ModelException {
            if (this.parameters == null) {
                return new String[0];
            }
            return this.parameters;
        }

        public String getProposalInfo() {
            return this.proposalInfo;
        }

        public String[] getParameterInitializers() throws ModelException {
            return null;
        }

        public boolean exists() {
            return true;
        }
    }
}

