/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist.completion;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IClassReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.core.codeassist.AssitUtils;
import org.eclipse.dltk.javascript.internal.core.mixin.JavaScriptMixinModel;

public class JavaScriptCompletionEngine
extends ScriptCompletionEngine {
    private boolean useEngine = true;
    AssitUtils.PositionCalculator calculator;

    public boolean isUseEngine() {
        return this.useEngine;
    }

    public void setUseEngine(boolean useEngine) {
        this.useEngine = useEngine;
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    public IAssistParser getParser() {
        return null;
    }

    public void complete(ISourceModule cu, int position, int i) {
        this.actualCompletionPosition = position;
        this.requestor.beginReporting();
        String content = cu.getSourceContents();
        if (position < 0 || position > content.length()) {
            return;
        }
        if (position > 0) {
            if (content.charAt(position - 1) == '.') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            }
            if (position > 0 && content.charAt(position - 1) == '=') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            }
        }
        this.calculator = new AssitUtils.PositionCalculator(content, position, false);
        char[] fileName2 = cu.getFileName();
        ReferenceResolverContext buildContext = AssitUtils.buildContext((org.eclipse.dltk.core.ISourceModule)cu, position, content, fileName2);
        HostCollection collection = buildContext.getHostCollection();
        String startPart = this.calculator.getCompletion();
        this.setSourceRange(position - startPart.length(), position);
        if (this.calculator.isMember()) {
            this.doCompletionOnMember(buildContext, cu, position, content, position, collection);
        } else {
            this.doGlobalCompletion(buildContext, cu, position, position, collection, startPart);
        }
        this.requestor.endReporting();
    }

    private void doGlobalCompletion(ReferenceResolverContext buildContext, ISourceModule cu, int position, int pos, HostCollection collection, String startPart) {
        Object name;
        Iterator<Object> iterator;
        char[][] choices;
        HashSet<String> completedNames = new HashSet<String>();
        String completion = startPart;
        char[] token = completion.toCharArray();
        HashMap names = new HashMap();
        Set resolveGlobals = buildContext.resolveGlobals(completion);
        Iterator<Object> it = resolveGlobals.iterator();
        HashSet<IReference> classes = new HashSet<IReference>();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IReference)) continue;
            IReference r = (IReference)o;
            if (r instanceof IClassReference) {
                classes.add(r);
                continue;
            }
            this.putAndCheckDuplicateReference(names, r);
        }
        names.remove("!!!returnValue");
        this.completeFromMap(position, completion, names);
        if (names.size() > 0) {
            choices = new char[names.size()][];
            int ia = 0;
            iterator = names.keySet().iterator();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                choices[ia] = ((String)name).toCharArray();
                ++ia;
            }
            this.findLocalVariables(token, choices, true, false);
        }
        if (classes.size() > 0) {
            choices = new char[classes.size()][];
            int ia = 0;
            iterator = classes.iterator();
            while (iterator.hasNext()) {
                name = (IReference)iterator.next();
                choices[ia] = name.getName().toCharArray();
                ++ia;
            }
            this.findElements(token, choices, true, false, 7);
        }
        if (this.useEngine) {
            this.doCompletionOnKeyword(position, pos, completion);
            JavaScriptMixinModel instance = JavaScriptMixinModel.getInstance();
            String[] findElements = instance.findElements(String.valueOf(MixinModel.SEPARATOR) + completion);
            ArrayList<IModelElement> methods = new ArrayList<IModelElement>();
            ArrayList<char[]> fields = new ArrayList<char[]>();
            int a = 0;
            while (a < findElements.length) {
                Object[] allObjects;
                IMixinElement mixinElement;
                String string = findElements[a];
                if (string.lastIndexOf(MixinModel.SEPARATOR) <= 0 && (mixinElement = instance.getRawModel().get(string)) != null && (allObjects = mixinElement.getObjects(buildContext.getModule())).length > 0) {
                    int i = 0;
                    while (i < allObjects.length) {
                        String lastKeySegment;
                        Object object = allObjects[i];
                        if (object instanceof IModelElement) {
                            String elementName;
                            IModelElement el = (IModelElement)object;
                            int elementType = el.getElementType();
                            if (elementType == 9) {
                                methods.add(el);
                            } else if (elementType == 8 && !completedNames.contains(elementName = el.getElementName())) {
                                fields.add(elementName.toCharArray());
                                completedNames.add(elementName);
                            }
                        } else if (object == null && !completedNames.contains(lastKeySegment = mixinElement.getLastKeySegment())) {
                            fields.add(lastKeySegment.toCharArray());
                            completedNames.add(lastKeySegment);
                        }
                        ++i;
                    }
                }
                ++a;
            }
            this.findMethods(token, true, methods);
            char[][] choices2 = new char[fields.size()][];
            int a2 = 0;
            while (a2 < fields.size()) {
                choices2[a2] = (char[])fields.get(a2);
                ++a2;
            }
            this.findLocalVariables(token, choices2, true, false);
        }
        Map rfs = collection.getReferences();
        while (collection.getParent() != null) {
            collection = collection.getParent();
            Map m1 = collection.getReferences();
            it = m1.keySet().iterator();
            while (it.hasNext()) {
                String key;
                Object next = it.next();
                if (!(next instanceof String) || rfs.containsKey(key = (String)next)) continue;
                rfs.put(key, m1.get(key));
            }
        }
        it = rfs.keySet().iterator();
        while (it.hasNext()) {
            String name2;
            Object next = it.next();
            if (!(next instanceof String) || completedNames.contains(name2 = (String)next)) continue;
            names.put(name2, rfs.get(name2));
        }
        names.remove("!!!returnValue");
        if (names.size() > 0) {
            this.completeFromMap(position, completion, names);
        }
    }

    private void doCompletionOnMember(ReferenceResolverContext buildContext, ISourceModule cu, int position, String content, int pos, HostCollection collection) {
        String completionPart = this.calculator.getCompletionPart();
        String corePart = this.calculator.getCorePart();
        HashMap<String, IReference> dubR = new HashMap<String, IReference>();
        Set resolveGlobals = buildContext.resolveGlobals(String.valueOf(corePart) + '.');
        Iterator it = resolveGlobals.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IReference)) continue;
            IReference r = (IReference)o;
            this.putAndCheckDuplicateReference(dubR, r);
        }
        this.completeFromMap(position, completionPart, dubR);
        Set references = collection.queryElements(corePart, true);
        if (!references.isEmpty()) {
            Object next;
            Iterator iterator = references.iterator();
            HashSet fields = new HashSet();
            while (iterator.hasNext()) {
                next = iterator.next();
                if (!(next instanceof IReference)) continue;
                IReference mnext = (IReference)next;
                IReference proto = mnext.getPrototype(true);
                if (proto != null) {
                    AbstractCollection protos = new LinkedHashSet<IReference>();
                    while (proto != null && !protos.contains(proto)) {
                        protos.add(proto);
                        proto = proto.getPrototype(false);
                    }
                    protos = new LinkedList(protos);
                    Collections.reverse((List)((Object)protos));
                    Iterator iterator2 = protos.iterator();
                    while (iterator2.hasNext()) {
                        IReference proto1 = (IReference)iterator2.next();
                        fields.addAll(proto1.getChilds(true));
                    }
                }
                fields.addAll(mnext.getChilds(true));
            }
            iterator = fields.iterator();
            while (iterator.hasNext()) {
                next = iterator.next();
                if (!(next instanceof IReference)) continue;
                IReference name = (IReference)next;
                String refa = name.getName();
                dubR.put(refa, name);
            }
            this.completeFromMap(position, completionPart, dubR);
        }
    }

    private void putAndCheckDuplicateReference(HashMap dubR, IReference r) {
        IReference put = dubR.put(r.getName(), r);
        if (put instanceof IReference) {
            if (r instanceof CombinedOrReference) {
                ((CombinedOrReference)r).addReference(put);
            } else if (put instanceof CombinedOrReference) {
                ((CombinedOrReference)put).addReference(r);
                dubR.put(r.getName(), put);
            } else {
                CombinedOrReference or = new CombinedOrReference();
                or.addReference(r);
                or.addReference(put);
                dubR.put(r.getName(), or);
            }
        }
    }

    private void completeFromMap(int position, String completionPart, HashMap dubR) {
        this.requestor.acceptContext(new CompletionContext());
        this.setSourceRange(position - completionPart.length(), position);
        char[] token = completionPart.toCharArray();
        int length = token.length;
        Iterator iterator = dubR.values().iterator();
        while (iterator.hasNext()) {
            CompletionProposal createProposal;
            char[] name;
            int knd;
            Object next = iterator.next();
            if (next instanceof SelfCompletingReference) {
                SelfCompletingReference cm = (SelfCompletingReference)next;
                knd = cm.getKind();
                name = cm.getName().toCharArray();
                if (length <= name.length && CharOperation.prefixEquals((char[])token, (char[])name, (boolean)false)) {
                    createProposal = this.createProposal(knd, this.actualCompletionPosition);
                    createProposal.setName(name);
                    createProposal.setCompletion(name);
                    createProposal.extraInfo = cm;
                    createProposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                    this.requestor.accept(createProposal);
                }
                iterator.remove();
                continue;
            }
            if (!(next instanceof IReference)) continue;
            IReference ref = (IReference)next;
            knd = ref.isFunctionRef() ? 5 : 4;
            name = ref.getName().toCharArray();
            if (length <= name.length && CharOperation.prefixEquals((char[])token, (char[])name, (boolean)false)) {
                createProposal = this.createProposal(knd, this.actualCompletionPosition);
                createProposal.setName(name);
                createProposal.setCompletion(name);
                createProposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                this.requestor.accept(createProposal);
            }
            iterator.remove();
        }
    }

    int computeBaseRelevance() {
        return 0;
    }

    private int computeRelevanceForInterestingProposal() {
        return 5;
    }

    protected int computeRelevanceForRestrictions(int accessRuleKind) {
        if (accessRuleKind == 0) {
            return 3;
        }
        return 0;
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List methods, int kind) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                IMethod method = (IMethod)methods.get(i);
                String qname = this.processMethodName(method, tok);
                char[] name = qname.toCharArray();
                if (DLTKCore.DEBUG_COMPLETION) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length && CharOperation.prefixEquals((char[])token, (char[])name, (boolean)false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        String[] arguments = null;
                        try {
                            arguments = method.getParameters();
                        }
                        catch (ModelException modelException) {}
                        if (arguments != null && arguments.length > 0) {
                            char[][] args = new char[arguments.length][];
                            int j = 0;
                            while (j < arguments.length) {
                                args[j] = arguments[j].toCharArray();
                                ++j;
                            }
                            proposal.setParameterNames((char[][])args);
                        }
                        if (kind == 5) {
                            StringBuffer sig = new StringBuffer();
                            sig.append(method.getElementName());
                            sig.append('(');
                            if (arguments != null) {
                                int a = 0;
                                while (a < arguments.length) {
                                    sig.append('L');
                                    sig.append("Object");
                                    sig.append(';');
                                    ++a;
                                }
                            }
                            sig.append(')');
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.extraInfo = method;
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void doCompletionOnKeyword(int position, int pos, String startPart) {
        String[] keywords = JavaScriptKeywords.getJavaScriptKeywords();
        char[][] keyWordsArray = new char[keywords.length][];
        int a = 0;
        while (a < keywords.length) {
            keyWordsArray[a] = keywords[a].toCharArray();
            ++a;
        }
        this.findKeywords(startPart.toCharArray(), keyWordsArray, true);
    }

    protected String processFieldName(IField field, String token) {
        return null;
    }
}

