/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.launching;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.javascript.internal.launching.ClasspathUtils;
import org.eclipse.dltk.javascript.launching.IConfigurableRunner;
import org.eclipse.dltk.javascript.launching.IJavaScriptInterpreterRunnerConfig;
import org.eclipse.dltk.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JavaScriptInterpreterRunner
extends AbstractInterpreterRunner
implements IConfigurableRunner {
    public static final IJavaScriptInterpreterRunnerConfig DEFAULT_CONFIG = new IJavaScriptInterpreterRunnerConfig(){

        public void adjustRunnerConfiguration(VMRunnerConfiguration vconfig, InterpreterConfig iconfig, ILaunch launch, IJavaProject project) {
        }

        public String[] computeClassPath(InterpreterConfig config, ILaunch launch, IJavaProject project) throws Exception {
            return JavaScriptInterpreterRunner.getClassPath(project);
        }

        public String[] getProgramArguments(InterpreterConfig config, ILaunch launch, IJavaProject project) {
            return CharOperation.NO_STRINGS;
        }

        public String getRunnerClassName(InterpreterConfig config, ILaunch launch, IJavaProject project) {
            return "RhinoRunner";
        }
    };
    private IJavaScriptInterpreterRunnerConfig config = DEFAULT_CONFIG;

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        JavaScriptInterpreterRunner.doRunImpl(config, launch, this.config);
    }

    public static void doRunImpl(InterpreterConfig config, ILaunch launch, IJavaScriptInterpreterRunnerConfig iconfig) throws CoreException {
        IVMRunner vmRunner;
        IScriptProject proj;
        IJavaProject myJavaProject;
        IVMInstall vmInstall;
        String sessionId;
        String port;
        String host = (String)config.getProperty("host");
        if (host == null) {
            host = "";
        }
        if ((port = (String)config.getProperty("port")) == null) {
            port = "";
        }
        if ((sessionId = (String)config.getProperty("sessionId")) == null) {
            sessionId = "";
        }
        IVMInstall iVMInstall = vmInstall = (myJavaProject = JavaCore.create((IProject)(proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)launch.getLaunchConfiguration())).getProject())).exists() ? JavaRuntime.getVMInstall((IJavaProject)myJavaProject) : JavaRuntime.getDefaultVMInstall();
        if (vmInstall != null && (vmRunner = vmInstall.getVMRunner("debug")) != null) {
            try {
                try {
                    String[] newClassPath = JavaScriptInterpreterRunner.getClassPath(myJavaProject);
                    VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(iconfig.getRunnerClassName(config, launch, myJavaProject), newClassPath);
                    IPath scriptFilePath = config.getScriptFilePath();
                    if (scriptFilePath == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.debug", "Script File name is not specified..."));
                    }
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(scriptFilePath.toPortableString());
                    args.add(host);
                    args.add(port);
                    args.add(sessionId);
                    String[] newStrings = iconfig.getProgramArguments(config, launch, myJavaProject);
                    if (newStrings.length != 0) {
                        args.addAll(Arrays.asList(newStrings));
                    }
                    vmConfig.setProgramArguments(args.toArray(new String[args.size()]));
                    Launch launchr = new Launch(launch.getLaunchConfiguration(), "debug", null);
                    iconfig.adjustRunnerConfiguration(vmConfig, config, launch, myJavaProject);
                    vmRunner.run(vmConfig, (ILaunch)launchr, null);
                    IDebugTarget[] debugTargets = launchr.getDebugTargets();
                    int a = 0;
                    while (a < debugTargets.length) {
                        launch.addDebugTarget(debugTargets[a]);
                        ++a;
                    }
                    IProcess[] processes = launchr.getProcesses();
                    int a2 = 0;
                    while (a2 < processes.length) {
                        launch.addProcess(processes[a2]);
                        ++a2;
                    }
                    return;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.launching", "JRE is not configured"));
    }

    public static String[] getClassPath(IJavaProject myJavaProject) throws IOException, URISyntaxException {
        ArrayList<String> result = new ArrayList<String>();
        ClasspathUtils.collectClasspath(new String[]{"org.eclipse.dltk.javascript.rhino", "org.eclipse.dltk.javascript.rhino.dbgp"}, result);
        try {
            String[] classPath = JavaScriptInterpreterRunner.computeBaseClassPath(myJavaProject);
            int i = 0;
            while (i < classPath.length) {
                result.add(classPath[i]);
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result.toArray(new String[result.size()]);
    }

    protected static String[] computeBaseClassPath(IJavaProject myJavaProject) throws CoreException {
        if (!myJavaProject.exists()) {
            return CharOperation.NO_STRINGS;
        }
        return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)myJavaProject);
    }

    public JavaScriptInterpreterRunner(IInterpreterInstall install) {
        super(install);
    }

    protected String getProcessType() {
        return "javascriptInterpreter";
    }

    public void setRunnerConfig(IJavaScriptInterpreterRunnerConfig config) {
        this.config = config;
    }
}

