/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;

public class JavaScriptSourceElementRequestor
extends SourceElementRequestVisitor {
    private List fNotAddedFields = new ArrayList();
    private Map fTypeVariables = new HashMap();

    public JavaScriptSourceElementRequestor(ISourceElementRequestor requestor) {
        super(requestor);
    }

    protected String makeLanguageDependentValue(Expression value) {
        String outValue = "";
        return outValue;
    }

    private void addVariableReference(Expression left, Expression right, boolean inClass, boolean inMethod) {
        if (left == null) {
            throw new RuntimeException("addVariable expression can't be null");
        }
        if (left instanceof VariableReference) {
            VariableReference var = (VariableReference)left;
            if (!inMethod && this.canAddVariables((ASTNode)this.fNodes.peek(), var.getName())) {
                ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
                info.modifiers = 256;
                info.name = var.getName();
                info.nameSourceEnd = var.sourceEnd() - 1;
                info.nameSourceStart = var.sourceStart();
                info.declarationStart = var.sourceStart();
                this.fRequestor.enterField(info);
                if (right != null) {
                    this.fRequestor.exitField(right.sourceEnd() - 1);
                } else {
                    this.fRequestor.exitField(var.sourceEnd() - 1);
                }
            }
        }
    }

    public boolean visit(Expression expression) throws Exception {
        return true;
    }

    public boolean endvisit(Expression expression) throws Exception {
        return true;
    }

    protected void onEndVisitMethod(MethodDeclaration method) {
        Iterator i = this.fNotAddedFields.iterator();
        while (i.hasNext()) {
            TypeField field = (TypeField)i.next();
            if (!this.canAddVariables(field.getToNode(), field.getName())) continue;
            PositionInformation pos = field.getPos();
            ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
            info.modifiers = 256;
            info.name = field.getName();
            info.nameSourceEnd = pos.nameEnd - 1;
            info.nameSourceStart = pos.nameStart;
            info.declarationStart = pos.sourceStart;
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(pos.sourceEnd);
        }
        this.fNotAddedFields.clear();
    }

    public boolean visit(Statement statement) throws Exception {
        return true;
    }

    private boolean canAddVariables(ASTNode type, String name) {
        if (this.fTypeVariables.containsKey(type)) {
            List variables = (List)this.fTypeVariables.get(type);
            if (variables.contains(name)) {
                return false;
            }
            variables.add(name);
            return true;
        }
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(name);
        this.fTypeVariables.put(type, variables);
        return true;
    }

    public boolean endvisit(Statement s) throws Exception {
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        this.fNodes.push(method);
        List args = method.getArguments();
        String[] parameter = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            Argument arg = (Argument)args.get(a);
            parameter[a] = arg.getName();
            ++a;
        }
        ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
        mi.parameterNames = parameter;
        mi.name = method.getName();
        mi.modifiers = method.getModifiers();
        mi.nameSourceStart = method.getNameStart();
        mi.nameSourceEnd = method.getNameEnd() - 1;
        mi.declarationStart = method.sourceStart();
        this.fRequestor.enterMethodRemoveSame(mi);
        this.fInMethod = true;
        this.fCurrentMethod = method;
        return true;
    }

    private static class TypeField {
        private String fName;
        private String fInitValue;
        private PositionInformation fPos;
        private Expression fExpression;
        private ASTNode fToNode;

        TypeField(String name, String initValue, PositionInformation pos, Expression expression, ASTNode toNode) {
            this.fName = name;
            this.fInitValue = initValue;
            this.fPos = pos;
            this.fExpression = expression;
            this.fToNode = toNode;
        }

        String getName() {
            return this.fName;
        }

        String getInitValue() {
            return this.fInitValue;
        }

        PositionInformation getPos() {
            return this.fPos;
        }

        Expression getExpression() {
            return this.fExpression;
        }

        ASTNode getToNode() {
            return this.fToNode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeField) {
                TypeField second = (TypeField)obj;
                return second.fName.equals(this.fName) && second.fToNode.equals((Object)this.fToNode);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.fName;
        }
    }
}

