/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CreateFolderOperation
extends BuildpathModifierOperation {
    private final BuildpathModifier.IBuildpathModifierListener fListener;
    private final IBuildpathInformationProvider fCPInformationProvider;

    public CreateFolderOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_tooltip, 10);
        this.fListener = listener;
        this.fCPInformationProvider = informationProvider;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        GenerateBuildPathActionGroup.CreateLocalSourceFolderAction action = new GenerateBuildPathActionGroup.CreateLocalSourceFolderAction();
        action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.fCPInformationProvider.getScriptProject()));
        action.run();
        IProjectFragment createdElement = (IProjectFragment)action.getCreatedElement();
        if (createdElement == null) {
            return;
        }
        try {
            IResource correspondingResource = createdElement.getCorrespondingResource();
            ArrayList<IResource> result = new ArrayList<IResource>();
            result.add(correspondingResource);
            if (this.fListener != null) {
                List entries = action.getBPListElements();
                this.fListener.buildpathEntryChanged(entries);
            }
            this.fCPInformationProvider.handleResult(result, null, 10);
        }
        catch (ModelException e) {
            if (monitor == null) {
                this.fCPInformationProvider.handleResult(Collections.EMPTY_LIST, (CoreException)((Object)e), 10);
            }
            throw new InvocationTargetException(e);
        }
    }

    public boolean isValid(List elements, int[] types) throws ModelException {
        return types.length == 1 && types[0] == 1;
    }

    public String getDescription(int type) {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_createNewSourceFolder;
    }
}

