/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.core.packages.TclInterpreterInfo;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclProjectInfo;
import org.eclipse.dltk.tcl.internal.core.packages.ProcessOutputCollector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclPackagesManager {
    private static final String DLTK_TCL = "scripts/dltk.tcl";
    public static final String END_OF_STREAM = "DLTK-TCL-HELPER-9E7A168E-5EEF-4a46-A86D-0C82E90686E4-END-OF-STREAM";
    private static final String PKG_VERSION = "v20090505";
    private static Resource infos = null;
    private static final Map<String, Resource> projectInfos = new HashMap<String, Resource>();

    public static synchronized List<TclPackageInfo> getPackageInfos(IInterpreterInstall install, Set<String> packageNames, boolean fetchIfRequired) {
        TclPackagesManager.initialize();
        TclInterpreterInfo interpreterInfo = TclPackagesManager.getTclInterpreter(install);
        return Collections.unmodifiableList(new ArrayList<TclPackageInfo>(TclPackagesManager.getPackagesForInterpreter(packageNames, fetchIfRequired, interpreterInfo, install)));
    }

    public static synchronized List<TclPackageInfo> getPackageInfos(IInterpreterInstall install) {
        TclPackagesManager.initialize();
        TclInterpreterInfo interpreterInfo = TclPackagesManager.getTclInterpreter(install);
        return Collections.unmodifiableList(new ArrayList<TclPackageInfo>((Collection<TclPackageInfo>)interpreterInfo.getPackages()));
    }

    public static synchronized TclPackageInfo getPackageInfo(IInterpreterInstall install, String name, boolean fetchIfRequired) {
        TclPackagesManager.initialize();
        TclInterpreterInfo interpreterInfo = TclPackagesManager.getTclInterpreter(install);
        EList<TclPackageInfo> packages = interpreterInfo.getPackages();
        for (TclPackageInfo tclPackageInfo : packages) {
            if (!name.equals(tclPackageInfo.getName())) continue;
            if (tclPackageInfo.isFetched() || !fetchIfRequired) {
                return tclPackageInfo;
            }
            HashSet<TclPackageInfo> toFetch = new HashSet<TclPackageInfo>();
            toFetch.add(tclPackageInfo);
            TclPackagesManager.fetchSources(toFetch, install, interpreterInfo);
            return tclPackageInfo;
        }
        return null;
    }

    public static synchronized Set<TclPackageInfo> getDependencies(IInterpreterInstall install, String name, boolean fetchIfRequired) {
        TclPackagesManager.initialize();
        TclPackageInfo info = TclPackagesManager.getPackageInfo(install, name, fetchIfRequired);
        if (info != null) {
            HashSet<TclPackageInfo> result = new HashSet<TclPackageInfo>();
            HashSet<TclPackageInfo> toFetch = new HashSet<TclPackageInfo>();
            TclPackagesManager.processPackage(info, result, toFetch, fetchIfRequired);
            if (toFetch.size() > 0) {
                TclInterpreterInfo interpreter = TclPackagesManager.getTclInterpreter(install);
                TclPackagesManager.fetchSources(toFetch, install, interpreter);
                TclPackagesManager.processPackage(info, result, toFetch, fetchIfRequired);
            }
            result.remove(info);
            return result;
        }
        return null;
    }

    private static synchronized TclInterpreterInfo getTclInterpreter(IInterpreterInstall install) {
        EList contents = infos.getContents();
        TclInterpreterInfo interpreterInfo = null;
        String interpreterLocation = install.getInstallLocation().toOSString();
        String environmentId = install.getInstallLocation().getEnvironmentId();
        for (EObject eObject : contents) {
            if (!(eObject instanceof TclInterpreterInfo)) continue;
            TclInterpreterInfo info = (TclInterpreterInfo)eObject;
            String location = info.getInstallLocation();
            String name = info.getName();
            String env = info.getEnvironment();
            if (!interpreterLocation.equals(location) || !install.getName().equals(name) || env == null || !env.equals(environmentId)) continue;
            interpreterInfo = info;
            break;
        }
        if (interpreterInfo == null) {
            interpreterInfo = TclPackagesFactory.eINSTANCE.createTclInterpreterInfo();
            interpreterInfo.setInstallLocation(interpreterLocation);
            interpreterInfo.setName(install.getName());
            interpreterInfo.setEnvironment(environmentId);
            infos.getContents().add((Object)interpreterInfo);
        }
        if (!interpreterInfo.isFetched() || interpreterInfo.getFetchedAt() == null || interpreterInfo.getFetchedAt().getTime() + TclPackagesManager.getPackagesRefreshInterval(install) < System.currentTimeMillis()) {
            TclPackagesManager.fetchPackagesForInterpreter(install, interpreterInfo);
        }
        return interpreterInfo;
    }

    private static long getPackagesRefreshInterval(IInterpreterInstall install) {
        return TclPlugin.getDefault().getPluginPreferences().getLong(install.getEnvironment().isLocal() ? "packages.refreshInterval.local" : "packages.refreshInterval.remote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TclProjectInfo getTclProject(String name) {
        Resource resource;
        Resource resource2 = resource = TclPackagesManager.getProjectInfoResource(name);
        synchronized (resource2) {
            TclProjectInfo info = null;
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof TclProjectInfo)) continue;
                TclProjectInfo pinfo = (TclProjectInfo)eObject;
                String pname = pinfo.getName();
                if (name == null || !name.equals(pname)) continue;
                info = pinfo;
            }
            if (info == null) {
                info = TclPackagesFactory.eINSTANCE.createTclProjectInfo();
                info.setName(name);
                resource.getContents().add((Object)info);
            }
            return info;
        }
    }

    private static synchronized void fetchPackagesForInterpreter(IInterpreterInstall install, TclInterpreterInfo interpreterInfo) {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        IExecutionEnvironment exeEnv = install.getExecEnvironment();
        List<String> content = TclPackagesManager.deployExecute(exeEnv, install, new String[]{"get-pkgs"}, install.getEnvironmentVariables());
        if (content != null) {
            TclPackagesManager.processContent(content, false, true, interpreterInfo);
            interpreterInfo.setFetched(true);
            interpreterInfo.setFetchedAt(new Date());
            TclPackagesManager.save();
        }
        p.done("Tcl", "Fetch interpreter packages info", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (infos != null) {
            try {
                infos.save(null);
            }
            catch (IOException iOException) {
            }
        }
        Map<String, Resource> map = projectInfos;
        synchronized (map) {
            for (Map.Entry<String, Resource> entry : projectInfos.entrySet()) {
                try {
                    entry.getValue().save(null);
                }
                catch (IOException e) {
                    String msg = NLS.bind((String)"Error saving {0} state: {1}", (Object)entry.getKey(), (Object)e.getMessage());
                    TclPlugin.error(msg, e);
                }
            }
        }
    }

    private static String getXMLContent(List<String> content) {
        StringBuffer newList = new StringBuffer();
        if (content != null) {
            for (String line : content) {
                if (!line.trim().startsWith("<")) continue;
                newList.append(line).append("\n");
            }
        }
        return newList.toString();
    }

    private static Document getDocument(String text) {
        block6: {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                InputSource source = new InputSource(new StringReader(text));
                Document document = parser.parse(source);
                return document;
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (ParserConfigurationException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (SAXException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    private static synchronized void processContent(List<String> content, boolean markAsFetched, boolean purgePackages, TclInterpreterInfo info) {
        String text = TclPackagesManager.getXMLContent(content);
        Document document = TclPackagesManager.getDocument(text);
        if (document != null) {
            HashSet<String> processedPackages = new HashSet<String>();
            Element element = document.getDocumentElement();
            NodeList childNodes = element.getChildNodes();
            int len = childNodes.getLength();
            int i = 0;
            while (i < len) {
                Node nde = childNodes.item(i);
                if (TclPackagesManager.isElementName(nde, "path")) {
                    Element el = (Element)nde;
                    NodeList elChilds = el.getChildNodes();
                    int j = 0;
                    while (j < elChilds.getLength()) {
                        Node pkgNde = elChilds.item(j);
                        if (TclPackagesManager.isElementName(pkgNde, "package")) {
                            Element pkgElement = (Element)pkgNde;
                            String name = pkgElement.getAttribute("name");
                            processedPackages.add(name);
                            TclPackageInfo pkg = TclPackagesManager.getCreatePackage(info, name);
                            if (markAsFetched) {
                                pkg.setFetched(markAsFetched);
                            }
                            TclPackagesManager.populatePackage(pkg, pkgNde, info);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (purgePackages) {
                Iterator i2 = info.getPackages().iterator();
                while (i2.hasNext()) {
                    TclPackageInfo packageInfo = (TclPackageInfo)i2.next();
                    if (processedPackages.contains(packageInfo.getName())) continue;
                    i2.remove();
                }
            }
        }
    }

    private static synchronized TclPackageInfo getCreatePackage(TclInterpreterInfo info, String name) {
        TclPackageInfo packageInfo = null;
        for (TclPackageInfo pkgInfo : info.getPackages()) {
            if (!pkgInfo.getName().equals(name)) continue;
            packageInfo = pkgInfo;
            break;
        }
        if (packageInfo == null) {
            packageInfo = TclPackagesFactory.eINSTANCE.createTclPackageInfo();
            packageInfo.setFetched(false);
            packageInfo.setName(name);
            info.getPackages().add((Object)packageInfo);
        }
        return packageInfo;
    }

    private static synchronized void populatePackage(TclPackageInfo info, Node pkgNde, TclInterpreterInfo interpreterInfo) {
        Element pkg = (Element)pkgNde;
        info.setVersion(pkg.getAttribute("version"));
        NodeList childs = pkg.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            String name;
            Element el;
            Node nde = childs.item(i);
            if (TclPackagesManager.isElementName(nde, "source")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                info.getSources().add((Object)name);
            } else if (TclPackagesManager.isElementName(nde, "require")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                info.getDependencies().add((Object)TclPackagesManager.getCreatePackage(interpreterInfo, name));
            }
            ++i;
        }
    }

    private static synchronized List<TclPackageInfo> getPackagesForInterpreter(Set<String> packageName, boolean fetchIfRequired, TclInterpreterInfo interpreterInfo, IInterpreterInstall install) {
        HashSet<TclPackageInfo> result = new HashSet<TclPackageInfo>();
        HashSet<TclPackageInfo> toFetch = new HashSet<TclPackageInfo>();
        for (TclPackageInfo tclPackageInfo : interpreterInfo.getPackages()) {
            if (!packageName.contains(tclPackageInfo.getName())) continue;
            TclPackagesManager.processPackage(tclPackageInfo, result, toFetch, fetchIfRequired);
        }
        TclPackagesManager.fetchSources(toFetch, install, interpreterInfo);
        for (TclPackageInfo tclPackageInfo : interpreterInfo.getPackages()) {
            if (!packageName.contains(tclPackageInfo.getName())) continue;
            TclPackagesManager.processPackage(tclPackageInfo, result, toFetch, fetchIfRequired);
        }
        ArrayList<TclPackageInfo> resultList = new ArrayList<TclPackageInfo>();
        resultList.addAll(result);
        return resultList;
    }

    private static synchronized void processPackage(TclPackageInfo tclPackageInfo, Set<TclPackageInfo> result, Set<TclPackageInfo> toFetch, boolean fetchIfRequired) {
        if (tclPackageInfo.isFetched() || !fetchIfRequired) {
            result.add(tclPackageInfo);
        } else if (fetchIfRequired) {
            result.add(tclPackageInfo);
            toFetch.add(tclPackageInfo);
        }
        EList<TclPackageInfo> dependencies = tclPackageInfo.getDependencies();
        for (TclPackageInfo tclPackageInfo2 : dependencies) {
            if (result.contains(tclPackageInfo2)) continue;
            TclPackagesManager.processPackage(tclPackageInfo2, result, toFetch, fetchIfRequired);
        }
    }

    private static synchronized void fetchSources(Set<TclPackageInfo> toFetch, IInterpreterInstall install, TclInterpreterInfo interpreterInfo) {
        if (toFetch.size() == 0) {
            return;
        }
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        IExecutionEnvironment exeEnv = install.getExecEnvironment();
        IDeployment deployment = exeEnv.createDeployment();
        if (deployment == null) {
            return;
        }
        IFileHandle script = TclPackagesManager.deploy(deployment);
        if (script == null) {
            deployment.dispose();
            return;
        }
        IFileHandle workingDir = script.getParent();
        InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])install.getEnvironmentVariables());
        StringBuffer buf = new StringBuffer();
        for (TclPackageInfo tclPackageInfo : toFetch) {
            buf.append(tclPackageInfo.getName()).append(" ");
        }
        String names = buf.toString();
        ByteArrayInputStream bais = new ByteArrayInputStream(names.getBytes());
        IPath packagesPath = null;
        try {
            packagesPath = deployment.add((InputStream)bais, "packages.txt");
        }
        catch (IOException e1) {
            if (DLTKCore.DEBUG) {
                e1.printStackTrace();
            }
            deployment.dispose();
            return;
        }
        IFileHandle file = deployment.getFile(packagesPath);
        config.removeEnvVar("DISPLAY");
        String[] arguments = new String[]{"get-srcs", "-fpkgs", file.toOSString()};
        config.addScriptArgs(arguments);
        Process process = null;
        try {
            process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)install.getInstallLocation().toOSString(), (InterpreterConfig)config);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            deployment.dispose();
        }
        if (process == null) {
            deployment.dispose();
            return;
        }
        List<String> output = ProcessOutputCollector.execute(process);
        TclPackagesManager.processContent(output, true, false, interpreterInfo);
        for (TclPackageInfo info : toFetch) {
            info.setFetched(true);
        }
        deployment.dispose();
        TclPackagesManager.save();
        p.done("Tcl", "Fetch interpreter package sources", 0L);
    }

    private static URI getInfoLocation() {
        IPath path = TclPlugin.getDefault().getStateLocation().append("tclPackages_v20090505.info");
        return URI.createFileURI((String)path.toOSString());
    }

    private static URI getProjectLocation(String projectName) {
        IPath path = TclPlugin.getDefault().getStateLocation().append("project-" + projectName + ".info");
        return URI.createFileURI((String)path.toOSString());
    }

    private static boolean canLoad(URI location) {
        if (location.isFile()) {
            return new File(location.toFileString()).exists();
        }
        return true;
    }

    private static void initialize() {
        if (infos == null) {
            URI location = TclPackagesManager.getInfoLocation();
            infos = new XMIResourceImpl(location);
            try {
                if (TclPackagesManager.canLoad(location)) {
                    infos.load(null);
                }
            }
            catch (IOException e) {
                TclPlugin.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource getProjectInfoResource(String projectName) {
        Resource resource;
        Map<String, Resource> map = projectInfos;
        synchronized (map) {
            resource = projectInfos.get(projectName);
            if (resource != null) {
                return resource;
            }
        }
        URI location = TclPackagesManager.getProjectLocation(projectName);
        resource = new XMIResourceImpl(location);
        try {
            if (TclPackagesManager.canLoad(location)) {
                resource.load(null);
            }
        }
        catch (IOException e) {
            TclPlugin.error(e);
        }
        Map<String, Resource> map2 = projectInfos;
        synchronized (map2) {
            Resource r = projectInfos.get(projectName);
            if (r != null) {
                return r;
            }
            projectInfos.put(projectName, resource);
            return resource;
        }
    }

    private static List<String> deployExecute(IExecutionEnvironment exeEnv, IInterpreterInstall install, String[] arguments, EnvironmentVariable[] env) {
        Process process;
        IDeployment deployment;
        block6: {
            deployment = exeEnv.createDeployment();
            if (deployment == null) {
                return null;
            }
            IFileHandle script = TclPackagesManager.deploy(deployment);
            if (script == null) {
                deployment.dispose();
                return null;
            }
            IFileHandle workingDir = script.getParent();
            InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])env);
            config.removeEnvVar("DISPLAY");
            if (arguments != null) {
                config.addScriptArgs(arguments);
            }
            process = null;
            try {
                process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)install.getInstallLocation().toOSString(), (InterpreterConfig)config);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (process == null) {
            deployment.dispose();
            return null;
        }
        List<String> output = ProcessOutputCollector.execute(process);
        deployment.dispose();
        return output;
    }

    private static IFileHandle deploy(IDeployment deployment) {
        IFileHandle script;
        try {
            IPath path = deployment.add(TclPlugin.getDefault().getBundle(), DLTK_TCL);
            script = deployment.getFile(path);
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        return script;
    }

    private static boolean isElementName(Node nde, String name) {
        return nde != null && nde.getNodeType() == 1 && name.equalsIgnoreCase(nde.getNodeName());
    }

    public static boolean isValidName(String packageName) {
        return packageName != null && packageName.length() != 0 && packageName.indexOf(36) == -1 && packageName.indexOf(91) == -1 && packageName.indexOf(93) == -1;
    }

    public static synchronized List<TclModuleInfo> getProjectModules(String name) {
        TclProjectInfo info = TclPackagesManager.getTclProject(name);
        ArrayList<TclModuleInfo> results = new ArrayList<TclModuleInfo>();
        EList<TclModuleInfo> modules = info.getModules();
        for (TclModuleInfo tclModuleInfo : modules) {
            TclModuleInfo copy = (TclModuleInfo)EcoreUtil.copy((EObject)tclModuleInfo);
            results.add(copy);
        }
        return Collections.unmodifiableList(results);
    }

    public static synchronized void setProjectModules(String name, List<TclModuleInfo> modules) {
        TclProjectInfo info = TclPackagesManager.getTclProject(name);
        info.getModules().clear();
        info.getModules().addAll(modules);
        TclPackagesManager.save();
    }

    public static synchronized void removeInterpreterInfo(IInterpreterInstall install) {
        TclPackagesManager.initialize();
        TclInterpreterInfo info = TclPackagesManager.getTclInterpreter(install);
        info.getPackages().clear();
        infos.getContents().remove((Object)info);
        TclPackagesManager.save();
    }

    public static synchronized Set<String> getPackageInfosAsString(IInterpreterInstall install) {
        TclPackagesManager.initialize();
        HashSet<String> result = new HashSet<String>();
        List<TclPackageInfo> list = TclPackagesManager.getPackageInfos(install);
        for (TclPackageInfo tclPackageInfo : list) {
            result.add(tclPackageInfo.getName());
        }
        return result;
    }
}

