/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.scriptview.SelectionTransferDropAdapter;
import org.eclipse.dltk.internal.ui.typehierarchy.OpenTypeHierarchyUtil;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.dltk.internal.ui.util.SelectionUtil;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;

public class TypeHierarchyTransferDropAdapter
extends SelectionTransferDropAdapter {
    private static final int OPERATION = 4;
    private TypeHierarchyViewPart fTypeHierarchyViewPart;

    public TypeHierarchyTransferDropAdapter(TypeHierarchyViewPart viewPart, AbstractTreeViewer viewer) {
        super((StructuredViewer)viewer);
        this.fTypeHierarchyViewPart = viewPart;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        this.initializeSelection();
        if (target != null) {
            return;
        }
        if (TypeHierarchyTransferDropAdapter.getInputElement(this.getSelection()) != null) {
            event.detail = 4;
        }
    }

    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    public void drop(Object target, DropTargetEvent event) {
        if (target != null || event.detail != 4) {
            super.performDrop(event);
            return;
        }
        IModelElement input = TypeHierarchyTransferDropAdapter.getInputElement(this.getSelection());
        this.fTypeHierarchyViewPart.setInputElement(input);
    }

    private static IModelElement getInputElement(ISelection selection) {
        Object single = SelectionUtil.getSingleElement(selection);
        if (single == null) {
            return null;
        }
        IModelElement[] candidates = OpenTypeHierarchyUtil.getCandidates(single);
        if (candidates != null && candidates.length > 0) {
            return candidates[0];
        }
        return null;
    }
}

