/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing.ext;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.ui.browsing.ext.ExtendedClassesView;
import org.eclipse.dltk.ui.browsing.ext.MixedClass;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

class ExtendedClasesContentProvider
implements ITreeContentProvider {
    private final ExtendedClassesView contentProvider;
    Object input;
    private IDLTKSearchScope scope;
    private Composite parent;
    private boolean firstTime = true;
    IDLTKLanguageToolkit toolkit;

    public ExtendedClasesContentProvider(ExtendedClassesView extendedClassesView, IDLTKSearchScope scope, Composite parent, IDLTKLanguageToolkit toolkit) {
        this.contentProvider = extendedClassesView;
        this.scope = scope;
        this.parent = parent;
        this.toolkit = toolkit;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IScriptModel) {
            return this.getElements(parentElement);
        }
        if (parentElement instanceof MixedClass) {
            ArrayList<IType> els = new ArrayList<IType>();
            MixedClass cl = (MixedClass)parentElement;
            List elements = cl.getElements();
            for (Object element : elements) {
                if (!(element instanceof IType)) continue;
                IType type = (IType)element;
                try {
                    IType[] types = type.getTypes();
                    int i = 0;
                    while (i < types.length) {
                        els.add(types[i]);
                        ++i;
                    }
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            }
            return this.convert(els);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList elements;
        block4: {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.parent.getShell());
            dialog.setCancelable(false);
            elements = new ArrayList();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block2: {
                        try {
                            new SearchEngine().searchAllTypeNames(null, 0, "*".toCharArray(), 10, 0, ExtendedClasesContentProvider.this.scope, new TypeNameMatchRequestor(){

                                public void acceptTypeNameMatch(TypeNameMatch match) {
                                    try {
                                        IType type = match.getType();
                                        if (type.exists() && type.getParent().getElementType() != 7) {
                                            elements.add(type);
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                            }, 3, monitor);
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            };
            try {
                dialog.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (InterruptedException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return this.convert(elements);
    }

    private Object[] convert(List elements) {
        HashMap<String, MixedClass> els = new HashMap<String, MixedClass>();
        for (IType type : elements) {
            MixedClass cl;
            String name = type.getElementName();
            if (els.containsKey(name)) {
                cl = (MixedClass)els.get(name);
                cl.getElements().add(type);
                continue;
            }
            cl = new MixedClass();
            cl.getElements().add(type);
            cl.setName(name);
            els.put(name, cl);
        }
        return els.values().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
        this.updateInput();
    }

    private void updateInput() {
        if (this.input instanceof IModelElement) {
            IModelElement element = (IModelElement)this.input;
            this.scope = SearchEngine.createSearchScope((IModelElement)element);
        } else if (this.input instanceof IModelElement[]) {
            this.scope = SearchEngine.createSearchScope((IModelElement[])((IModelElement[])this.input), (IDLTKLanguageToolkit)this.toolkit);
        }
    }
}

