/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.environment;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.environment.EnvironmentChangedListener;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentChangedListener;
import org.eclipse.swt.widgets.Display;

public class EnvironmentContainer {
    private boolean initialized = false;
    private final Map environments = new HashMap();
    private List environmentList = Collections.EMPTY_LIST;
    private IEnvironmentChangedListener listener = null;
    private final ListenerList changeListeners = new ListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            Map map = this.environments;
            synchronized (map) {
                this.initEnvironments();
                this.installChangeListener();
            }
        }
    }

    private void initEnvironments() {
        this.environments.clear();
        IEnvironment[] envs = EnvironmentManager.getEnvironments();
        Arrays.sort(envs, new EnvironmentComparator());
        this.environmentList = Arrays.asList(envs);
        int i = 0;
        while (i < envs.length) {
            IEnvironment environment = envs[i];
            this.environments.put(environment.getId(), environment);
            ++i;
        }
    }

    private void installChangeListener() {
        if (this.listener == null) {
            this.listener = new EnvironmentChangedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void environmentsModified() {
                    Map map = EnvironmentContainer.this.environments;
                    synchronized (map) {
                        EnvironmentContainer.this.initEnvironments();
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EnvironmentContainer.this.fireChangeNotifications();
                        }
                    });
                }
            };
            EnvironmentManager.addEnvironmentChangedListener((IEnvironmentChangedListener)this.listener);
        }
    }

    private void uninstallChangeListener() {
        if (this.listener != null) {
            EnvironmentManager.removeEnvironmentChangedListener((IEnvironmentChangedListener)this.listener);
            this.listener = null;
        }
    }

    public List getEnvironments() {
        return this.environmentList;
    }

    public String[] getEnvironmentIds() {
        List list = this.environmentList;
        String[] ids = new String[list.size()];
        int i = 0;
        while (i < ids.length) {
            ids[i] = ((IEnvironment)list.get(i)).getId();
            ++i;
        }
        return ids;
    }

    public IEnvironment get(String environmentId) {
        return (IEnvironment)this.environments.get(environmentId);
    }

    public String getName(String environmentId) {
        IEnvironment environment = (IEnvironment)this.environments.get(environmentId);
        if (environment != null) {
            return environment.getName();
        }
        return "(" + environmentId + ")";
    }

    public void dispose() {
        this.uninstallChangeListener();
        this.changeListeners.clear();
        this.environments.clear();
        this.environmentList = null;
        this.initialized = false;
    }

    public void addChangeListener(Runnable runnable) {
        this.changeListeners.add((Object)runnable);
    }

    protected void fireChangeNotifications() {
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((Runnable)listeners[i]).run();
            ++i;
        }
    }

    private static class EnvironmentComparator
    implements Comparator {
        private EnvironmentComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            IEnvironment e1 = (IEnvironment)arg0;
            IEnvironment e2 = (IEnvironment)arg1;
            if (e1.isLocal() != e2.isLocal()) {
                return e1.isLocal() ? -1 : 1;
            }
            return e1.getName().compareToIgnoreCase(e2.getName());
        }
    }
}

