/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SimpleDelta;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;

public class ChangeCollector {
    HashMap changes = new HashMap();
    TypeHierarchy hierarchy;

    public ChangeCollector(TypeHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    private void addAffectedChildren(IModelElementDelta delta) throws ModelException {
        IModelElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        int length = children.length;
        while (i < length) {
            IModelElementDelta child = children[i];
            IModelElement childElement = child.getElement();
            switch (childElement.getElementType()) {
                case 7: {
                    this.addChange((IType)childElement, child);
                    break;
                }
                case 8: 
                case 9: {
                    this.addChange((IMember)childElement, child);
                }
            }
            ++i;
        }
    }

    public void addChange(ISourceModule cu, IModelElementDelta newDelta) throws ModelException {
        int newKind = newDelta.getKind();
        switch (newKind) {
            case 1: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromElement(cu, allTypes);
                int i = 0;
                int length = allTypes.size();
                while (i < length) {
                    IType type = (IType)allTypes.get(i);
                    this.addTypeAddition(type, (SimpleDelta)this.changes.get(type));
                    ++i;
                }
                break;
            }
            case 2: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromHierarchy((ModelElement)((Object)cu), allTypes);
                int i = 0;
                int length = allTypes.size();
                while (i < length) {
                    IType type = (IType)allTypes.get(i);
                    this.addTypeRemoval(type, (SimpleDelta)this.changes.get(type));
                    ++i;
                }
                break;
            }
            case 4: {
                this.addAffectedChildren(newDelta);
            }
        }
    }

    private void addChange(IMember member, IModelElementDelta newDelta) throws ModelException {
        int newKind = newDelta.getKind();
        switch (newKind) {
            case 1: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromElement(member, allTypes);
                int i = 0;
                int length = allTypes.size();
                while (i < length) {
                    IType innerType = (IType)allTypes.get(i);
                    this.addTypeAddition(innerType, (SimpleDelta)this.changes.get(innerType));
                    ++i;
                }
                break;
            }
            case 2: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromHierarchy((ModelElement)((Object)member), allTypes);
                int i = 0;
                int length = allTypes.size();
                while (i < length) {
                    IType type = (IType)allTypes.get(i);
                    this.addTypeRemoval(type, (SimpleDelta)this.changes.get(type));
                    ++i;
                }
                break;
            }
            case 4: {
                this.addAffectedChildren(newDelta);
            }
        }
    }

    private void addChange(IType type, IModelElementDelta newDelta) throws ModelException {
        int newKind = newDelta.getKind();
        SimpleDelta existingDelta = (SimpleDelta)this.changes.get(type);
        switch (newKind) {
            case 1: {
                this.addTypeAddition(type, existingDelta);
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromElement(type, allTypes);
                int i = 0;
                int length = allTypes.size();
                while (i < length) {
                    IType innerType = (IType)allTypes.get(i);
                    this.addTypeAddition(innerType, (SimpleDelta)this.changes.get(innerType));
                    ++i;
                }
                break;
            }
            case 2: {
                this.addTypeRemoval(type, existingDelta);
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromHierarchy((ModelElement)((Object)type), allTypes);
                int i = 0;
                int length = allTypes.size();
                while (i < length) {
                    IType innerType = (IType)allTypes.get(i);
                    this.addTypeRemoval(innerType, (SimpleDelta)this.changes.get(innerType));
                    ++i;
                }
                break;
            }
            case 4: {
                this.addTypeChange(type, newDelta.getFlags(), existingDelta);
                this.addAffectedChildren(newDelta);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTypeAddition(IType type, SimpleDelta existingDelta) throws ModelException {
        if (existingDelta != null) {
            switch (existingDelta.getKind()) {
                case 2: {
                    boolean hasChange = false;
                    if (this.hasSuperTypeChange(type)) {
                        existingDelta.superTypes();
                        hasChange = true;
                    }
                    if (this.hasVisibilityChange(type)) {
                        existingDelta.modifiers();
                        return;
                    }
                    if (hasChange) return;
                    this.changes.remove(type);
                }
                default: {
                    return;
                }
            }
        } else {
            String typeName = type.getElementName();
            if (!this.hierarchy.hasSupertype(typeName) && !this.hierarchy.subtypesIncludeSupertypeOf(type)) {
                if (!this.hierarchy.missingTypes.contains(typeName)) return;
            }
            SimpleDelta delta = new SimpleDelta();
            delta.added();
            this.changes.put(type, delta);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTypeChange(IType type, int newFlags, SimpleDelta existingDelta) throws ModelException {
        if (existingDelta != null) {
            switch (existingDelta.getKind()) {
                case 4: {
                    int existingFlags = existingDelta.getFlags();
                    boolean hasChange = false;
                    if ((existingFlags & 0x800) != 0 && this.hasSuperTypeChange(type)) {
                        existingDelta.superTypes();
                        hasChange = true;
                    }
                    if ((existingFlags & 2) != 0 && this.hasVisibilityChange(type)) {
                        existingDelta.modifiers();
                        return;
                    }
                    if (hasChange) return;
                    this.changes.remove(type);
                }
                default: {
                    return;
                }
            }
        } else {
            SimpleDelta typeDelta = null;
            if ((newFlags & 0x800) != 0 && this.hierarchy.includesTypeOrSupertype(type)) {
                typeDelta = new SimpleDelta();
                typeDelta.superTypes();
            }
            if ((newFlags & 2) != 0 && (this.hierarchy.hasSupertype(type.getElementName()) || type.equals(this.hierarchy.focusType))) {
                if (typeDelta == null) {
                    typeDelta = new SimpleDelta();
                }
                typeDelta.modifiers();
            }
            if (typeDelta == null) return;
            this.changes.put(type, typeDelta);
        }
    }

    private void addTypeRemoval(IType type, SimpleDelta existingDelta) {
        if (existingDelta != null) {
            switch (existingDelta.getKind()) {
                case 1: {
                    this.changes.remove(type);
                    break;
                }
                case 4: {
                    existingDelta.removed();
                }
            }
        } else if (this.hierarchy.contains(type)) {
            SimpleDelta typeDelta = new SimpleDelta();
            typeDelta.removed();
            this.changes.put(type, typeDelta);
        }
    }

    private void getAllTypesFromElement(IModelElement element, ArrayList allTypes) throws ModelException {
        switch (element.getElementType()) {
            case 5: {
                IType[] types = ((ISourceModule)element).getTypes();
                int i = 0;
                int length = types.length;
                while (i < length) {
                    IType type = types[i];
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                    ++i;
                }
                break;
            }
            case 7: {
                IType[] types = ((IType)element).getTypes();
                int i = 0;
                int length = types.length;
                while (i < length) {
                    IType type = types[i];
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                IModelElement[] children = ((IMember)element).getChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IModelElement child = children[i];
                    if (child.getElementType() == 7) {
                        IType type = (IType)children[i];
                        allTypes.add(type);
                        this.getAllTypesFromElement(type, allTypes);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void getAllTypesFromHierarchy(ModelElement element, ArrayList allTypes) {
        switch (element.getElementType()) {
            case 5: {
                ArrayList types = (ArrayList)this.hierarchy.files.get(element);
                if (types == null) break;
                allTypes.addAll(types);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                ArrayList types = (ArrayList)this.hierarchy.files.get(((IMember)((Object)element)).getSourceModule());
                if (types == null) break;
                int i = 0;
                int length = types.size();
                while (i < length) {
                    IType type = (IType)types.get(i);
                    if (element.isAncestorOf(type)) {
                        allTypes.add(type);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private boolean hasSuperTypeChange(IType type) throws ModelException {
        IType[] existingSuperClasses = this.hierarchy.getSuperclass(type);
        String[] newSuperClases = type.getSuperClasses();
        if (newSuperClases == null && existingSuperClasses.length != 0) {
            return true;
        }
        if (existingSuperClasses.length != newSuperClases.length) {
            return true;
        }
        int i = 0;
        int length = newSuperClases.length;
        while (i < length) {
            String superClassName = newSuperClases[i];
            if (!superClassName.equals(newSuperClases[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasVisibilityChange(IType type) throws ModelException {
        int newFlags;
        int existingFlags = this.hierarchy.getCachedFlags(type);
        return existingFlags != (newFlags = type.getFlags());
    }

    public boolean needsRefresh() {
        return this.changes.size() != 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.changes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(((ModelElement)entry.getKey()).toDebugString());
            buffer.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

