/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.EmptyStackException;

public class CharacterStack {
    private char[] buffer;
    private int size;

    public CharacterStack() {
        this(16);
    }

    public CharacterStack(int capacity) {
        this.buffer = new char[capacity];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public char peek() {
        int len = this.size;
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.buffer[len - 1];
    }

    public char pop() {
        int len = this.size;
        if (len == 0) {
            throw new EmptyStackException();
        }
        char result = this.buffer[--len];
        this.size = len;
        return result;
    }

    public void push(char c) {
        if (this.size == this.buffer.length) {
            char[] newBuffer = new char[this.buffer.length * 2 + 1];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.size++] = c;
    }
}

