/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptStack;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;

public class ScriptStack
implements IScriptStack {
    public static final IScriptStackFrame[] NO_STACK_FRAMES = new IScriptStackFrame[0];
    private IScriptStackFrame[] frames;
    private final Object framesLock = new Object();
    private final ScriptThread thread;

    public ScriptStack(ScriptThread thread) {
        this.thread = thread;
        this.frames = NO_STACK_FRAMES;
    }

    public void update(boolean logErrors) {
        block2: {
            try {
                this.readFrames();
            }
            catch (DbgpException e) {
                if (!logErrors) break block2;
                DLTKDebugPlugin.log(e);
            }
        }
    }

    protected IDbgpStackLevel[] requrestStackLevels() throws DbgpException {
        return this.thread.getDbgpSession().getCoreCommands().getStackLevels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFrames() throws DbgpException {
        IDbgpStackLevel[] levels = this.requrestStackLevels();
        Object object = this.framesLock;
        synchronized (object) {
            int newSize = levels.length;
            int oldSize = this.frames.length;
            int numToRebind = Math.min(newSize, oldSize);
            ScriptStackFrame[] newFrames = new ScriptStackFrame[newSize];
            int depth = 0;
            while (depth < numToRebind) {
                ScriptStackFrame oldFrame = (ScriptStackFrame)this.frames[oldSize - depth - 1];
                newFrames[newSize - depth - 1] = oldFrame.bind(levels[newSize - depth - 1]);
                ++depth;
            }
            int newCount = newSize - oldSize;
            int i = 0;
            while (i < newCount) {
                newFrames[i] = new ScriptStackFrame(this, levels[i]);
                ++i;
            }
            this.frames = newFrames;
        }
    }

    public ScriptThread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.frames.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFrames() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.frames.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptStackFrame[] getFrames() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptStackFrame getTopFrame() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.frames.length > 0 ? this.frames[0] : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFrames() {
        Object object = this.framesLock;
        synchronized (object) {
            int i = 0;
            while (i < this.frames.length) {
                ((ScriptStackFrame)this.frames[i]).updateVariables();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.frames != NO_STACK_FRAMES;
        }
    }
}

