/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.reference.resolvers;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IReferenceResolver;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolverFactory;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SourceBasedResolver;

public class ResolverManager {
    private static IResolverFactory[] registredResolvers;

    static {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.javascript.core.resolver");
        IExtension[] ext = extensionPoint.getExtensions();
        ArrayList<IResolverFactory> resolvers = new ArrayList<IResolverFactory>();
        int a = 0;
        while (a < ext.length) {
            IConfigurationElement[] elements = ext[a].getConfigurationElements();
            IConfigurationElement myElement = elements[0];
            try {
                IResolverFactory resolver = (IResolverFactory)myElement.createExecutableExtension("class");
                resolvers.add(resolver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++a;
        }
        registredResolvers = new IResolverFactory[resolvers.size()];
        resolvers.toArray(registredResolvers);
    }

    public static ReferenceResolverContext createResolverContext(ISourceModule module, Map settings, boolean skipSourceBased) {
        ReferenceResolverContext cm = new ReferenceResolverContext(module, settings);
        int a = 0;
        while (a < registredResolvers.length) {
            IReferenceResolver create = registredResolvers[a].create();
            if (create instanceof SourceBasedResolver) {
                if (!skipSourceBased) {
                    cm.resolvers.add(0, create);
                }
            } else if (create.canResolve(module)) {
                cm.resolvers.add(create);
            }
            ++a;
        }
        return cm;
    }
}

