/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.javascript.scriptdoc.JavaHeuristicScanner;
import org.eclipse.dltk.javascript.scriptdoc.JavaIndenter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.TextEditorAction;

public class IndentAction
extends TextEditorAction {
    private int fCaretOffset;
    private final boolean fIsTabAction;
    static /* synthetic */ Class class$0;

    public IndentAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean isTabAction) {
        super(bundle, prefix, editor);
        this.fIsTabAction = isTabAction;
    }

    public void run() {
        if (!this.isEnabled() || !this.validateEditorInputState()) {
            return;
        }
        ITextSelection selection = this.getSelection();
        final IDocument document = this.getDocument();
        if (document != null) {
            int nLines;
            int firstLine;
            final int offset = selection.getOffset();
            final int length = selection.getLength();
            final Position end = new Position(offset + length);
            this.fCaretOffset = -1;
            try {
                document.addPosition(end);
                firstLine = document.getLineOfOffset(offset);
                int minusOne = length == 0 ? 0 : 1;
                nLines = document.getLineOfOffset(offset + length - minusOne) - firstLine + 1;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            Runnable runnable = new Runnable(){

                /*
                 * Exception decompiling
                 */
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 289->293)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            if (nLines > 50) {
                Display display = this.getTextEditor().getEditorSite().getWorkbenchWindow().getShell().getDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void selectAndReveal(int newOffset, int newLength) {
        Assert.isTrue((newOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((newLength >= 0 ? 1 : 0) != 0);
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ScriptEditor) {
            ISourceViewer viewer = ((ScriptEditor)editor).getViewer();
            if (viewer != null) {
                viewer.setSelectedRange(newOffset, newLength);
            }
        } else {
            this.getTextEditor().selectAndReveal(newOffset, newLength);
        }
    }

    private boolean indentLine(IDocument document, int line, int caret, JavaIndenter indenter, JavaHeuristicScanner scanner, boolean multiLine) throws BadLocationException {
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        if (currentLine.getLength() == 0) {
            return false;
        }
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__javascript_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"__javascript_partitioning", (int)offset, (boolean)false);
            String type = partition.getType();
            if (type.equals("__javascript_doc") || type.equals("__javascript_comment")) {
                indent = this.computeJavadocIndent(document, line, scanner, startingPartition);
            } else if (!this.fIsTabAction && startingPartition.getOffset() == offset && startingPartition.getType().equals("__javascript_comment")) {
                int slashes = 0;
                wsStart = offset + slashes;
                StringBuffer computed = indenter.computeIndentation(offset);
                if (computed == null) {
                    computed = new StringBuffer(0);
                }
                int tabSize = this.getTabSize();
                while (slashes > 0 && computed.length() > 0) {
                    char c = computed.charAt(0);
                    if (c == '\t') {
                        if (slashes <= tabSize) break;
                        slashes -= tabSize;
                    } else {
                        if (c != ' ') break;
                        --slashes;
                    }
                    computed.deleteCharAt(0);
                }
                indent = String.valueOf(document.get(offset, wsStart - offset)) + computed;
            }
        }
        if (indent == null) {
            StringBuffer computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : "";
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
            if (multiLine && !this.indentEmptyLines()) {
                indent = "";
            }
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if (this.fIsTabAction && caret == end && this.whiteSpaceLength(currentIndent) >= this.whiteSpaceLength(indent)) {
            String tab = this.getTabEquivalent();
            document.replace(caret, 0, tab);
            this.fCaretOffset = caret + tab.length();
            return true;
        }
        this.fCaretOffset = caret >= offset && caret <= end ? offset + indent.length() : -1;
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
            return true;
        }
        return false;
    }

    private String computeJavadocIndent(IDocument document, int line, JavaHeuristicScanner scanner, ITypedRegion partition) throws BadLocationException {
        int lineLength;
        int lineEnd;
        if (line == 0) {
            return null;
        }
        IRegion lineInfo = document.getLineInformation(line);
        int lineStart = lineInfo.getOffset();
        int nonWS = scanner.findNonWhitespaceForwardInAnyPartition(lineStart, lineEnd = lineStart + (lineLength = lineInfo.getLength()));
        if (nonWS == -1 || document.getChar(nonWS) != '*') {
            if (nonWS == -1) {
                return document.get(lineStart, lineLength);
            }
            return document.get(lineStart, nonWS - lineStart);
        }
        IRegion previousLine = document.getLineInformation(line - 1);
        int previousLineStart = previousLine.getOffset();
        int previousLineLength = previousLine.getLength();
        int previousLineEnd = previousLineStart + previousLineLength;
        StringBuffer buf = new StringBuffer();
        int previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd);
        if (previousLineNonWS == -1 || document.getChar(previousLineNonWS) != '*') {
            previousLine = document.getLineInformationOfOffset(partition.getOffset());
            previousLineStart = previousLine.getOffset();
            previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd = previousLineStart + (previousLineLength = previousLine.getLength()));
            if (previousLineNonWS == -1) {
                previousLineNonWS = previousLineEnd;
            }
            buf.append(' ');
        }
        String indentation = document.get(previousLineStart, previousLineNonWS - previousLineStart);
        buf.insert(0, indentation);
        return buf.toString();
    }

    private int whiteSpaceLength(String indent) {
        if (indent == null) {
            return 0;
        }
        int size = 0;
        int l = indent.length();
        int tabSize = this.getTabSize();
        int i = 0;
        while (i < l) {
            size += indent.charAt(i) == '\t' ? tabSize : 1;
            ++i;
        }
        return size;
    }

    private String getTabEquivalent() {
        String tab;
        if (" ".equals(this.getCoreFormatterOption("org.eclipse.dltk.javascript.ui.formatter.tabulation.char"))) {
            int size = this.getTabSize();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < size) {
                buf.append(' ');
                ++i;
            }
            tab = buf.toString();
        } else {
            tab = "\t";
        }
        return tab;
    }

    private int getTabSize() {
        return this.getCoreFormatterOption("org.eclipse.dltk.javascript.ui.formatter.tabulation.size", 4);
    }

    private boolean indentEmptyLines() {
        return "true".equals(this.getCoreFormatterOption("org.eclipse.dltk.javascript.ui.formatter.indent_empty_lines"));
    }

    private String getCoreFormatterOption(String key) {
        IScriptProject project = this.getJavaProject();
        if (project == null) {
            return DLTKCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private int getCoreFormatterOption(String key, int def) {
        try {
            return Integer.parseInt(this.getCoreFormatterOption(key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private IScriptProject getJavaProject() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return null;
        }
        ISourceModule cu = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (cu == null) {
            return null;
        }
        return cu.getScriptProject();
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            if (this.fIsTabAction) {
                this.setEnabled(this.canModifyEditor() && this.isSmartMode() && this.isValidSelection());
            } else {
                this.setEnabled(this.canModifyEditor() && !this.getSelection().isEmpty());
            }
        }
    }

    private boolean isValidSelection() {
        ITextSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        int offset = selection.getOffset();
        int length = selection.getLength();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        try {
            IRegion firstLine = document.getLineInformationOfOffset(offset);
            int lineOffset = firstLine.getOffset();
            if (length == 0) {
                return document.get(lineOffset, offset - lineOffset).trim().length() == 0;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isSmartMode() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ITextEditorExtension3) {
            return ((ITextEditorExtension3)editor).getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    static /* synthetic */ ITextEditor access$0(IndentAction indentAction) {
        return indentAction.getTextEditor();
    }

    static /* synthetic */ IScriptProject access$1(IndentAction indentAction) {
        return indentAction.getJavaProject();
    }

    static /* synthetic */ boolean access$2(IndentAction indentAction, IDocument iDocument, int n, int n2, JavaIndenter javaIndenter, JavaHeuristicScanner javaHeuristicScanner, boolean bl) throws BadLocationException {
        return indentAction.indentLine(iDocument, n, n2, javaIndenter, javaHeuristicScanner, bl);
    }

    static /* synthetic */ boolean access$3(IndentAction indentAction) {
        return indentAction.fIsTabAction;
    }

    static /* synthetic */ int access$4(IndentAction indentAction) {
        return indentAction.fCaretOffset;
    }

    static /* synthetic */ void access$5(IndentAction indentAction, int n, int n2) {
        indentAction.selectAndReveal(n, n2);
    }
}

