/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class TclForeachStatement
extends Statement {
    List arguments = null;
    Block block = null;

    public TclForeachStatement(int start, int end) {
        super(start, end);
    }

    public int getKind() {
        return 2014;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.arguments != null) {
                for (ASTNode node : this.arguments) {
                    node.traverse(visitor);
                }
            }
            if (this.block != null) {
                this.block.traverse(visitor);
            }
            visitor.endvisit((Statement)this);
        }
    }

    public List getArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        return this.arguments;
    }

    public Block getBlock() {
        return this.block;
    }

    public void acceptBlock(Block block) {
        this.block = block;
    }

    public void printNode(CorePrinter output) {
        output.print("foreach ");
        if (this.arguments != null) {
            for (ASTNode node : this.arguments) {
                node.printNode(output);
            }
        }
        if (this.block != null) {
            this.block.printNode(output);
        }
    }
}

