/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import java.util.Vector;
import junit.framework.Assert;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;

public class CompletionTestsRequestor
extends CompletionRequestor {
    private Vector<String> fElements = new Vector();
    private Vector<String> fCompletions = new Vector();
    private Vector<String> fRelevances = new Vector();
    private Vector<String> fCompletionStart = new Vector();
    private Vector<String> fCompletionEnd = new Vector();
    public boolean fDebug = false;

    public void completionFailure(IProblem problem) {
        Assert.fail((String)("completionFailure(" + (problem != null ? problem.getMessage() : "Unknown problem") + ")"));
    }

    private void acceptCommon(CompletionProposal proposal) {
        this.fCompletions.addElement(proposal.getCompletion());
        this.fRelevances.addElement(String.valueOf(proposal.getRelevance()));
        this.fCompletionStart.addElement(String.valueOf(proposal.getReplaceStart()));
        this.fCompletionEnd.addElement(String.valueOf(proposal.getReplaceEnd()));
    }

    public void accept(CompletionProposal proposal) {
        String typeName = null;
        switch (proposal.getKind()) {
            case 7: {
                typeName = proposal.getName();
                this.fElements.addElement(typeName);
                this.acceptCommon(proposal);
                break;
            }
            case 1: {
                this.fElements.addElement(proposal.getName());
                this.acceptCommon(proposal);
                if (!this.fDebug) break;
                System.out.println("Field " + proposal.getName());
                break;
            }
            case 2: {
                this.fElements.addElement(proposal.getName());
                this.acceptCommon(proposal);
                if (!this.fDebug) break;
                System.out.println("Keyword " + proposal.getName());
                break;
            }
            case 3: {
                this.fElements.addElement(proposal.getName());
                this.acceptCommon(proposal);
                if (!this.fDebug) break;
                System.out.println("Label " + proposal.getName());
                break;
            }
            case 4: {
                this.fElements.addElement(proposal.getName());
                this.acceptCommon(proposal);
                if (!this.fDebug) break;
                System.out.println("Local variable " + proposal.getName());
                break;
            }
            case 5: {
                String resultString = String.valueOf(proposal.getName()) + "(";
                String[] parameterNames = proposal.findParameterNames(null);
                if (parameterNames != null) {
                    int i = 0;
                    while (i < parameterNames.length) {
                        if (i > 0) {
                            resultString = String.valueOf(resultString) + ",";
                        }
                        resultString = String.valueOf(resultString) + parameterNames[i];
                        ++i;
                    }
                }
                resultString = String.valueOf(resultString) + ")";
                this.fElements.addElement(resultString);
                this.acceptCommon(proposal);
                if (!this.fDebug) break;
                System.out.println("method " + proposal.getName());
                break;
            }
            case 6: {
                this.fElements.addElement(proposal.getName());
                this.acceptCommon(proposal);
                if (!this.fDebug) break;
                System.out.println("method declaration " + proposal.getName());
                break;
            }
            case 8: {
                this.fElements.addElement(proposal.getName());
                this.acceptCommon(proposal);
                if (!this.fDebug) break;
                System.out.println("variable name " + proposal.getName());
            }
        }
    }

    public String getResults() {
        return this.getResults(true, false);
    }

    public String getResultsWithPosition() {
        return this.getResults(true, true);
    }

    public String getResults(boolean relevance, boolean position) {
        StringBuffer result = new StringBuffer();
        int size = this.fElements.size();
        if (size == 1) {
            result.append(this.getResult(0, relevance, position));
        } else if (size > 1) {
            String[] sortedBucket = new String[size];
            int i = 0;
            while (i < size) {
                sortedBucket[i] = this.getResult(i, relevance, position);
                ++i;
            }
            this.quickSort(sortedBucket, 0, size - 1);
            int j = 0;
            while (j < sortedBucket.length) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(sortedBucket[j]);
                ++j;
            }
        }
        return result.toString();
    }

    private String getResult(int i, boolean relevance, boolean position) {
        if (i < 0 || i >= this.fElements.size()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("element:");
        buffer.append(this.fElements.elementAt(i));
        buffer.append("    completion:");
        buffer.append(this.fCompletions.elementAt(i));
        if (position) {
            buffer.append("    position:[");
            buffer.append(this.fCompletionStart.elementAt(i));
            buffer.append(",");
            buffer.append(this.fCompletionEnd.elementAt(i));
            buffer.append("]");
        }
        if (relevance) {
            buffer.append("    relevance:");
            buffer.append(this.fRelevances.elementAt(i));
        }
        return buffer.toString();
    }

    protected String[] quickSort(String[] collection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = collection[(left + right) / 2];
        while (true) {
            if (mid.compareTo(collection[left]) > 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(collection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = collection[left];
                collection[left] = collection[right];
                collection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            collection = this.quickSort(collection, original_left, right);
        }
        if (left < original_right) {
            collection = this.quickSort(collection, left, original_right);
        }
        return collection;
    }

    public String toString() {
        return this.getResults();
    }
}

