/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;

public class PropertyInitializer
extends ObjectInitializerPart
implements ISourceable {
    private Expression name;
    private Expression value;
    private int colon = -1;

    public PropertyInitializer(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.name != null) {
                this.name.traverse(visitor);
            }
            if (this.value != null) {
                this.value.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public int getColon() {
        return this.colon;
    }

    public void setColon(int colon) {
        this.colon = colon;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.colon > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name.toSourceString(indentationString));
        buffer.append(": ");
        buffer.append(this.value.toSourceString(indentationString));
        return buffer.toString();
    }
}

