/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptLanguageProvider;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class CapabilityConfigurationPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "DLTKCapabilityConfigurationPage";
    private IScriptProject fScriptProject = null;
    private BuildpathsBlock fBuildPathsBlock;

    @Deprecated
    public CapabilityConfigurationPage() {
        this(PAGE_NAME);
    }

    public CapabilityConfigurationPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.ScriptCapabilityConfigurationPage_title);
        this.setDescription(NewWizardMessages.ScriptCapabilityConfigurationPage_description);
    }

    protected BuildpathsBlock getBuildPathsBlock() {
        if (this.fBuildPathsBlock == null) {
            this.fBuildPathsBlock = this.createBuildpathBlock(new BuildpathBlockListener());
        }
        return this.fBuildPathsBlock;
    }

    protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
        return new BuildpathsBlock(new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
    }

    protected boolean useNewSourcePage() {
        return false;
    }

    public void init(IScriptProject jproject, IBuildpathEntry[] defaultEntries, boolean defaultsOverrideExistingBuildpath) {
        if (!defaultsOverrideExistingBuildpath && jproject.exists() && jproject.getProject().getFile(".buildpath").exists()) {
            defaultEntries = null;
        }
        this.getBuildPathsBlock().init(jproject, defaultEntries);
        this.fScriptProject = jproject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, false));
        Control control = this.getBuildPathsBlock().createControl(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        this.setHelpContext((Control)composite);
        this.setControl((Control)composite);
    }

    public IBuildpathEntry[] getRawBuildPath() {
        return this.getBuildPathsBlock().getRawBuildPath();
    }

    public IScriptProject getScriptProject() {
        return this.fScriptProject;
    }

    protected abstract String getScriptNature();

    public IRunnableWithProgress getRunnable() {
        if (this.getScriptProject() != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CapabilityConfigurationPage.this.configureScriptProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
        }
        return null;
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 6;
        monitor.beginTask(NewWizardMessages.ScriptCapabilityConfigurationPage_op_desc_Script, nSteps);
        try {
            try {
                IProject project = this.getScriptProject().getProject();
                BuildpathsBlock.addScriptNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1), this.getScriptNature());
                this.getBuildPathsBlock().configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void setHelpContext(Control control) {
    }

    private class BuildpathBlockListener
    implements IStatusChangeListener,
    IScriptLanguageProvider {
        private BuildpathBlockListener() {
        }

        public void statusChanged(IStatus status) {
            CapabilityConfigurationPage.this.updateStatus(status);
        }

        public IDLTKLanguageToolkit getLanguageToolkit() {
            return DLTKLanguageManager.getLanguageToolkit((String)CapabilityConfigurationPage.this.getScriptNature());
        }
    }
}

