/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.reference.resolvers;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IReferenceResolver;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolverFactory;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SourceBasedResolver;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverManager {
    private static IResolverFactory[] registered;

    static {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.javascript.core.resolver");
        ArrayList<IResolverFactory> factories = new ArrayList<IResolverFactory>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IResolverFactory factory = (IResolverFactory)element.createExecutableExtension("class");
                factories.add(factory);
            }
            catch (Exception e) {
                JavaScriptPlugin.error("Error instantiating IResolverFactory", e);
                e.printStackTrace();
            }
            ++n2;
        }
        registered = factories.toArray(new IResolverFactory[factories.size()]);
    }

    public static ReferenceResolverContext createResolverContext(ISourceModule module, Map<?, ?> settings, boolean skipSourceBased) {
        ReferenceResolverContext cm = new ReferenceResolverContext(module, settings);
        if (module != null) {
            int a = 0;
            while (a < registered.length) {
                IReferenceResolver create = registered[a].create();
                if (create instanceof SourceBasedResolver) {
                    if (!skipSourceBased) {
                        cm.resolvers.add(0, create);
                    }
                } else if (create.canResolve(module)) {
                    cm.resolvers.add(create);
                }
                ++a;
            }
        }
        return cm;
    }
}

