/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.FunctionValueCollection;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValueCollection;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.NestedValueCollection;
import org.eclipse.dltk.internal.javascript.ti.ReferenceKind;
import org.eclipse.dltk.internal.javascript.ti.ReferenceLocation;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitorBase;
import org.eclipse.dltk.internal.javascript.ti.WithValueCollection;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SimpleType;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

public class TypeInferencerVisitor
extends TypeInferencerVisitorBase {
    private final Stack<Branching> branchings = new Stack();

    public TypeInferencerVisitor(ITypeInferenceContext context) {
        super(context);
    }

    protected Branching branching() {
        Branching branching = new Branching();
        this.branchings.add(branching);
        return branching;
    }

    protected void assign(IValueReference dest, IValueReference src) {
        if (this.branchings.isEmpty()) {
            dest.setValue(src);
        } else {
            dest.addValue(src, false);
        }
    }

    public IValueReference visitArrayInitializer(ArrayInitializer node) {
        return this.context.getFactory().createArray(this.peekContext());
    }

    public IValueReference visitAsteriskExpression(AsteriskExpression node) {
        return this.context.getFactory().createXML(this.peekContext());
    }

    public IValueReference visitBinaryOperation(BinaryOperation node) {
        IValueReference left = (IValueReference)this.visit((ASTNode)node.getLeftExpression());
        IValueReference right = (IValueReference)this.visit((ASTNode)node.getRightExpression());
        if (104 == node.getOperation()) {
            return this.visitAssign(left, right);
        }
        return null;
    }

    protected IValueReference visitAssign(IValueReference left, IValueReference right) {
        if (left != null) {
            this.assign(left, right);
        }
        return right;
    }

    public IValueReference visitBooleanLiteral(BooleanLiteral node) {
        return this.context.getFactory().createBoolean(this.peekContext());
    }

    public IValueReference visitBreakStatement(BreakStatement node) {
        return null;
    }

    public IValueReference visitCallExpression(CallExpression node) {
        IValueReference reference = (IValueReference)this.visit(node.getExpression());
        for (ASTNode argument : node.getArguments()) {
            this.visit(argument);
        }
        if (reference != null) {
            return reference.getChild("()");
        }
        return null;
    }

    public IValueReference visitCommaExpression(CommaExpression node) {
        return (IValueReference)this.visit(node.getItems());
    }

    public IValueReference visitConditionalOperator(ConditionalOperator node) {
        this.visit((ASTNode)node.getCondition());
        return this.merge((IValueReference)this.visit((ASTNode)node.getTrueValue()), (IValueReference)this.visit((ASTNode)node.getFalseValue()));
    }

    public IValueReference visitConstDeclaration(ConstStatement node) {
        IValueCollection context = this.peekContext();
        for (VariableDeclaration declaration : node.getVariables()) {
            this.createVariable(context, declaration);
        }
        return null;
    }

    protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
        Identifier identifier = declaration.getIdentifier();
        String varName = identifier.getName();
        IValueReference reference = context.createChild(varName);
        org.eclipse.dltk.javascript.ast.Type varType = declaration.getType();
        if (varType != null) {
            reference.setDeclaredType(this.resolveType(varType));
        }
        reference.setKind(ReferenceKind.LOCAL);
        reference.setLocation(ReferenceLocation.create(declaration.sourceStart(), declaration.sourceEnd(), identifier.sourceStart(), identifier.sourceEnd()));
        if (declaration.getInitializer() != null) {
            this.assign(reference, (IValueReference)this.visit((ASTNode)declaration.getInitializer()));
        }
        return reference;
    }

    public IValueReference visitContinueStatement(ContinueStatement node) {
        return null;
    }

    public IValueReference visitDecimalLiteral(DecimalLiteral node) {
        return this.context.getFactory().createNumber(this.peekContext());
    }

    public IValueReference visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
        this.visit((ASTNode)node.getValue());
        return null;
    }

    public IValueReference visitDeleteStatement(DeleteStatement node) {
        IValueReference value = (IValueReference)this.visit((ASTNode)node.getExpression());
        if (value != null) {
            value.delete();
        }
        return this.context.getFactory().createBoolean(this.peekContext());
    }

    public IValueReference visitDoWhileStatement(DoWhileStatement node) {
        this.visit((ASTNode)node.getCondition());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitEmptyExpression(EmptyExpression node) {
        return null;
    }

    public IValueReference visitEmptyStatement(EmptyStatement node) {
        return null;
    }

    public IValueReference visitForEachInStatement(ForEachInStatement node) {
        this.visit((ASTNode)node.getItem());
        this.visit((ASTNode)node.getIterator());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForInStatement(ForInStatement node) {
        IValueReference item = (IValueReference)this.visit((ASTNode)node.getItem());
        if (item != null) {
            this.assign(item, this.context.getFactory().createString(this.peekContext()));
        }
        this.visit((ASTNode)node.getIterator());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForStatement(ForStatement node) {
        if (node.getInitial() != null) {
            this.visit((ASTNode)node.getInitial());
        }
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getStep() != null) {
            this.visit((ASTNode)node.getStep());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    public IValueReference visitFunctionStatement(FunctionStatement node) {
        IValueReference result;
        org.eclipse.dltk.javascript.ast.Type paramType;
        org.eclipse.dltk.javascript.ast.Type funcType;
        JSMethod method = new JSMethod();
        Identifier methodName = node.getName();
        if (methodName != null) {
            method.setName(methodName.getName());
        }
        if ((funcType = node.getReturnType()) != null) {
            method.setType(this.resolveType(funcType));
        }
        for (Argument argument : node.getArguments()) {
            IModelBuilder.IParameter parameter = method.createParameter();
            parameter.setName(argument.getIdentifier().getName());
            paramType = argument.getType();
            if (paramType != null) {
                parameter.setType(this.resolveType(paramType));
                parameter.setLocation(ReferenceLocation.create(argument.sourceStart(), paramType.sourceEnd(), argument.sourceStart(), argument.sourceEnd()));
            } else {
                parameter.setLocation(ReferenceLocation.create(argument.sourceStart(), argument.sourceEnd()));
            }
            method.getParameters().add(parameter);
        }
        if (methodName != null) {
            paramType = TypeInfoManager.getModelBuilders();
            int parameter = ((IModelBuilder[])paramType).length;
            int n = 0;
            while (n < parameter) {
                org.eclipse.dltk.javascript.ast.Type extension = paramType[n];
                extension.processMethod(this.context, node, method);
                ++n;
            }
        }
        FunctionValueCollection function = new FunctionValueCollection(this.peekContext(), method.getName());
        for (IModelBuilder.IParameter parameter : method.getParameters()) {
            IValueReference refArg = function.createChild(parameter.getName());
            refArg.setKind(ReferenceKind.ARGUMENT);
            refArg.setDeclaredType(parameter.getType());
            refArg.setLocation(parameter.getLocation());
        }
        this.enterContext(function);
        try {
            this.visitFunctionBody(node);
        }
        finally {
            this.leaveContext();
        }
        if (methodName != null) {
            result = this.peekContext().createChild(method.getName());
            result.setLocation(ReferenceLocation.create(node.sourceStart(), node.sourceEnd(), methodName.sourceStart(), methodName.sourceEnd()));
        } else {
            result = new AnonymousValue();
            Keyword kw = node.getFunctionKeyword();
            result.setLocation(ReferenceLocation.create(node.sourceStart(), node.sourceEnd(), kw.sourceStart(), kw.sourceEnd()));
        }
        result.setKind(ReferenceKind.FUNCTION);
        result.setAttribute("PARAMETERS", method);
        result.setAttribute("FUNCTION_SCOPE", function);
        IValueReference returnValue = result.getChild("()");
        returnValue.setDeclaredType(method.getType());
        returnValue.setValue(function.getReturnValue());
        return result;
    }

    protected void visitFunctionBody(FunctionStatement node) {
        this.visit((ASTNode)node.getBody());
    }

    protected Type resolveType(org.eclipse.dltk.javascript.ast.Type type) {
        return this.context.getType(type.getName());
    }

    public IValueReference visitGetAllChildrenExpression(GetAllChildrenExpression node) {
        return this.context.getFactory().createXML(this.peekContext());
    }

    public IValueReference visitGetArrayItemExpression(GetArrayItemExpression node) {
        IValueReference array = (IValueReference)this.visit((ASTNode)node.getArray());
        this.visit((ASTNode)node.getIndex());
        if (array != null) {
            if (node.getIndex() instanceof StringLiteral) {
                return this.extractNamedChild(array, node.getIndex());
            }
            return array.getChild("[]");
        }
        return null;
    }

    public IValueReference visitGetLocalNameExpression(GetLocalNameExpression node) {
        return null;
    }

    public IValueReference visitIdentifier(Identifier node) {
        return this.peekContext().getChild(node.getName());
    }

    private Boolean evaluateCondition(Expression condition) {
        if (condition instanceof BooleanLiteral) {
            return Boolean.valueOf(((BooleanLiteral)condition).getText());
        }
        return null;
    }

    public IValueReference visitIfStatement(IfStatement node) {
        this.visit((ASTNode)node.getCondition());
        ArrayList<Statement> statements = new ArrayList<Statement>(2);
        Statement onlyBranch = null;
        Boolean condition = this.evaluateCondition(node.getCondition());
        if ((condition == null || condition.booleanValue()) && node.getThenStatement() != null) {
            statements.add(node.getThenStatement());
            if (condition != null && condition.booleanValue()) {
                onlyBranch = node.getThenStatement();
            }
        }
        if (!(condition != null && condition.booleanValue() || node.getElseStatement() == null)) {
            statements.add(node.getElseStatement());
            if (condition != null && !condition.booleanValue()) {
                onlyBranch = node.getElseStatement();
            }
        }
        if (!statements.isEmpty()) {
            if (statements.size() == 1) {
                if (statements.get(0) == onlyBranch) {
                    this.visit((ASTNode)statements.get(0));
                } else {
                    Branching branching = this.branching();
                    this.visit((ASTNode)statements.get(0));
                    branching.end();
                }
            } else {
                Branching branching = this.branching();
                ArrayList<NestedValueCollection> collections = new ArrayList<NestedValueCollection>(statements.size());
                for (Statement statement : statements) {
                    NestedValueCollection nestedCollection = new NestedValueCollection(this.peekContext());
                    this.enterContext(nestedCollection);
                    this.visit((ASTNode)statement);
                    this.leaveContext();
                    collections.add(nestedCollection);
                }
                NestedValueCollection.mergeTo(this.peekContext(), collections);
                branching.end();
            }
        }
        return null;
    }

    public IValueReference visitLabelledStatement(LabelledStatement node) {
        if (node.getStatement() != null) {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    public IValueReference visitNewExpression(NewExpression node) {
        Type type;
        AnonymousValue result = new AnonymousValue();
        IValueReference clazz = (IValueReference)this.visit((ASTNode)node.getObjectClass());
        IValueReference newType = result.getChild("()");
        if (clazz != null && (type = this.context.getType(clazz.getName())) != null) {
            newType.setValue(this.context.getFactory().create(this.peekContext(), type));
            return result;
        }
        newType.setValue(this.context.getFactory().createObject(this.peekContext()));
        return result;
    }

    public IValueReference visitNullExpression(NullExpression node) {
        return null;
    }

    public IValueReference visitObjectInitializer(ObjectInitializer node) {
        AnonymousValue result = new AnonymousValue();
        for (ObjectInitializerPart part : node.getInitializers()) {
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            IValueReference child = this.extractNamedChild(result, pi.getName());
            IValueReference value = (IValueReference)this.visit((ASTNode)pi.getValue());
            if (child == null) continue;
            child.setValue(value);
        }
        return result;
    }

    public IValueReference visitParenthesizedExpression(ParenthesizedExpression node) {
        return (IValueReference)this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitPropertyExpression(PropertyExpression node) {
        IValueReference object = (IValueReference)this.visit((ASTNode)node.getObject());
        return this.extractNamedChild(object, node.getProperty());
    }

    protected IValueReference extractNamedChild(IValueReference parent, Expression name) {
        if (parent != null) {
            String nameStr;
            if (name instanceof Identifier) {
                nameStr = ((Identifier)name).getName();
            } else if (name instanceof StringLiteral) {
                nameStr = ((StringLiteral)name).getValue();
            } else {
                return null;
            }
            return parent.getChild(nameStr);
        }
        return null;
    }

    public IValueReference visitRegExpLiteral(RegExpLiteral node) {
        return this.context.getFactory().createRegExp(this.peekContext());
    }

    public IValueReference visitReturnStatement(ReturnStatement node) {
        IValueReference returnValue;
        IValueReference value;
        if (node.getValue() != null && (value = (IValueReference)this.visit((ASTNode)node.getValue())) != null && (returnValue = this.peekContext().getReturnValue()) != null) {
            returnValue.addValue(value, true);
        }
        return null;
    }

    public IValueReference visitScript(Script node) {
        return (IValueReference)this.visit(node.getStatements());
    }

    public IValueReference visitSimpleType(SimpleType node) {
        return null;
    }

    public IValueReference visitStatementBlock(StatementBlock node) {
        for (Statement statement : node.getStatements()) {
            this.visit((ASTNode)statement);
        }
        return null;
    }

    public IValueReference visitStringLiteral(StringLiteral node) {
        return this.context.getFactory().createString(this.peekContext());
    }

    public IValueReference visitSwitchStatement(SwitchStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        for (SwitchComponent component : node.getCaseClauses()) {
            if (component instanceof CaseClause) {
                this.visit((ASTNode)((CaseClause)component).getCondition());
            }
            this.visit(component.getStatements());
        }
        return null;
    }

    public IValueReference visitThisExpression(ThisExpression node) {
        return this.peekContext().getThis();
    }

    public IValueReference visitThrowStatement(ThrowStatement node) {
        this.visit((ASTNode)node.getException());
        return null;
    }

    public IValueReference visitTryStatement(TryStatement node) {
        this.visit((ASTNode)node.getBody());
        for (CatchClause catchClause : node.getCatches()) {
            NestedValueCollection collection = new NestedValueCollection(this.peekContext());
            collection.createChild(catchClause.getException().getName());
            this.enterContext(collection);
            this.visit((ASTNode)catchClause.getStatement());
            this.leaveContext();
        }
        if (node.getFinally() != null) {
            this.visit((ASTNode)node.getFinally().getStatement());
        }
        return null;
    }

    public IValueReference visitTypeOfExpression(TypeOfExpression node) {
        return this.context.getFactory().createString(this.peekContext());
    }

    public IValueReference visitUnaryOperation(UnaryOperation node) {
        return (IValueReference)this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitVariableStatment(VariableStatement node) {
        IValueCollection context = this.peekContext();
        IValueReference result = null;
        for (VariableDeclaration declaration : node.getVariables()) {
            result = this.createVariable(context, declaration);
        }
        return result;
    }

    public IValueReference visitVoidExpression(VoidExpression node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public IValueReference visitVoidOperator(VoidOperator node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public IValueReference visitWhileStatement(WhileStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    public IValueReference visitWithStatement(WithStatement node) {
        IValueReference with = (IValueReference)this.visit((ASTNode)node.getExpression());
        if (with != null) {
            WithValueCollection withCollection = new WithValueCollection(this.peekContext(), with);
            this.enterContext(withCollection);
            this.visit((ASTNode)node.getStatement());
            this.leaveContext();
        } else {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    public IValueReference visitXmlLiteral(XmlLiteral node) {
        return this.context.getFactory().createXML(this.peekContext());
    }

    public IValueReference visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
        return this.context.getFactory().createXML(this.peekContext());
    }

    public IValueReference visitYieldOperator(YieldOperator node) {
        IValueReference reference;
        IValueReference value = (IValueReference)this.visit((ASTNode)node.getExpression());
        if (value != null && (reference = this.peekContext().getReturnValue()) != null) {
            reference.addValue(value, true);
        }
        return null;
    }

    private class Branching {
        private Branching() {
        }

        public void end() {
            TypeInferencerVisitor.this.branchings.remove(this);
        }
    }
}

