/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionString;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.TransparentRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostCollection {
    public static final int FUNCTION = 1;
    public static final int NORMAL = 0;
    private final HostCollection parent;
    private final Map<String, IReference> reference = new HashMap<String, IReference>();
    private final Map<Object, HostCollection> functions = new HashMap<Object, HostCollection>();
    private final int type;
    private final String name;
    private Set<TransparentRef> transparent = new HashSet<TransparentRef>();

    public IReference getReference(String key) {
        IReference reference2 = this.reference.get(key);
        if (reference2 == null && this.parent != null) {
            return this.parent.getReference(key);
        }
        return reference2;
    }

    public Set<IReference> queryElements(String completion, boolean useGlobal) {
        completion = CompletionString.parse(completion, false);
        IReference r = this.getReference(completion);
        HashSet<IReference> res = new HashSet<IReference>();
        if (r != null) {
            res.add(r);
            return res;
        }
        int pos = completion.indexOf(46);
        if (pos == -1) {
            return res;
        }
        String rootName = completion.substring(0, pos);
        r = this.getReference(rootName);
        ++pos;
        while (pos != 0) {
            if (r == null) {
                return new HashSet<IReference>();
            }
            int k = completion.indexOf(46, pos);
            String field = k == -1 ? completion.substring(pos) : completion.substring(pos, k);
            r = r.getChild(field, useGlobal);
            pos = k + 1;
        }
        if (r == null) {
            return res;
        }
        res.add(r);
        return res;
    }

    public HostCollection() {
        this(null, null, 0);
    }

    public HostCollection(HostCollection parent) {
        this(parent, null, 0);
    }

    public HostCollection(HostCollection parent, String name, int type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    public Map<String, IReference> getReferences() {
        return this.reference;
    }

    public void write(String key, IReference ref) {
        Assert.isNotNull((Object)ref);
        this.reference.put(key, ref);
    }

    public void add(String key, IReference ref) {
        Assert.isNotNull((Object)ref);
        IReference object = this.reference.get(key);
        if (object == null) {
            this.reference.put(key, ref);
        } else if (object != ref) {
            if (object instanceof CombinedOrReference) {
                ((CombinedOrReference)object).addReference(ref);
                return;
            }
            if (ref instanceof TransparentRef && ((TransparentRef)ref).evaluateReference == object) {
                this.reference.put(key, ref);
                return;
            }
            if (object instanceof TransparentRef && ((TransparentRef)object).evaluateReference instanceof CombinedOrReference) {
                ((CombinedOrReference)((TransparentRef)object).evaluateReference).addReference(ref);
                return;
            }
            if (ref instanceof CombinedOrReference) {
                ((CombinedOrReference)ref).addReference(object);
            } else {
                CombinedOrReference cor = new CombinedOrReference();
                cor.addReference(ref);
                cor.addReference(object);
                ref = cor;
            }
            this.reference.put(key, ref);
        }
    }

    public void oneOf(String key, IReference ref, IReference other) {
        Assert.isNotNull((Object)ref);
        Assert.isNotNull((Object)other);
        if (ref.isChildishReference() || other.isChildishReference()) {
            this.add(key, ref);
            this.add(key, other);
        } else if (ref instanceof CombinedOrReference) {
            CombinedOrReference orReference = (CombinedOrReference)ref;
            orReference.addReference(other);
            this.reference.put(key, ref);
        } else if (other instanceof CombinedOrReference) {
            CombinedOrReference orReference = (CombinedOrReference)other;
            orReference.addReference(ref);
            this.reference.put(key, other);
        } else {
            CombinedOrReference cor = new CombinedOrReference();
            cor.addReference(ref);
            cor.addReference(other);
            this.reference.put(key, cor);
        }
    }

    public HostCollection getParent() {
        return this.parent;
    }

    public void mergeIf(HostCollection cl) {
        for (Map.Entry<String, IReference> entry : cl.reference.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        cl.patch(this);
    }

    public void mergeElseIf(HostCollection cl, HostCollection cl1) {
        HashSet sm = new HashSet(cl.reference.keySet());
        sm.retainAll((Collection)cl1.reference.keySet());
        for (String s : sm) {
            IReference rm = cl.reference.get(s);
            IReference rm1 = cl1.reference.get(s);
            this.oneOf(s, rm, rm1);
        }
        cl1.patch(this);
        cl.patch(this);
    }

    public void override(HostCollection other) {
        this.reference.putAll(other.reference);
    }

    public void setReference(String objId, IReference root) {
        this.reference.put(objId, root);
    }

    public IReference getReferenceNoParentContext(String rootName) {
        return this.reference.get(rootName);
    }

    public IReference queryElement(String key, boolean useGlobal) {
        Set<IReference> queryElement = this.queryElements(key, useGlobal);
        if (queryElement.isEmpty()) {
            return null;
        }
        return queryElement.iterator().next();
    }

    public void addTransparent(TransparentRef transparentRef) {
        this.transparent.add(transparentRef);
    }

    private void patch(HostCollection col) {
        for (TransparentRef next : this.transparent) {
            next.patchRef(col);
        }
    }

    public void recordDelete(String objId) {
        this.reference.remove(objId);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public void recordFunction(Object function, HostCollection collection) {
        this.functions.put(function, collection);
    }

    public HostCollection getFunction(Object funObject) {
        return this.functions.get(funObject);
    }

    public String toString() {
        return "HostCollection(" + (this.name != null ? this.name : "") + ")";
    }
}

