/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.internal.javascript.ti.ConstantValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.ReferenceKind;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

public class SelectionVisitor
extends TypeInferencerVisitor {
    private final ASTNode target;
    private IValueReference value;

    public SelectionVisitor(ITypeInferenceContext context, ASTNode target) {
        super(context);
        this.target = target;
    }

    public IValueReference getValue() {
        return this.value;
    }

    public IValueReference visit(ASTNode node) {
        IValueReference result = (IValueReference)super.visit(node);
        if (node == this.target) {
            this.value = result;
        }
        return result;
    }

    protected IValueReference extractNamedChild(IValueReference parent, Expression name) {
        IValueReference result = super.extractNamedChild(parent, name);
        if (name == this.target) {
            this.value = result;
        }
        return result;
    }

    protected Type resolveType(org.eclipse.dltk.javascript.ast.Type type) {
        Type result = super.resolveType(type);
        if (type == this.target) {
            if (result != null) {
                this.value = new ConstantValue(result);
                this.value.setKind(ReferenceKind.TYPE);
            } else {
                this.value = null;
            }
        }
        return result;
    }
}

