/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.mixin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinParser;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.mixin.MixinModelRegistry;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.OverflowingLRUCache;
import org.eclipse.dltk.internal.core.mixin.IInternalMixinElement;
import org.eclipse.dltk.internal.core.mixin.MixinCache;
import org.eclipse.dltk.internal.core.mixin.MixinManager;
import org.eclipse.dltk.internal.core.util.LRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixinModel {
    private static final long REQUEST_CACHE_EXPIRE_TIME = 2000L;
    private static final boolean DEBUG = false;
    private static final boolean TRACE = false;
    public static final String SEPARATOR = String.valueOf('{');
    private static final int CACHE_LIMIT = 250000;
    private final MixinCache cache;
    private Map<ISourceModule, List<MixinElement>> elementToMixinCache = new HashMap<ISourceModule, List<MixinElement>>();
    private final IDLTKLanguageToolkit toolkit;
    private final IScriptProject project;
    private MixinRequestor mixinRequestor = new MixinRequestor();
    private ISourceModule currentModule;
    private Set modulesToReparse = new HashSet();
    public long removes = 1L;
    private final RequestCache requestCache = new RequestCache(500);
    private Set<String> existKeysCache = new HashSet<String>();
    private Set<String> notExistKeysCache = new HashSet<String>();
    private IMixinChangedListener changedListener = new IMixinChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            IModelElementDelta delta = event.getDelta();
            this.processDelta(delta);
        }

        private void processDelta(IModelElementDelta delta) {
            IModelElement element;
            block13: {
                element = delta.getElement();
                if (delta.getKind() == 2 || delta.getKind() == 4 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 4) != 0) {
                    if (element.getElementType() != 5 && element.getElementType() != 3 && element.getElementType() != 4 && element.getElementType() != 1 && element.getElementType() != 2) {
                        ISourceModule module = (ISourceModule)element.getAncestor(5);
                        MixinModel.this.remove(module);
                    }
                    if (element.getElementType() == 5) {
                        MixinModel.this.remove((ISourceModule)element);
                    }
                }
                if (element.getElementType() == 2 && delta.getKind() == 4 && (delta.getFlags() & 0x20000) != 0) {
                    MixinModel.this.clear();
                    return;
                }
                if (!(delta.getKind() != 2 && delta.getKind() != 4 || element.getElementType() != 4 && element.getElementType() != 3 || delta.getAffectedChildren().length != 0)) {
                    try {
                        element.accept(new IModelElementVisitor(){

                            public boolean visit(IModelElement element) {
                                if (element.getElementType() == 5) {
                                    MixinModel.this.remove((ISourceModule)element);
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block13;
                        e.printStackTrace();
                    }
                }
            }
            if (delta.getKind() == 1) {
                if (element.getElementType() == 5 && MixinModel.this.modulesToReparse.add(element)) {
                    MixinModel.this.reportModule((ISourceModule)element);
                }
                MixinModel.this.notExistKeysCache.clear();
                MixinModel.this.requestCache.flush();
            }
            if ((delta.getFlags() & 8) != 0) {
                IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                int i = 0;
                while (i < affectedChildren.length) {
                    IModelElementDelta child = affectedChildren[i];
                    this.processDelta(child);
                    ++i;
                }
            } else if (delta.getKind() == 2 && element.getElementType() == 4) {
                MixinModel.this.removeFolder((IScriptFolder)element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            int eventType = event.getType();
            IResource resource = event.getResource();
            switch (eventType) {
                case 2: {
                    if (resource.getType() != 4 || !DLTKLanguageManager.hasScriptNature((IProject)resource) || MixinModel.this.project == null || !resource.equals((Object)MixinModel.this.project.getProject())) break;
                    MixinModel.this.clear();
                    return;
                }
                case 4: {
                    if (resource.getType() == 4 && DLTKLanguageManager.hasScriptNature((IProject)resource)) {
                        if (MixinModel.this.project != null && resource.equals((Object)MixinModel.this.project.getProject())) {
                            MixinModel.this.clear();
                            return;
                        }
                        ArrayList<ISourceModule> toRemove = new ArrayList<ISourceModule>();
                        Map map = MixinModel.this.elementToMixinCache;
                        synchronized (map) {
                            IProject project = (IProject)resource;
                            for (ISourceModule module : MixinModel.this.elementToMixinCache.keySet()) {
                                IScriptProject scriptProject = module.getScriptProject();
                                if (scriptProject != null) {
                                    IProject prj = scriptProject.getProject();
                                    if ((prj == null || !prj.equals((Object)project)) && prj != null) continue;
                                    toRemove.add(module);
                                    continue;
                                }
                                toRemove.add(module);
                            }
                        }
                        for (ISourceModule module : toRemove) {
                            MixinModel.this.remove(module);
                        }
                    }
                    return;
                }
            }
        }
    };
    private final ListenerList mixinObjectInitializeListeners = new ListenerList();

    public MixinModel(IDLTKLanguageToolkit toolkit) {
        this(toolkit, null);
    }

    public MixinModel(IDLTKLanguageToolkit toolkit, IScriptProject project) {
        this.toolkit = toolkit;
        this.project = project;
        this.cache = new MixinCache(250000);
        DLTKCore.addElementChangedListener(this.changedListener, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.changedListener);
        MixinModelRegistry.register(this);
    }

    public void stop() {
        DLTKCore.removeElementChangedListener(this.changedListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.changedListener);
        MixinModelRegistry.unregister(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMixinElement get(String key) {
        if (this.notExistKeysCache.contains(key)) {
            return null;
        }
        if (this.removes == 0L && this.cache.get(key) == null) {
            return null;
        }
        MixinElement element = this.getCreateEmpty(key);
        this.buildElementTree(element);
        if (element.isFinal() && element.sourceModules.size() > 0) {
            this.existKeysCache.add(key);
            return element;
        }
        this.notExistKeysCache.add(key);
        MixinCache mixinCache = this.cache;
        synchronized (mixinCache) {
            this.cache.remove(element.key);
            this.cache.resetSpaceLimit(250000, element);
        }
        return null;
    }

    private IDLTKSearchScope createSearchScope() {
        if (this.project != null) {
            return SearchEngine.createSearchScope(this.project);
        }
        return SearchEngine.createWorkspaceScope(this.toolkit);
    }

    public IMixinElement[] find(String pattern, long delta) {
        return this.find(pattern, (IProgressMonitor)new NullProgressMonitor());
    }

    public IMixinElement[] find(String pattern, IProgressMonitor monitor) {
        RequestCacheEntry entry = this.findFromMixin(pattern, monitor);
        if (entry.modules == null || entry.modules.size() == 0) {
            return new IMixinElement[0];
        }
        for (ISourceModule module : entry.modules) {
            this.reportModule(module);
        }
        HashSet<MixinElement> result = new HashSet<MixinElement>();
        for (String key : entry.keys) {
            MixinElement element = this.getCreateEmpty(key);
            if (!monitor.isCanceled()) {
                this.markElementAsFinal(element);
            }
            this.addKeyToSet(result, element, pattern);
        }
        return result.toArray(new IMixinElement[result.size()]);
    }

    private synchronized void addKeyToSet(Set<MixinElement> result, MixinElement element, String pattern) {
        if (!CharOperation.match(pattern.toCharArray(), element.key.toCharArray(), true)) {
            return;
        }
        result.add(element);
        this.existKeysCache.add(element.key);
        this.notExistKeysCache.remove(element.key);
        IMixinElement[] children = element.children.toArray(new IMixinElement[element.children.size()]);
        int i = 0;
        while (i < children.length) {
            this.addKeyToSet(result, (MixinElement)children[i], pattern);
            ++i;
        }
    }

    private RequestCacheEntry findFromMixin(String pattern, IProgressMonitor monitor) {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        RequestCacheEntry entry = (RequestCacheEntry)this.requestCache.get(pattern);
        if (entry == null || entry.expireTime < System.currentTimeMillis()) {
            HashMap<ISourceModule, Set<String>> keys = new HashMap<ISourceModule, Set<String>>();
            ISourceModule[] containedModules = null;
            entry = new RequestCacheEntry();
            try {
                containedModules = SearchEngine.searchMixinSources(this.createSearchScope(), pattern, this.toolkit, keys, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return entry;
            }
            entry.expireTime = System.currentTimeMillis() + 2000L;
            entry.modules = new HashSet<ISourceModule>((Collection)Arrays.asList(containedModules));
            entry.prefix = pattern;
            Collection values = keys.values();
            entry.keys = new HashSet<String>();
            for (Set vals : values) {
                entry.keys.addAll(vals);
            }
            if (!monitor.isCanceled()) {
                this.requestCache.put(pattern, entry);
            }
        }
        p.done(this.getNature(), "Mixin model search items", 0L);
        return entry;
    }

    public IMixinElement[] find(String pattern) {
        return this.find(pattern, (IProgressMonitor)new NullProgressMonitor());
    }

    public String[] findKeys(String pattern) {
        return this.findKeys(pattern, (IProgressMonitor)new NullProgressMonitor());
    }

    public String[] findKeys(String pattern, IProgressMonitor monitor) {
        RequestCacheEntry entry = this.findFromMixin(pattern, monitor);
        return entry.keys.toArray(new String[entry.keys.size()]);
    }

    public boolean keyExists(String key) {
        boolean exist;
        if (this.removes == 0L) {
            return this.cache.get(key) != null;
        }
        MixinElement e = (MixinElement)this.cache.get(key);
        if (e != null && e.sourceModules.size() > 0) {
            return true;
        }
        if (this.existKeysCache.contains(key)) {
            return true;
        }
        if (this.notExistKeysCache.contains(key)) {
            return false;
        }
        boolean bl = exist = this.get(key) != null;
        if (exist) {
            if (this.existKeysCache.size() > 500000) {
                this.existKeysCache.clear();
            }
            this.existKeysCache.add(key);
        } else {
            if (this.notExistKeysCache.size() > 500000) {
                this.notExistKeysCache.clear();
            }
            this.notExistKeysCache.add(key);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildElementTree(MixinElement element) {
        if (element.isFinal()) {
            return;
        }
        ISourceModule[] containedModules = this.findModules(element.getKey());
        if (containedModules.length == 0) {
            MixinCache mixinCache = this.cache;
            synchronized (mixinCache) {
                this.cache.remove(element.key);
                this.cache.resetSpaceLimit(250000, element);
            }
            return;
        }
        int i = 0;
        while (i < containedModules.length) {
            this.reportModule(containedModules[i]);
            ++i;
        }
        this.markElementAsFinal(element);
    }

    private synchronized void markElementAsFinal(MixinElement element) {
        element.bFinal = true;
        Iterator i = element.children.iterator();
        while (i.hasNext()) {
            this.markElementAsFinal((MixinElement)i.next());
        }
    }

    public synchronized void reportModule(ISourceModule sourceModule) {
        if (!this.elementToMixinCache.containsKey(sourceModule)) {
            this.elementToMixinCache.put(sourceModule, new ArrayList());
        } else if (!this.modulesToReparse.remove(sourceModule)) {
            return;
        }
        try {
            IMixinParser mixinParser = MixinManager.getMixinParser(sourceModule);
            if (mixinParser != null) {
                this.currentModule = sourceModule;
                mixinParser.setRequirestor(this.mixinRequestor);
                mixinParser.parserSourceModule(true, sourceModule);
                this.currentModule = null;
            }
        }
        catch (CoreException e) {
            DLTKCore.error("Error in reportModule", e);
            return;
        }
    }

    public ISourceModule[] findModules(String key, IProgressMonitor monitor) {
        RequestCacheEntry entry = this.findFromMixin(key, monitor);
        return entry.modules.toArray(new ISourceModule[entry.modules.size()]);
    }

    public ISourceModule[] findModules(String key) {
        return this.findModules(key, (IProgressMonitor)new NullProgressMonitor());
    }

    private synchronized MixinElement getCreateEmpty(String key) {
        MixinElement element = (MixinElement)this.cache.get(key);
        if (element == null) {
            element = new MixinElement(key, this.currentModule);
            this.cache.put(key, element);
            this.cache.ensureSpaceLimit(1, element);
        }
        return element;
    }

    private final String getLogContext() {
        if (this.project == null) {
            return "[MixinModel|$" + this.toolkit.getLanguageName() + "$]";
        }
        return "[MixinModel|" + this.project.getElementName() + "]";
    }

    private final void log(String message) {
        System.out.println(String.valueOf(this.getLogContext()) + " " + message);
    }

    public synchronized void remove(ISourceModule element) {
        if (this.elementToMixinCache.containsKey(element)) {
            this.removeFromRequestCache(element);
            List<MixinElement> elements = this.elementToMixinCache.get(element);
            int i = 0;
            while (i < elements.size()) {
                ++this.removes;
                MixinElement mixin = elements.get(i);
                this.existKeysCache.remove(mixin.key);
                this.notExistKeysCache.remove(mixin.key);
                mixin.bFinal = false;
                mixin.sourceModules.remove(element);
                mixin.sourceModuleToObject.remove(element);
                if (mixin.sourceModules.size() == 0) {
                    MixinElement parent;
                    String parentKey = mixin.getParentKey();
                    if (parentKey != null && (parent = (MixinElement)this.cache.get(parentKey)) != null) {
                        parent.children.remove(mixin);
                        parent.bFinal = false;
                    }
                    this.cache.remove(mixin.key);
                    this.cache.resetSpaceLimit(250000, mixin);
                }
                ++i;
            }
            this.elementToMixinCache.remove(element);
        }
    }

    protected void removeFolder(IScriptFolder folder) {
        IPath folderPath = folder.getPath();
        ArrayList<ISourceModule> modulesToRemove = new ArrayList<ISourceModule>();
        for (ISourceModule module : this.elementToMixinCache.keySet()) {
            IPath path = module.getPath();
            if (!folderPath.isPrefixOf(path)) continue;
            modulesToRemove.add(module);
        }
        for (ISourceModule module : modulesToRemove) {
            this.remove(module);
        }
    }

    private void removeFromRequestCache(ISourceModule element) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Enumeration enumeration = this.requestCache.elements();
        while (enumeration.hasMoreElements()) {
            RequestCacheEntry entry = (RequestCacheEntry)enumeration.nextElement();
            if (entry.modules == null || !entry.modules.contains(element)) continue;
            keysToRemove.add(entry.prefix);
        }
        for (String key : keysToRemove) {
            this.requestCache.remove(key);
        }
    }

    public void makeAllModuleElementsFinal(ISourceModule module) {
        if (this.elementToMixinCache.containsKey(module)) {
            List<MixinElement> elements = this.elementToMixinCache.get(module);
            int i = 0;
            while (i < elements.size()) {
                ++this.removes;
                MixinElement mixin = elements.get(i);
                mixin.bFinal = true;
                ++i;
            }
        }
    }

    public void makeAllElementsFinalIfNoCacheRemoves() {
        if (this.removes != 0L) {
            return;
        }
        Enumeration elements = this.cache.elements();
        while (elements.hasMoreElements()) {
            MixinElement e = (MixinElement)elements.nextElement();
            e.bFinal = true;
        }
    }

    public void setRemovesToZero() {
        this.removes = 0L;
    }

    public void clearKeysCache(String key) {
        this.existKeysCache.remove(key);
        this.notExistKeysCache.remove(key);
        this.requestCache.remove(key);
    }

    public void clearKeysCache() {
        this.existKeysCache.clear();
        this.notExistKeysCache.clear();
        this.requestCache.clone();
    }

    public void addObjectInitializeListener(IMixinObjectInitializeListener mixinObjectInitializeListener) {
        this.mixinObjectInitializeListeners.add((Object)mixinObjectInitializeListener);
    }

    public void removeObjectInitializeListener(IMixinObjectInitializeListener mixinObjectInitializeListener) {
        this.mixinObjectInitializeListeners.remove((Object)mixinObjectInitializeListener);
    }

    private void notifyInitializeListener(IMixinElement element, ISourceModule module, Object o) {
        Object[] listeners = this.mixinObjectInitializeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IMixinObjectInitializeListener)listeners[i]).initialize(element, o, module);
            ++i;
        }
    }

    protected void clear() {
        this.cache.flush();
        this.elementToMixinCache.clear();
        this.existKeysCache.clear();
        this.notExistKeysCache.clear();
        this.modulesToReparse.clear();
        this.requestCache.flush();
    }

    public String getNature() {
        return this.toolkit.getNatureId();
    }

    private static interface IMixinChangedListener
    extends IElementChangedListener,
    IResourceChangeListener {
    }

    public static interface IMixinObjectInitializeListener {
        public void initialize(IMixinElement var1, Object var2, ISourceModule var3);
    }

    private class MixinElement
    implements IMixinElement,
    IInternalMixinElement {
        private String key;
        private boolean bFinal = false;
        private List<ISourceModule> sourceModules = new ArrayList<ISourceModule>();
        private Map<ISourceModule, Object> sourceModuleToObject = new HashMap<ISourceModule, Object>();
        private Set<IMixinElement> children = new HashSet<IMixinElement>();

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MixinElement) {
                return this.key.equals(((MixinElement)obj).key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public MixinElement(String key) {
            this.key = key;
        }

        public String toString() {
            return String.valueOf(this.getLastKeySegment()) + " final[" + this.bFinal + "]" + this.children + " ";
        }

        public MixinElement(IMixinRequestor.ElementInfo info, ISourceModule module) {
            this(info.key, mixinModel.currentModule);
            this.addInfo(info, module);
        }

        void addInfo(IMixinRequestor.ElementInfo info, ISourceModule module) {
            if (info.object != null) {
                Object object = this.sourceModuleToObject.get(module);
                if (object != null) {
                    if (object instanceof List) {
                        ((List)object).add(info.object);
                    } else {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(object);
                        list.add(info.object);
                        this.sourceModuleToObject.put(module, list);
                    }
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(info.object);
                    this.sourceModuleToObject.put(module, list);
                }
            }
        }

        public MixinElement(String key, ISourceModule currentModule) {
            this.key = key;
            this.addModule(currentModule);
        }

        void addModule(ISourceModule currentModule) {
            if (currentModule != null && !this.sourceModules.contains(currentModule)) {
                this.sourceModules.add(currentModule);
            }
        }

        public IMixinElement[] getChildren() {
            this.validate();
            return this.children.toArray(new IMixinElement[this.children.size()]);
        }

        public IMixinElement getChildren(String key) {
            this.validate();
            return MixinModel.this.get(String.valueOf(this.key) + IMixinRequestor.MIXIN_NAME_SEPARATOR + key);
        }

        public String getKey() {
            return this.key;
        }

        protected String getParentKey() {
            int pos = this.key.lastIndexOf(IMixinRequestor.MIXIN_NAME_SEPARATOR);
            if (pos == -1) {
                return null;
            }
            return this.key.substring(0, pos);
        }

        public String getLastKeySegment() {
            int pos = this.key.lastIndexOf(IMixinRequestor.MIXIN_NAME_SEPARATOR);
            if (pos == -1) {
                return this.key;
            }
            return this.key.substring(pos + 1);
        }

        public IMixinElement getParent() {
            String parentKey = this.getParentKey();
            if (parentKey == null) {
                return null;
            }
            return MixinModel.this.get(parentKey);
        }

        public ISourceModule[] getSourceModules() {
            this.validate();
            if (!this.isFinal()) {
                MixinModel.this.get(this.key);
            }
            return this.sourceModules.toArray(new ISourceModule[this.sourceModules.size()]);
        }

        public Object[] getObjects(ISourceModule module) {
            this.validate();
            Object o = this.sourceModuleToObject.get(module);
            if (o instanceof List) {
                Object[] objs = ((List)o).toArray();
                int i = 0;
                while (i < objs.length) {
                    MixinModel.this.notifyInitializeListener(this, module, objs[i]);
                    ++i;
                }
                return objs;
            }
            if (o != null) {
                MixinModel.this.notifyInitializeListener(this, module, o);
                return new Object[]{o};
            }
            return new Object[0];
        }

        public Object[] getAllObjects() {
            this.validate();
            HashSet<Object> objects = new HashSet<Object>();
            for (ISourceModule module : this.sourceModules) {
                Object[] objs = this.getObjects(module);
                int j = 0;
                while (j < objs.length) {
                    objects.add(objs[j]);
                    ++j;
                }
            }
            return objects.toArray();
        }

        public boolean isFinal() {
            return this.bFinal;
        }

        public void close() {
            MixinModel.this.existKeysCache.remove(this.key);
            MixinModel.this.notExistKeysCache.remove(this.key);
            ++MixinModel.this.removes;
            this.bFinal = false;
            int i = 0;
            while (i < this.sourceModules.size()) {
                ISourceModule module = this.sourceModules.get(i);
                List list = (List)MixinModel.this.elementToMixinCache.get(module);
                if (list != null) {
                    list.remove(this);
                    if (list.size() == 0) {
                        MixinModel.this.elementToMixinCache.remove(module);
                    }
                }
                if (!MixinModel.this.modulesToReparse.contains(module) && MixinModel.this.elementToMixinCache.containsKey(module)) {
                    MixinModel.this.modulesToReparse.add(module);
                }
                ++i;
            }
            this.sourceModules.clear();
            this.sourceModuleToObject.clear();
            String parentKey = this.getParentKey();
            MixinElement element = this;
            while (parentKey != null) {
                MixinElement parent = (MixinElement)MixinModel.this.cache.get(parentKey);
                if (parent == null) break;
                MixinModel.this.existKeysCache.remove(parent.key);
                MixinModel.this.notExistKeysCache.remove(parent.key);
                ++MixinModel.this.removes;
                parent.children.remove(element);
                parent.bFinal = false;
                element = parent;
                parentKey = parent.getParentKey();
            }
        }

        private void validate() {
            if (!this.isFinal()) {
                MixinModel.this.buildElementTree(this);
            }
        }
    }

    private class MixinRequestor
    implements IMixinRequestor {
        private MixinRequestor() {
        }

        public void reportElement(IMixinRequestor.ElementInfo info) {
            MixinModel.this.existKeysCache.add(info.key);
            MixinModel.this.notExistKeysCache.remove(info.key);
            String[] list = info.key.split("\\" + IMixinRequestor.MIXIN_NAME_SEPARATOR);
            MixinElement element = MixinModel.this.getCreateEmpty(info.key);
            this.addElementToModules(element);
            element.addModule(MixinModel.this.currentModule);
            element.addInfo(info, MixinModel.this.currentModule);
            if (list.length != 1) {
                int i = 0;
                while (i < list.length - 1) {
                    MixinElement parent = MixinModel.this.getCreateEmpty(element.getParentKey());
                    if (!parent.children.contains(element)) {
                        parent.children.add(element);
                    }
                    this.addElementToModules(parent);
                    element = parent;
                    ++i;
                }
            }
        }

        private void addElementToModules(MixinElement element) {
            ArrayList<MixinElement> elements = (ArrayList<MixinElement>)MixinModel.this.elementToMixinCache.get(MixinModel.this.currentModule);
            if (elements == null) {
                elements = new ArrayList<MixinElement>();
                MixinModel.this.elementToMixinCache.put(MixinModel.this.currentModule, elements);
            }
            elements.add(element);
        }
    }

    private static class RequestCache
    extends OverflowingLRUCache {
        public RequestCache(int size) {
            super(size);
        }

        public RequestCache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LRUCache.LRUCacheEntry entry) {
            return true;
        }

        protected LRUCache newInstance(int size, int overflow) {
            return new RequestCache(size, overflow);
        }
    }

    private static class RequestCacheEntry {
        long expireTime;
        String prefix = null;
        Set<ISourceModule> modules = null;
        Set<String> keys = null;

        private RequestCacheEntry() {
        }
    }
}

