/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.EnvironmentVariableContentProvider;
import org.eclipse.dltk.internal.debug.ui.interpreters.EnvironmentVariablesFileUtils;
import org.eclipse.dltk.internal.debug.ui.interpreters.EnvironmentVariablesLabelProvider;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.ui.dialogs.MultipleInputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.dialogs.ListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterEnvironmentVariablesBlock
implements SelectionListener,
ISelectionChangedListener {
    private static final String VALUE_LABEL = InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_value;
    private static final String NAME_LABEL = InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_name;
    protected boolean fInCallback = false;
    protected IInterpreterInstall fInterpreterInstall;
    protected IInterpreterInstallType fInterpreterInstallType;
    protected EnvironmentVariableContentProvider fEnvironmentVariablesContentProvider;
    protected TreeViewer fVariablesViewer;
    private Button fRemoveButton;
    private Button fAddExistedButton;
    private Button fAddButton;
    private Button fEditButton;
    private Button fImportButton;
    private Button fExportButton;
    protected AddScriptInterpreterDialog fDialog;

    protected AbstractInterpreterEnvironmentVariablesBlock(AddScriptInterpreterDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.createControlsIn(comp);
        return comp;
    }

    public void createControlsIn(Composite comp) {
        this.fVariablesViewer = new TreeViewer(comp);
        GridData gd = new GridData(1808);
        gd.heightHint = 6;
        this.fVariablesViewer.getControl().setLayoutData((Object)gd);
        this.fEnvironmentVariablesContentProvider = new EnvironmentVariableContentProvider();
        this.fVariablesViewer.setContentProvider((IContentProvider)this.fEnvironmentVariablesContentProvider);
        this.fVariablesViewer.setLabelProvider(this.getLabelProvider());
        this.fVariablesViewer.setInput((Object)this);
        this.fVariablesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        this.fAddButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_add);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fAddExistedButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_addFromEnvironment);
        this.fAddExistedButton.addSelectionListener((SelectionListener)this);
        this.fEditButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_edit);
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fRemoveButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_6);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fImportButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_import);
        this.fImportButton.addSelectionListener((SelectionListener)this);
        this.fExportButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_export);
        this.fExportButton.addSelectionListener((SelectionListener)this);
    }

    public void restoreDefaultVariables() {
        this.fEnvironmentVariablesContentProvider.setVariables(new EnvironmentVariable[0]);
        this.update();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        EnvironmentVariable[] standins = this.fEnvironmentVariablesContentProvider.getStandins();
        int i = 0;
        while (i < standins.length) {
            IStatus st = standins[i].validate();
            if (!st.isOK()) {
                status = st;
                break;
            }
            ++i;
        }
        this.updateDialogStatus(status);
    }

    public void performApply(IInterpreterInstall install) {
        EnvironmentVariable[] libs = this.fEnvironmentVariablesContentProvider.getVariables();
        install.setEnvironmentVariables(libs);
    }

    public EnvironmentVariable[] getEnvironmentVariables() {
        EnvironmentVariable[] libs = this.fEnvironmentVariablesContentProvider.getVariables();
        return libs;
    }

    protected boolean isDefaultLocations() {
        EnvironmentVariable[] def;
        EnvironmentVariable[] EnvironmentVariables = this.fEnvironmentVariablesContentProvider.getVariables();
        IInterpreterInstall install = this.getInterpreterInstall();
        if (install == null || EnvironmentVariables == null) {
            return true;
        }
        IFileHandle installLocation = install.getInstallLocation();
        if (installLocation != null && (def = new EnvironmentVariable[0]).length == EnvironmentVariables.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)EnvironmentVariables[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected IInterpreterInstall getInterpreterInstall() {
        return this.fInterpreterInstall;
    }

    protected IEnvironment getEnvironment() {
        if (this.fInterpreterInstall != null) {
            return this.fInterpreterInstall.getEnvironment();
        }
        return this.fDialog.getEnvironment();
    }

    protected IInterpreterInstallType getInterpreterInstallType() {
        return this.fInterpreterInstallType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fRemoveButton) {
            EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
            this.fEnvironmentVariablesContentProvider.remove((IStructuredSelection)this.fVariablesViewer.getSelection());
            this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
            this.fDialog.updateValidateInterpreterLocation();
        } else if (source == this.fAddExistedButton) {
            this.addExisted((IStructuredSelection)this.fVariablesViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.handleAdd();
        } else if (source == this.fEditButton) {
            EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
            if (this.edit((IStructuredSelection)this.fVariablesViewer.getSelection())) {
                this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
                this.fDialog.updateValidateInterpreterLocation();
            }
        } else if (source == this.fImportButton) {
            if (this.performImport()) {
                this.fDialog.updateValidateInterpreterLocation();
            }
        } else if (source == this.fExportButton) {
            this.performExport();
        }
        this.update();
    }

    private void performExport() {
        FileDialog dialog = new FileDialog(this.fDialog.getShell(), 8192);
        dialog.setOverwrite(true);
        dialog.setText(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_exportEnvironmentVariablesToFile);
        String file = dialog.open();
        if (file != null) {
            EnvironmentVariable[] variables = this.fEnvironmentVariablesContentProvider.getVariables();
            try {
                EnvironmentVariablesFileUtils.save(variables, file);
            }
            catch (Exception e) {
                this.showErrorMessage(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_environmentExport, e.getMessage());
            }
        }
    }

    private void showErrorMessage(String title, String text) {
        MessageBox box = new MessageBox(this.fDialog.getShell(), 1);
        box.setText(title);
        box.setMessage(text);
        box.open();
    }

    private boolean performImport() {
        FileDialog dialog = new FileDialog(this.fDialog.getShell(), 4096);
        dialog.setText(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_importEnvironmentVariablesFromFile);
        String file = dialog.open();
        if (file != null) {
            File handle = new File(file);
            if (!handle.exists()) {
                String text = InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_selectedFileDoesntExist;
                this.showErrorMessage(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_environmentImport, text);
                return false;
            }
            EnvironmentVariable[] vars = null;
            try {
                vars = EnvironmentVariablesFileUtils.load(file);
            }
            catch (Exception e) {
                this.showErrorMessage(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_environmentImport, e.getMessage());
                return false;
            }
            if (vars != null) {
                EnvironmentVariable[] variables = this.fEnvironmentVariablesContentProvider.getVariables();
                HashSet nvars = new HashSet();
                nvars.addAll(Arrays.asList(vars));
                nvars.addAll(Arrays.asList(variables));
                this.fEnvironmentVariablesContentProvider.setVariables(nvars.toArray(new EnvironmentVariable[nvars.size()]));
            }
            return true;
        }
        return false;
    }

    private boolean edit(IStructuredSelection selection) {
        EnvironmentVariable var = (EnvironmentVariable)selection.getFirstElement();
        if (var == null) {
            return false;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.fDialog.getShell(), InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_editVariable);
        dialog.addTextField(NAME_LABEL, originalName, false);
        dialog.addVariablesField(VALUE_LABEL, value, true);
        if (dialog.open() != 0) {
            return false;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            EnvironmentVariable newVar = new EnvironmentVariable(name, value);
            if (this.fEnvironmentVariablesContentProvider.addVariable(newVar)) {
                this.fEnvironmentVariablesContentProvider.remove((IStructuredSelection)new StructuredSelection((Object)var));
                this.fVariablesViewer.setSelection((ISelection)new StructuredSelection((Object)newVar), true);
            }
        } else {
            var.setValue(value);
            this.fVariablesViewer.refresh(true);
        }
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void handleAdd() {
        EnvironmentVariable newVar = this.add();
        if (newVar == null) {
            return;
        }
        EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
        this.fEnvironmentVariablesContentProvider.addVariable(newVar);
        this.fVariablesViewer.setSelection((ISelection)new StructuredSelection((Object)newVar), true);
        this.fVariablesViewer.refresh();
        this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
        this.update();
        this.fDialog.updateValidateInterpreterLocation();
    }

    private EnvironmentVariable add() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.fDialog.getShell(), InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_addVariable);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return null;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            return new EnvironmentVariable(name.trim(), value.trim());
        }
        return null;
    }

    private void addExisted(IStructuredSelection selection) {
        EnvironmentVariable[] libs = this.addExisted();
        if (libs == null) {
            return;
        }
        EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
        this.fEnvironmentVariablesContentProvider.add(libs, selection);
        this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
        this.update();
        this.fDialog.updateValidateInterpreterLocation();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariablesViewer.getSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        this.fEditButton.setEnabled(selection.size() == 1);
        Object[] libraries = this.fEnvironmentVariablesContentProvider.getElements(null);
        if (!selection.isEmpty() && libraries.length != 0) {
            Object first = libraries[0];
            Object last = libraries[libraries.length - 1];
            for (Object element : selection) {
                Object lib = element;
                if (lib == first) {
                    // empty if block
                }
                if (lib != last) continue;
            }
        }
    }

    public void initializeFrom(IInterpreterInstall interpreter, IInterpreterInstallType type) {
        this.fInterpreterInstall = interpreter;
        this.fInterpreterInstallType = type;
        if (interpreter != null) {
            this.fEnvironmentVariablesContentProvider.setVariables(this.getInterpreterInstall().getEnvironmentVariables());
        }
        this.update();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new EnvironmentVariablesLabelProvider();
    }

    protected void updateDialogStatus(IStatus status) {
        this.fDialog.setSystemLibraryStatus(status);
        this.fDialog.updateStatusLine();
    }

    protected void setButtonLayoutData(Button button) {
        this.fDialog.setButtonLayoutData(button);
    }

    @Deprecated
    protected final void getDialogSettions() {
    }

    protected EnvironmentVariable[] addExisted() {
        Map<String, EnvironmentVariable> envVariables = this.getNativeEnvironment();
        if (envVariables.size() == 0) {
            MessageBox box = new MessageBox(this.fDialog.getShell(), 1);
            box.setMessage(NLS.bind((String)InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_couldNotRetrieveEnvironmentVariablesFrom, (Object)this.fDialog.getEnvironment().getName()));
            box.setText(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_failedToRetrieveEnvironment);
            box.open();
            return null;
        }
        EnvironmentVariable[] environmentVariableArray = this.fEnvironmentVariablesContentProvider.getVariables();
        int n = environmentVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnvironmentVariable var = environmentVariableArray[n2];
            envVariables.remove(var.getName());
            ++n2;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(this.fDialog.getShell(), envVariables, this.createSelectionDialogContentProvider(), this.createSelectionDialogLabelProvider(), LaunchConfigurationsMessages.EnvironmentTab_19);
        dialog.setTitle(LaunchConfigurationsMessages.EnvironmentTab_20);
        int button = dialog.open();
        if (button == 0) {
            Object[] selected = dialog.getResult();
            EnvironmentVariable[] vars = new EnvironmentVariable[selected.length];
            int i = 0;
            while (i < vars.length) {
                vars[i] = (EnvironmentVariable)selected[i];
                ++i;
            }
            return vars;
        }
        return null;
    }

    private ILabelProvider createSelectionDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return DebugPluginImages.getImage((String)"IMG_OBJS_ENVIRONMENT");
            }

            public String getText(Object element) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                return NLS.bind((String)LaunchConfigurationsMessages.EnvironmentTab_7, (Object)var.getName(), (Object)var.getValue());
            }
        };
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Map) {
                    Map env = (Map)inputElement;
                    Object[] elements = env.values().toArray(new EnvironmentVariable[env.size()]);
                    Arrays.sort(elements, new Comparator<EnvironmentVariable>(){

                        @Override
                        public int compare(EnvironmentVariable s1, EnvironmentVariable s2) {
                            return s1.getName().compareTo(s2.getName());
                        }
                    });
                    return elements;
                }
                return new EnvironmentVariable[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private Map<String, EnvironmentVariable> getNativeEnvironment() {
        IEnvironment environment = this.fDialog.getEnvironment();
        IExecutionEnvironment execEnvironment = (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        Map stringVars = execEnvironment.getEnvironmentVariables(true);
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        if (stringVars != null) {
            for (Map.Entry entry : stringVars.entrySet()) {
                vars.put((String)entry.getKey(), new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return vars;
    }
}

