/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.preferences.DebuggingEngineConfigOptionsBlock;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalDebuggingEngineOptionsBlock
extends DebuggingEngineConfigOptionsBlock {
    EnvironmentPathBlock enginePaths;

    public ExternalDebuggingEngineOptionsBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
    }

    protected void addDownloadLink(Composite parent, String text, final String url) {
        Link link = new Link(parent, 0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalDebuggingEngineOptionsBlock.this.openExternalUrl(url);
            }
        });
        link.setText(text);
    }

    protected abstract PreferenceKey getDebuggingEnginePathKey();

    @Override
    protected void createEngineBlock(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)ScriptDebugPreferencesMessages.ExternalEngineGroup, (int)3, (int)1, (int)this.getExternalEngineBlockFillType());
        this.enginePaths = new EnvironmentPathBlock();
        this.enginePaths.createControl((Composite)group, this.getRelevantEnvironments());
        this.enginePaths.setPaths(this.getEnvironmentPaths());
    }

    protected int getExternalEngineBlockFillType() {
        return 1808;
    }

    @Override
    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        this.setEnvironmentPaths(this.enginePaths.getPaths());
        return super.processChanges(container);
    }

    protected Map<IEnvironment, String> getEnvironmentPaths() {
        String pathKeyValue = this.getString(this.getDebuggingEnginePathKey());
        return EnvironmentPathUtils.decodePaths((String)pathKeyValue);
    }

    private void setEnvironmentPaths(Map<IEnvironment, String> env2path) {
        String pathKeyValue = EnvironmentPathUtils.encodePaths(env2path);
        this.setString(this.getDebuggingEnginePathKey(), pathKeyValue);
    }

    protected void openExternalUrl(String url) {
        block4: {
            try {
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                browser.openURL(new URL(url));
            }
            catch (PartInitException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (MalformedURLException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }
}

