/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.validation.AbstractNavigationVisitor;
import org.eclipse.dltk.internal.javascript.validation.FlowEndKind;
import org.eclipse.dltk.internal.javascript.validation.FlowScope;
import org.eclipse.dltk.internal.javascript.validation.FlowStatus;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowValidation
extends AbstractNavigationVisitor<FlowStatus>
implements IBuildParticipant {
    private Reporter reporter;
    private FlowScope scope;

    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        this.reporter = JavaScriptValidations.createReporter(context);
        this.scope = new FlowScope();
        this.visit((ASTNode)script);
    }

    @Override
    public FlowStatus visitReturnStatement(ReturnStatement node) {
        FlowEndKind kind;
        FlowEndKind flowEndKind = kind = node.getValue() != null ? FlowEndKind.RETURNS_VALUE : FlowEndKind.RETURNS;
        if (this.scope.add(kind) && this.scope.size() > 1) {
            this.reporter.setMessage(0x20000004, "return statement is inconsistent with previous usage");
            this.reporter.setRange(node.sourceStart(), node.sourceEnd());
            this.reporter.report();
        }
        FlowStatus status = new FlowStatus();
        if (node.getValue() == null) {
            status.returnValue = true;
        } else {
            status.returnWithoutValue = true;
        }
        return status;
    }

    @Override
    public FlowStatus visitStatementBlock(StatementBlock node) {
        FlowStatus status = new FlowStatus();
        for (Statement statement : node.getStatements()) {
            if (status.isReturned()) {
                this.reporter.setMessage(0x20000003, "uneachable code");
                this.reporter.setRange(statement.sourceStart(), statement.sourceEnd());
                this.reporter.report();
                continue;
            }
            status.add((FlowStatus)this.visit((ASTNode)statement));
        }
        return status;
    }

    @Override
    public FlowStatus visitIfStatement(IfStatement node) {
        FlowStatus status = new FlowStatus();
        if (node.getThenStatement() != null) {
            status.add((FlowStatus)this.visit((ASTNode)node.getThenStatement()));
        }
        if (node.getElseStatement() != null) {
            status.add((FlowStatus)this.visit((ASTNode)node.getElseStatement()));
        } else {
            status.add(new FlowStatus());
        }
        return status;
    }

    @Override
    public FlowStatus visitFunctionStatement(FunctionStatement node) {
        FlowScope savedScope = this.scope;
        this.scope = new FlowScope();
        try {
            FlowStatus result = (FlowStatus)super.visitFunctionStatement(node);
            if (this.scope.contains((Object)FlowEndKind.RETURNS_VALUE) && (this.scope.contains((Object)FlowEndKind.RETURNS) || result.noReturn)) {
                this.reporter.setMessage(0x20000005, node.getName() != null ? NLS.bind((String)"function {0} does not always return a value", (Object)node.getName().getName()) : "anonymous function does not always return a value");
                this.reporter.setRange(node.getBody().getRC(), node.getBody().getRC() + 1);
                this.reporter.report();
            }
            FlowStatus flowStatus = result;
            return flowStatus;
        }
        finally {
            this.scope = savedScope;
        }
    }
}

