/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;

    public MethodPredicate(MethodPattern pattern) {
        super((SearchPattern)pattern, pattern.selector);
        this.declarations = pattern.findDeclarations;
        this.references = pattern.findReferences;
    }

    public MethodPredicate(MethodDeclarationPattern pattern) {
        super((SearchPattern)pattern, pattern.simpleName);
        this.declarations = true;
        this.references = false;
    }

    public MatchLevel match(MatchingNode node) {
        if (node instanceof MethodDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            MethodDeclarationNode mNode = (MethodDeclarationNode)node;
            return this.matchName(((Identifier)mNode.node).getName());
        }
        if (node instanceof MethodReferenceNode) {
            if (!this.references) {
                return null;
            }
            MethodReferenceNode mNode = (MethodReferenceNode)node;
            return this.matchName(((Identifier)mNode.node).getName());
        }
        return null;
    }
}

