/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.structure;

import java.util.ArrayList;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.itcl.internal.core.parser.structure.IncrTclNames;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IClass;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IMethod;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclVisibilityUtils;
import org.eclipse.dltk.tcl.structure.AbstractTclCommandModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;
import org.eclipse.dltk.tcl.structure.TclModelProblem;

public class IncrTclBody
extends AbstractTclCommandModelBuilder {
    public boolean process(TclCommand command, ITclModelBuildContext context) throws TclModelProblem {
        if (command.getArguments().size() != 3) {
            throw new TclModelProblem("Wrong number of arguments");
        }
        TclArgument nameArg = (TclArgument)command.getArguments().get(0);
        if (!IncrTclBody.isSymbol((TclArgument)nameArg)) {
            throw new TclModelProblem("className::function expected", (Node)nameArg);
        }
        String classFunctionName = IncrTclBody.asSymbol((TclArgument)nameArg);
        int pos = classFunctionName.lastIndexOf("::");
        if (pos <= 0) {
            throw new TclModelProblem("className::function expected", (Node)nameArg);
        }
        String className = classFunctionName.substring(0, pos);
        String procName = classFunctionName.substring(pos + 2);
        IClass clazz = null;
        IncrTclNames names = IncrTclNames.get(context);
        if (names != null) {
            clazz = names.resolve(className);
        }
        int procModifiers = 0x400000 | (TclVisibilityUtils.isPrivate((String)procName) ? 16 : 64);
        if (clazz == null) {
            this.report(context, (Node)nameArg, "Class not found", 0);
        } else {
            IMethod method;
            className = clazz.getName();
            if (className.startsWith("::")) {
                className = className.substring(2);
            }
            if ((method = clazz.findMethod(procName)) != null) {
                procModifiers = method.getModifiers();
            } else {
                this.report(context, (Node)nameArg, "Method not found", 0);
            }
        }
        IElementRequestor.TypeInfo ti = new IElementRequestor.TypeInfo();
        ti.declarationStart = command.getStart();
        ti.nameSourceStart = nameArg.getStart();
        ti.nameSourceEnd = nameArg.getEnd() - 1;
        ti.modifiers = 2048;
        if (clazz != null) {
            ti.superclasses = clazz.getSuperClasses();
        }
        ITclTypeHandler resolvedType = ((ITclTypeResolver)context.get(ITclTypeResolver.class)).resolveType(ti, command.getEnd(), className);
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.declarationStart = command.getStart();
        mi.nameSourceStart = nameArg.getStart();
        mi.nameSourceEnd = nameArg.getEnd() - 1;
        mi.modifiers = procModifiers;
        mi.name = procName;
        ArrayList parameters = new ArrayList();
        this.parseRawParameters((TclArgument)command.getArguments().get(1), parameters);
        this.fillParameters(mi, parameters);
        context.getRequestor().enterMethodRemoveSame(mi);
        context.parse((TclArgument)command.getArguments().get(2));
        context.getRequestor().exitMethod(command.getEnd());
        resolvedType.leave(context.getRequestor());
        return false;
    }
}

