/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.FormatterMessages;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class EditorConfigurationBlock
extends AbstractConfigurationBlock {
    public static final int FLAG_TAB_POLICY = 1;
    public static final int FLAG_EDITOR_SMART_NAVIGATION = 2;
    public static final int FLAG_TAB_ALWAYS_INDENT = 4;
    public static final int FLAG_EDITOR_APPEARANCE_COLOR_OPTIONS = 8;
    private final int flags = flags |= 8;
    private final EditorColorItem[] fColorListModel;
    private List colorList;
    private ColorSelector colorEditor;
    private Button colorDefault;

    protected EditorColorItem[] createColorListModel() {
        return new EditorColorItem[]{new EditorColorItem(PreferencesMessages.EditorPreferencePage_matchingBracketsHighlightColor, "editor.matching_brackets_color"), new EditorColorItem(PreferencesMessages.EditorPreferencePage_backgroundForMethodParameters, "content_assist_parameters_background"), new EditorColorItem(PreferencesMessages.EditorPreferencePage_foregroundForMethodParameters, "content_assist_parameters_foreground"), new EditorColorItem(PreferencesMessages.EditorPreferencePage_backgroundForCompletionReplacement, "content_assist_completion_replacement_background"), new EditorColorItem(PreferencesMessages.EditorPreferencePage_foregroundForCompletionReplacement, "content_assist_completion_replacement_foreground"), new EditorColorItem(PreferencesMessages.EditorPreferencePage_sourceHoverBackgroundColor, "sourceHoverBackgroundColor", "sourceHoverBackgroundColor.SystemDefault", 29)};
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        this(mainPreferencePage, store, 3);
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, boolean disableSmart) {
        this(mainPreferencePage, store, 1 | (disableSmart ? 0 : 2));
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, boolean disableSmart, boolean tabAlwaysIndent) {
        this(mainPreferencePage, store, 1 | (disableSmart ? 0 : 2) | (tabAlwaysIndent ? 4 : 0));
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, int flags) {
        super(store, mainPreferencePage);
        this.fColorListModel = (flags & 8) != 0 ? this.createColorListModel() : null;
        this.getPreferenceStore().addKeys(EditorConfigurationBlock.createOverlayStoreKeys(flags, this.fColorListModel));
    }

    private static OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(int flags, EditorColorItem[] colorItems) {
        ArrayList<OverlayPreferenceStore.OverlayKey> keys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        if ((flags & 2) != 0) {
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editorSmartIndent"));
        }
        if ((flags & 1) != 0) {
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "formatter.tabulation.char"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter.tabulation.size"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter.indentation.size"));
        }
        if ((flags & 4) != 0) {
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "tab_always_indent"));
        }
        if ((flags & 8) != 0) {
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor.matching_brackets"));
            if (colorItems != null) {
                EditorColorItem[] editorColorItemArray = colorItems;
                int n = colorItems.length;
                int n2 = 0;
                while (n2 < n) {
                    EditorColorItem item = editorColorItemArray[n2];
                    keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.colorKey));
                    if (item.systemDefaultKey != null) {
                        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.systemDefaultKey));
                    }
                    ++n2;
                }
            }
        }
        return keys.toArray(new OverlayPreferenceStore.OverlayKey[keys.size()]);
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        if ((this.flags & 2) != 0) {
            Composite composite = this.createSubsection(control, null, PreferencesMessages.EditorPreferencePage_title0);
            this.createSettingsGroup(composite);
        }
        if ((this.flags & 5) != 0) {
            this.createTabsGroup(control);
        }
        if ((this.flags & 8) != 0) {
            this.createAppearanceOptionsGroup(control);
        }
        return control;
    }

    private void createTabsGroup(Composite composite) {
        Composite generalGroup = this.createSubsection(composite, null, FormatterMessages.IndentationTabPage_preview_header);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        generalGroup.setLayout((Layout)layout);
        if ((this.flags & 1) != 0) {
            String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
            String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
            this.addComboBox(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "formatter.tabulation.char", tabPolicyLabels, tabPolicyValues);
            this.addLabelledTextField(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "formatter.indentation.size", 2, 1, true);
            this.addLabelledTextField(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "formatter.tabulation.size", 2, 1, true);
        }
        if ((this.flags & 4) != 0) {
            this.addCheckBox(generalGroup, PreferencesMessages.EditorPreferencePage_tabAlwaysIndent, "tab_always_indent", 2);
        }
    }

    private Control createSettingsGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addCheckBox(composite, PreferencesMessages.EditorPreferencePage_smartHomeEnd, "AbstractTextEditor.Navigation.SmartHomeEnd", 0);
        this.addCheckBox(composite, PreferencesMessages.EditorPreferencePage_subWordNavigation, "subWordNavigation", 0);
        this.addCheckBox(composite, PreferencesMessages.EditorPreferencePage_smartIndent, "editorSmartIndent", 0);
        return composite;
    }

    private Control createAppearanceOptionsGroup(Composite composite) {
        Label spacer = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        spacer.setLayoutData((Object)gd);
        this.addCheckBox(composite, PreferencesMessages.EditorPreferencePage_matchingBrackets, "editor.matching_brackets", 0);
        Label l = new Label(composite, 16384);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(composite, 16384);
        l.setText(PreferencesMessages.EditorPreferencePage_title1);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.colorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(12);
        this.colorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(PreferencesMessages.EditorPreferencePage_color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.colorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.colorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = EditorConfigurationBlock.this.colorDefault.getSelection();
                EditorConfigurationBlock.this.colorEditor.getButton().setEnabled(!systemDefault);
                int i = EditorConfigurationBlock.this.colorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = ((EditorConfigurationBlock)EditorConfigurationBlock.this).fColorListModel[i].systemDefaultKey;
                if (key != null) {
                    EditorConfigurationBlock.this.getPreferenceStore().setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.colorDefault = new Button(stylesComposite, 32);
        this.colorDefault.setText(PreferencesMessages.EditorPreferencePage_systemDefault);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.colorDefault.setLayoutData((Object)gd);
        this.colorDefault.setVisible(false);
        this.colorDefault.addSelectionListener(colorDefaultSelectionListener);
        this.colorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditorConfigurationBlock.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = EditorConfigurationBlock.this.colorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = ((EditorConfigurationBlock)EditorConfigurationBlock.this).fColorListModel[i].colorKey;
                PreferenceConverter.setValue((IPreferenceStore)EditorConfigurationBlock.this.getPreferenceStore(), (String)key, (RGB)EditorConfigurationBlock.this.colorEditor.getColorValue());
            }
        });
        return composite;
    }

    private void handleAppearanceColorListSelection() {
        int i = this.colorList.getSelectionIndex();
        if (i == -1) {
            return;
        }
        String key = this.fColorListModel[i].colorKey;
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)key);
        this.colorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fColorListModel[i].systemDefaultKey);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.colorDefault.setSelection(false);
            this.colorDefault.setVisible(false);
            this.colorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.getPreferenceStore().getBoolean(systemDefaultKey);
            this.colorDefault.setSelection(systemDefault);
            this.colorDefault.setVisible(true);
            this.colorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    public void initialize() {
        super.initialize();
        if ((this.flags & 8) != 0) {
            this.initializeDefaultColors();
            int i = 0;
            while (i < this.fColorListModel.length) {
                this.colorList.add(this.fColorListModel[i].name);
                ++i;
            }
            this.colorList.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (EditorConfigurationBlock.this.colorList != null && !EditorConfigurationBlock.this.colorList.isDisposed()) {
                        EditorConfigurationBlock.this.colorList.select(0);
                        EditorConfigurationBlock.this.handleAppearanceColorListSelection();
                    }
                }
            });
        }
    }

    private void initializeDefaultColors() {
        EditorColorItem[] editorColorItemArray = this.fColorListModel;
        int n = this.fColorListModel.length;
        int n2 = 0;
        while (n2 < n) {
            EditorColorItem item = editorColorItemArray[n2];
            if (item.systemDefaultKey != null && this.getPreferenceStore().getBoolean(item.systemDefaultKey)) {
                RGB rgb = this.colorList.getDisplay().getSystemColor(item.systemColor).getRGB();
                PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)item.colorKey, (RGB)rgb);
            }
            ++n2;
        }
    }

    public void performDefaults() {
        super.performDefaults();
        if ((this.flags & 8) != 0) {
            this.initializeDefaultColors();
            this.handleAppearanceColorListSelection();
        }
    }

    public static class EditorColorItem {
        public final String name;
        public final String colorKey;
        public final String systemDefaultKey;
        public final int systemColor;

        public EditorColorItem(String name, String colorKey) {
            this(name, colorKey, null, 0);
        }

        public EditorColorItem(String name, String colorKey, String systemDefaultKey, int systemColor) {
            this.name = name;
            this.colorKey = colorKey;
            this.systemDefaultKey = systemDefaultKey;
            this.systemColor = systemColor;
        }
    }
}

