/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.codeassist.ICompletionNameProvider;
import org.eclipse.dltk.codeassist.complete.CompletionNodeFound;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.extensions.ICompletionExtension;
import org.eclipse.dltk.tcl.internal.core.codeassist.FieldNameProvider;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclCompletionEngine;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclResolver;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordArgumentOrFunctionArgument;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnVariable;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.TclCompletionParser;
import org.eclipse.dltk.xotcl.core.XOTclParseUtil;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclExInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodCallStatement;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclProcCallStatement;
import org.eclipse.dltk.xotcl.internal.core.XOTclKeywords;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclClass;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclClassInstance;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclInstProc;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclProc;

public class XOTclCompletionExtension
implements ICompletionExtension {
    private CompletionRequestor requestor;

    public boolean visit(Expression s, TclCompletionParser parser, int position) {
        ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
        if (s instanceof XOTclMethodCallStatement) {
            XOTclMethodCallStatement pcs = (XOTclMethodCallStatement)s;
            exprs.add(pcs.getInstNameRef());
            exprs.add(pcs.getCallName());
            if (pcs.getArgs() != null) {
                exprs.addAll(pcs.getArgs().getChilds());
            }
            this.processArgumentCompletion((Statement)s, exprs, parser, position);
        }
        return false;
    }

    public boolean visit(Statement s, TclCompletionParser parser, int position) {
        ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
        if (s instanceof XOTclProcCallStatement) {
            XOTclProcCallStatement pcs = (XOTclProcCallStatement)s;
            exprs.add(pcs.getInstNameRef());
            exprs.add(pcs.getCallName());
            if (pcs.getArguments() != null) {
                exprs.addAll(pcs.getArguments().getChilds());
            }
            this.processArgumentCompletion(s, exprs, parser, position);
        }
        return false;
    }

    private void processArgumentCompletion(Statement s, List exprs, TclCompletionParser parser, int position) {
        TclStatement statement = new TclStatement(exprs);
        statement.setStart(s.sourceStart());
        statement.setEnd(s.sourceEnd());
        ASTNode completionNode = null;
        int i = 0;
        while (i < exprs.size()) {
            ASTNode n = (ASTNode)exprs.get(i);
            if (n.sourceStart() <= position && n.sourceEnd() >= position) {
                completionNode = n;
            }
            ++i;
        }
        String token = "";
        if (completionNode != null && completionNode instanceof SimpleReference) {
            token = ((SimpleReference)completionNode).getName();
        }
        String[] keywords = token == null ? parser.checkKeywords("", 1) : parser.checkKeywords(token, 1);
        if (completionNode != null) {
            CompletionOnKeywordArgumentOrFunctionArgument nde = new CompletionOnKeywordArgumentOrFunctionArgument(token, completionNode, statement, keywords);
            parser.setAssistNodeParent(TclParseUtil.getPrevParent((ModuleDeclaration)parser.getModule(), (ASTNode)s));
            throw new CompletionNodeFound((ASTNode)nde, null);
        }
        CompletionOnKeywordArgumentOrFunctionArgument nde = new CompletionOnKeywordArgumentOrFunctionArgument(token, statement, keywords, position);
        parser.setAssistNodeParent(TclParseUtil.getPrevParent((ModuleDeclaration)parser.getModule(), (ASTNode)s));
        throw new CompletionNodeFound((ASTNode)nde, null);
    }

    public void completeOnKeywordOrFunction(CompletionOnKeywordOrFunction key, ASTNode astNodeParent, TclCompletionEngine engine) {
        char[] token;
        HashSet methodNames;
        if (!engine.getRequestor().isIgnored(7)) {
            methodNames = new HashSet();
            token = key.getToken();
            token = engine.removeLastColonFromToken(token);
            this.findLocalXOTclClasses(token, methodNames, astNodeParent, engine);
            this.findXOTclClasses(token, methodNames, engine);
        }
        if (!engine.getRequestor().isIgnored(1)) {
            methodNames = new HashSet();
            token = key.getToken();
            token = engine.removeLastColonFromToken(token);
            this.findLocalXOTclClassInstances(token, methodNames, astNodeParent, engine);
            this.findXOTclClassInstances(token, methodNames, engine);
        }
    }

    private void findLocalXOTclClasses(char[] token, Set methodNames, ASTNode astNodeParent, TclCompletionEngine engine) {
        ASTNode parent = TclParseUtil.getScopeParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)astNodeParent);
        HashSet classes = new HashSet();
        this.findXOTclClassessIn(parent, classes, engine);
        engine.removeSameFrom(methodNames, classes, new String(token));
        engine.findTypes(token, true, engine.toList(classes));
        methodNames.addAll(classes);
    }

    private void findLocalXOTclClassInstances(char[] token, Set methodNames, ASTNode astNodeParent, TclCompletionEngine engine) {
        ASTNode parent = TclParseUtil.getScopeParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)astNodeParent);
        HashSet classes = new HashSet();
        this.findXOTclClassInstancesIn(parent, classes, engine);
        String tok = new String(token);
        engine.removeSameFrom(methodNames, classes, tok);
        engine.findFields(token, true, engine.toList(classes), (ICompletionNameProvider)new FieldNameProvider(tok));
        methodNames.addAll(classes);
    }

    private void findXOTclClassessIn(ASTNode parent, Set classes, final TclCompletionEngine engine) {
        ArrayList result;
        block2: {
            result = new ArrayList();
            final TclResolver resolver = new TclResolver(engine.getSourceModule(), engine.getAssistParser().getModule(), null);
            try {
                engine.getAssistParser().getModule().traverse(new ASTVisitor(){

                    public boolean visit(TypeDeclaration type) {
                        if ((type.getModifiers() & 0x100000) != 0 && type.sourceStart() < engine.getActualCompletionPosition()) {
                            resolver.searchAddElementsTo(engine.getAssistParser().getModule().getStatements(), (ASTNode)type, (IParent)engine.getSourceModule(), result);
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        classes.addAll(result);
    }

    private void findXOTclClassInstancesIn(ASTNode parent, Set classes, final TclCompletionEngine engine) {
        ArrayList result;
        block2: {
            result = new ArrayList();
            final TclResolver resolver = new TclResolver(engine.getSourceModule(), engine.getAssistParser().getModule(), null);
            try {
                parent.traverse(new ASTVisitor(){

                    public boolean visit(Statement st) {
                        if (st instanceof XOTclInstanceVariable || st instanceof XOTclExInstanceVariable) {
                            resolver.searchAddElementsTo(engine.getAssistParser().getModule().getStatements(), (ASTNode)st, (IParent)engine.getSourceModule(), result);
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        classes.addAll(result);
    }

    private void findXOTclClassInstances(char[] token, Set methodNames, TclCompletionEngine engine) {
        String to_ = new String(token);
        String to = to_;
        if (to.startsWith("::")) {
            to = to.substring(2);
        }
        if (to.length() == 0) {
            return;
        }
        HashSet elements = new HashSet();
        elements.addAll(methodNames);
        this.findClassesInstanceFromMixin(elements, String.valueOf(to) + "*", engine);
        engine.removeSameFrom(methodNames, elements, to);
        engine.findFields(token, true, engine.toList(elements), (ICompletionNameProvider)new FieldNameProvider(to_));
        methodNames.addAll(elements);
    }

    private void completionForInstanceVariableMethods(FieldDeclaration var, char[] token, Set methodNames, TclCompletionEngine engine) {
        FieldDeclaration ivar;
        String keyPrefix = null;
        if (var instanceof XOTclInstanceVariable) {
            ivar = (XOTclInstanceVariable)var;
            TypeDeclaration declaringType = ivar.getDeclaringType();
            keyPrefix = TclParseUtil.getElementFQN((ASTNode)declaringType, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule());
            if (keyPrefix.startsWith(IMixinRequestor.MIXIN_NAME_SEPARATOR)) {
                keyPrefix = keyPrefix.substring(1);
            }
        } else if (var instanceof XOTclExInstanceVariable) {
            ivar = (XOTclExInstanceVariable)var;
            String className = ivar.getDeclaringClassParameter().getClassName();
            if (className.startsWith("::")) {
                className = className.substring(2);
            }
            keyPrefix = className.replaceAll("::", IMixinRequestor.MIXIN_NAME_SEPARATOR);
        }
        HashSet methods = new HashSet();
        this.findClassesFromMixin(methods, keyPrefix, engine);
        HashSet<IModelElement> result = new HashSet<IModelElement>();
        while (methods.size() > 0) {
            IModelElement e = (IModelElement)methods.iterator().next();
            methods.remove(e);
            if (e instanceof IType) {
                IType type;
                block14: {
                    type = (IType)e;
                    try {
                        IMethod[] ms = type.getMethods();
                        result.addAll((Collection)Arrays.asList(ms));
                    }
                    catch (ModelException e1) {
                        if (!DLTKCore.DEBUG) break block14;
                        e1.printStackTrace();
                    }
                }
                try {
                    String[] superClasses = type.getSuperClasses();
                    if (superClasses == null) continue;
                    int i = 0;
                    while (i < superClasses.length) {
                        String key = superClasses[i];
                        if (key.startsWith("::")) {
                            key = key.substring(2);
                        }
                        if (key.length() > 0) {
                            this.findClassesFromMixin(methods, key, engine);
                        }
                        ++i;
                    }
                }
                catch (ModelException e1) {
                    if (!DLTKCore.DEBUG) continue;
                    e1.printStackTrace();
                }
                continue;
            }
            if (!(e instanceof IMethod)) continue;
            result.add(e);
        }
        this.findMethodsShortName(token, result, methodNames, engine);
        this.addKeywords(token, XOTclKeywords.XOTclCommandClassArgs, methodNames, engine);
        this.addKeywords(token, XOTclKeywords.XOTclCommandObjectArgs, methodNames, engine);
    }

    private void completeClassMethods(String name, char[] cs, Set methodNames, TclCompletionEngine engine) {
        HashSet completions = new HashSet();
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        this.findClassesFromMixin(completions, name, engine);
        if (completions.size() >= 1) {
            HashSet methods = new HashSet();
            methods.addAll(methodNames);
            this.findProcsFromMixin(methods, String.valueOf(name) + "::*", engine);
            methods.removeAll(methodNames);
            this.findMethodsShortName(cs, methods, methodNames, engine);
            this.addKeywords(cs, XOTclKeywords.XOTclCommandClassArgs, methodNames, engine);
            this.addKeywords(cs, XOTclKeywords.XOTclCommandObjectArgs, methodNames, engine);
        }
    }

    private void addKeywords(char[] cs, String[] keywords, Set methodNames, TclCompletionEngine engine) {
        ArrayList<String> k = new ArrayList<String>();
        String token = new String(cs);
        int i = 0;
        while (i < keywords.length) {
            String kkw = keywords[i];
            if (kkw.startsWith(token) && !methodNames.contains(kkw)) {
                k.add(kkw);
                methodNames.add(kkw);
            }
            ++i;
        }
        String[] kw = k.toArray(new String[k.size()]);
        engine.findKeywords(cs, kw, true);
    }

    private void findMethodsShortName(char[] cs, Set methods, Set allMethods, TclCompletionEngine engine) {
        List methodsList = engine.toList(methods);
        ArrayList<String> methodNames = new ArrayList<String>();
        ArrayList<IMethod> remove = new ArrayList<IMethod>();
        for (IMethod iMethod : methodsList) {
            String methodName = iMethod.getElementName();
            if (!methodNames.contains(methodName)) {
                methodNames.add(methodName);
                allMethods.add(methodName);
                continue;
            }
            remove.add(iMethod);
        }
        for (Object e : remove) {
            methodsList.remove(e);
        }
        engine.findMethods(cs, true, methodsList, methodNames);
    }

    protected void findProcsFromMixin(Set methods, String tok, TclCompletionEngine engine) {
        engine.findMixinTclElement(methods, tok, XOTclProc.class);
    }

    protected void findInstProcsFromMixin(Set methods, String tok, TclCompletionEngine engine) {
        engine.findMixinTclElement(methods, tok, XOTclInstProc.class);
    }

    private void findXOTclClasses(char[] token, Set methodNames, TclCompletionEngine engine) {
        String to_ = new String(token);
        String to = to_;
        if (to.startsWith("::")) {
            to = to.substring(2);
        }
        if (to.length() == 0) {
            return;
        }
        HashSet methods = new HashSet();
        methods.addAll(methodNames);
        this.findClassesFromMixin(methods, String.valueOf(to) + "*", engine);
        methods.removeAll(methodNames);
        engine.removeSameFrom(methodNames, methods, to_);
        engine.findTypes(token, true, engine.toList(methods));
    }

    protected void findClassesFromMixin(Set completions, String tok, TclCompletionEngine engine) {
        engine.findMixinTclElement(completions, tok, XOTclClass.class);
    }

    protected void findClassesInstanceFromMixin(Set completions, String tok, TclCompletionEngine engine) {
        engine.findMixinTclElement(completions, tok, XOTclClassInstance.class);
    }

    private FieldDeclaration searchFieldFromMixin(String name, TclCompletionEngine engine) {
        return null;
    }

    public void completeOnKeywordArgumentsOne(String name, char[] token, CompletionOnKeywordArgumentOrFunctionArgument compl, Set methodNames, TclStatement st, TclCompletionEngine engine) {
        this.completeClassMethods(name, token, methodNames, engine);
        FieldDeclaration var = XOTclParseUtil.findXOTclInstanceVariableDeclarationFrom(engine.getAssistParser().getModule(), TclParseUtil.getScopeParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)st), name);
        if (var == null) {
            var = this.searchFieldFromMixin(name, engine);
        }
        if (var != null) {
            this.completionForInstanceVariableMethods(var, token, methodNames, engine);
        }
    }

    public void setRequestor(CompletionRequestor requestor) {
        this.requestor = requestor;
    }

    public void completeOnVariables(CompletionOnVariable astNode, TclCompletionEngine engine) {
    }

    public boolean modelFilter(Set completions, IModelElement modelElement) {
        return true;
    }
}

