/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Keyword;

public class NewExpression
extends Expression {
    private Keyword newKeyword;
    private Expression objectClass;

    public NewExpression(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.newKeyword != null) {
                this.newKeyword.traverse(visitor);
            }
            if (this.objectClass != null) {
                this.objectClass.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Expression objectClass) {
        this.objectClass = objectClass;
    }

    public Keyword getNewKeyword() {
        return this.newKeyword;
    }

    public void setNewKeyword(Keyword keyword) {
        this.newKeyword = keyword;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("new");
        buffer.append(" ");
        buffer.append(this.objectClass.toSourceString(indentationString));
        return buffer.toString();
    }
}

