/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.Arrays;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.INamespace;

public class SourceNamespace
implements INamespace {
    private final String[] segments;

    public SourceNamespace(String[] namespace) {
        if (namespace == null || namespace.length == 0) {
            this.segments = CharOperation.NO_STRINGS;
        } else {
            this.segments = new String[namespace.length];
            System.arraycopy(namespace, 0, this.segments, 0, namespace.length);
        }
    }

    public String[] getStrings() {
        String[] result = new String[this.segments.length];
        System.arraycopy(this.segments, 0, result, 0, this.segments.length);
        return result;
    }

    public String getQualifiedName() {
        return this.getQualifiedName("$");
    }

    public String getQualifiedName(String separator) {
        return new String(CharOperation.concatWith(this.segments, separator));
    }

    public boolean isRoot() {
        return this.segments.length == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceNamespace) {
            SourceNamespace other = (SourceNamespace)obj;
            return Arrays.equals(this.segments, other.segments);
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.segments);
    }
}

