/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.dltk.validators.core.IValidatorProblem;
import org.eclipse.dltk.validators.core.IValidatorReporter;

public class ValidatorReporter
implements IValidatorReporter {
    private Map<ISourceModule, ISourceLineTracker> lineTrackers = new HashMap<ISourceModule, ISourceLineTracker>();
    private String markerId;
    private boolean underline;

    public ValidatorReporter(String markerId, boolean underline) {
        this.markerId = markerId;
        this.underline = underline;
    }

    public ValidatorReporter(String markerId) {
        this(markerId, true);
    }

    public IMarker report(ISourceModule module, IValidatorProblem problem) throws CoreException {
        IMarker marker = this.report(module.getResource(), problem);
        if (marker != null && this.underline) {
            ISourceLineTracker lineTracker = this.getLineTracker(module);
            int lineNo = problem.getLineNumber();
            ISourceRange range = lineTracker.getLineInformation(lineNo - 1);
            this.calcStartEndRange(module, range, marker);
        }
        return marker;
    }

    public IMarker report(IResource resource, IValidatorProblem problem) throws CoreException {
        if (problem == null) {
            return null;
        }
        return this.createMarker(resource, problem);
    }

    protected ISourceLineTracker getLineTracker(ISourceModule module) {
        ISourceLineTracker lineTracker = this.lineTrackers.get(module);
        if (lineTracker == null) {
            char[] source;
            try {
                source = module.getSourceAsCharArray();
                if (source == null) {
                    source = CharOperation.NO_CHAR;
                }
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                source = CharOperation.NO_CHAR;
            }
            lineTracker = TextUtils.createLineTracker((char[])source);
            this.lineTrackers.put(module, lineTracker);
        }
        return lineTracker;
    }

    private void calcStartEndRange(ISourceModule module, ISourceRange range, IMarker marker) throws ModelException, CoreException {
        int lineOffset;
        String source = module.getSource();
        int endOfLine = source.indexOf("\n", lineOffset = range.getOffset());
        String markerLine = endOfLine != -1 ? source.substring(lineOffset, endOfLine) : source.substring(lineOffset);
        char[] bytes = markerLine.toCharArray();
        int start = 0;
        while (start < bytes.length) {
            if (bytes[start] != '\t' && bytes[start] != ' ') break;
            ++start;
        }
        int end = (start += lineOffset) + markerLine.trim().length();
        marker.setAttribute("charStart", start);
        marker.setAttribute("charEnd", end);
    }

    private IMarker createMarker(IResource resource, IValidatorProblem problem) throws CoreException {
        IMarker marker = resource.createMarker(this.markerId);
        marker.setAttribute("message", (Object)problem.getMessage());
        marker.setAttribute("lineNumber", problem.getLineNumber());
        marker.setAttribute("severity", this.getSeverity(problem));
        Map<String, Object> attributes = problem.getAttributes();
        for (String key : attributes.keySet()) {
            marker.setAttribute(key, attributes.get(key));
        }
        return marker;
    }

    private int getSeverity(IValidatorProblem problem) {
        int severity = 0;
        if (problem.isWarning()) {
            severity = 1;
        } else if (problem.isError()) {
            severity = 2;
        }
        return severity;
    }
}

