/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.net.URL;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.ui.typeinfo.ElementLabelProviderRegistry;
import org.eclipse.dltk.javascript.ui.typeinfo.IElementLabelProvider;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;

public class JavaScriptCompletionProposalLabelProvider
extends CompletionProposalLabelProvider {
    public String createTypeProposalLabel(CompletionProposal typeProposal) {
        String label;
        if (typeProposal.getExtraInfo() instanceof Element && (label = JavaScriptCompletionProposalLabelProvider.getElementLabel((Element)typeProposal.getExtraInfo())) != null) {
            return label;
        }
        return super.createTypeProposalLabel(typeProposal);
    }

    private static String getElementLabel(Element element) {
        return ElementLabelProviderRegistry.getLabel(element, IElementLabelProvider.Mode.PROPOSAL);
    }

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        String returnType = null;
        String source = null;
        Object info = methodProposal.getExtraInfo();
        if (info instanceof SelfCompletingReference) {
            SelfCompletingReference cm = (SelfCompletingReference)info;
            returnType = cm.getReturnType();
        } else if (info instanceof Method) {
            Method method = (Method)info;
            String label = JavaScriptCompletionProposalLabelProvider.getElementLabel((Element)method);
            if (label != null) {
                return label;
            }
            if (method.getType() != null) {
                returnType = method.getType().getName();
            }
            if (method.getDeclaringType() != null) {
                source = method.getDeclaringType().getName();
            }
        } else if (info instanceof IValueReference) {
            ReferenceLocation loc;
            IValueReference reference = (IValueReference)info;
            IValueReference result = reference.getChild("()");
            if (result != null && result.getDeclaredType() != null) {
                returnType = result.getDeclaredType().getName();
            }
            if ((loc = reference.getLocation()) != ReferenceLocation.UNKNOWN && loc.getSourceModule() != null) {
                source = loc.getSourceModule().getPath().toString();
            }
        }
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        if (returnType != null) {
            nameBuffer.append(": ");
            nameBuffer.append(returnType);
        }
        if (source != null) {
            nameBuffer.append(" - ");
            nameBuffer.append(source);
        }
        return nameBuffer.toString();
    }

    protected String createFieldProposalLabel(CompletionProposal proposal) {
        if (proposal.getExtraInfo() instanceof Property) {
            Property property = (Property)proposal.getExtraInfo();
            String label = JavaScriptCompletionProposalLabelProvider.getElementLabel((Element)property);
            if (label != null) {
                return label;
            }
            if (TypeUtil.isValueTypeVisible((JSType)property.getType())) {
                StringBuilder sb = new StringBuilder();
                sb.append(proposal.getName());
                sb.append(": ");
                sb.append(property.getType().getName());
                if (TypeUtil.isDeclaringTypeVisible((Member)property)) {
                    sb.append(" - ");
                    sb.append(property.getDeclaringType().getName());
                }
                return sb.toString();
            }
        }
        return proposal.getName();
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createImageDescriptor(proposal);
    }

    private ImageDescriptor extraImageFromProposal(CompletionProposal proposal) {
        if (proposal.getExtraInfo() instanceof SelfCompletingReference) {
            SelfCompletingReference cm = (SelfCompletingReference)proposal.getExtraInfo();
            URL imageUrl = cm.getImageURL();
            if (imageUrl != null) {
                return this.decorateImageDescriptor(ImageDescriptor.createFromURL((URL)imageUrl), proposal);
            }
        } else if (proposal.getExtraInfo() instanceof Element) {
            Element element = (Element)proposal.getExtraInfo();
            ImageDescriptor descriptor = ElementLabelProviderRegistry.getImageDescriptor(element);
            if (descriptor != null) {
                return this.decorateImageDescriptor(descriptor, proposal);
            }
            if (element instanceof Member) {
                int flags = ((Member)element).getVisibility().getFlags();
                if (element instanceof Property) {
                    return this.decorateImageDescriptor(ScriptElementImageProvider.getFieldImageDescriptor((int)flags), proposal);
                }
                if (element instanceof Method) {
                    return this.decorateImageDescriptor(ScriptElementImageProvider.getMethodImageDescriptor((int)flags), proposal);
                }
            }
        }
        return null;
    }

    protected ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createFieldImageDescriptor(proposal);
    }

    protected ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createLocalImageDescriptor(proposal);
    }

    public ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createMethodImageDescriptor(proposal);
    }

    protected ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createPackageImageDescriptor(proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createTypeImageDescriptor(proposal);
    }

    protected ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        if (this.isDeprecated(proposal)) {
            return new DecorationOverlayIcon(descriptor.createImage(), DLTKPluginImages.DESC_OVR_DEPRECATED, 4);
        }
        if (this.isStatic(proposal)) {
            return new DecorationOverlayIcon(descriptor.createImage(), DLTKPluginImages.DESC_OVR_STATIC, 1);
        }
        return super.decorateImageDescriptor(descriptor, proposal);
    }

    private boolean isStatic(CompletionProposal proposal) {
        if (proposal.getExtraInfo() instanceof Member) {
            return ((Member)proposal.getExtraInfo()).isStatic();
        }
        return false;
    }

    private boolean isDeprecated(CompletionProposal proposal) {
        if (proposal.getExtraInfo() instanceof Element) {
            return ((Element)proposal.getExtraInfo()).isDeprecated();
        }
        if (proposal.getExtraInfo() instanceof IValueReference) {
            IValueReference reference = (IValueReference)proposal.getExtraInfo();
            IModelBuilder.IMethod method = (IModelBuilder.IMethod)reference.getAttribute("PARAMETERS");
            if (method != null) {
                return method.isDeprecated();
            }
            IModelBuilder.IVariable variable = (IModelBuilder.IVariable)reference.getAttribute("VARIABLE");
            return variable != null && variable.isDeprecated();
        }
        return false;
    }
}

