/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.StrUtils;

public abstract class AbstractScriptBreakpoint
extends Breakpoint
implements IScriptBreakpoint {
    public static final String ENGINE_IDENTIFIER = "org.eclipse.dltk.debug.id";
    public static final String HIT_COUNT = "org.eclipse.dltk.debug.hit_count";
    public static final String EXPRESSION = "org.eclipse.dltk.debug.expression";
    public static final String EXPRESSION_STATE = "org.eclipse.dltk.debug.expression.state";
    public static final String HIT_VALUE = "org.eclipse.dltk.debug.hit_value";
    public static final String HIT_CONDITION = "org.eclipse.dltk.debug.hit_condition";
    private String debugModelId;
    private final Map sessions = new IdentityHashMap(1);

    public static URI makeUri(IPath location) {
        try {
            String path = EnvironmentPathUtils.getLocalPath((IPath)location).toString();
            if (path.length() != 0 && path.charAt(0) != '/') {
                path = String.valueOf('/') + path;
            }
            return new URI("file", "", path, null);
        }
        catch (URISyntaxException e) {
            DLTKDebugPlugin.log(e);
            return null;
        }
    }

    protected void addScriptBreakpointAttributes(Map attributes, String debugModelId, boolean enabled) {
        this.debugModelId = debugModelId;
        attributes.put("org.eclipse.debug.core.id", debugModelId);
        attributes.put("org.eclipse.debug.core.enabled", enabled);
    }

    public String getModelIdentifier() {
        if (this.debugModelId == null) {
            try {
                this.debugModelId = this.ensureMarker().getAttribute("org.eclipse.debug.core.id", null);
            }
            catch (DebugException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return this.debugModelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(IDbgpSession session) {
        PerSessionInfo info;
        Map map = this.sessions;
        synchronized (map) {
            info = (PerSessionInfo)this.sessions.get(session);
        }
        return info != null ? info.identifier : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setId(IDbgpSession session, String identifier) {
        Map map = this.sessions;
        synchronized (map) {
            PerSessionInfo info = (PerSessionInfo)this.sessions.get(session);
            if (info == null) {
                info = new PerSessionInfo();
                this.sessions.put(session, info);
            }
            info.identifier = identifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeId(IDbgpSession session) {
        PerSessionInfo info;
        Map map = this.sessions;
        synchronized (map) {
            info = (PerSessionInfo)this.sessions.remove(session);
        }
        return info != null ? info.identifier : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessionInfo() {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIdentifiers() {
        PerSessionInfo[] infos;
        Map map = this.sessions;
        synchronized (map) {
            infos = this.sessions.values().toArray(new PerSessionInfo[this.sessions.size()]);
        }
        int count = 0;
        int i = 0;
        while (i < infos.length) {
            if (infos[i] != null && infos[i].identifier != null) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            String[] result = new String[count];
            int index = 0;
            int i2 = 0;
            while (i2 < infos.length) {
                if (infos[i2] != null && infos[i2].identifier != null) {
                    result[index++] = infos[i2].identifier;
                }
                ++i2;
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHitCount(IDbgpSession session, int value) throws CoreException {
        Map map = this.sessions;
        synchronized (map) {
            PerSessionInfo info = (PerSessionInfo)this.sessions.get(session);
            if (info == null) {
                info = new PerSessionInfo();
                this.sessions.put(session, info);
            }
            info.hitCount = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHitCount(IDbgpSession session) throws CoreException {
        PerSessionInfo info;
        Map map = this.sessions;
        synchronized (map) {
            info = (PerSessionInfo)this.sessions.get(session);
        }
        return info != null ? info.hitCount : -1;
    }

    public String getIdentifier() throws CoreException {
        return null;
    }

    public void setIdentifier(String id) throws CoreException {
    }

    public String getMessage() throws CoreException {
        return this.ensureMarker().getAttribute("message", null);
    }

    public void setMessage(String message) throws CoreException {
        this.setAttribute("message", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHitCount() throws CoreException {
        Map map = this.sessions;
        synchronized (map) {
            block5: {
                if (!this.sessions.isEmpty()) break block5;
                return -1;
            }
            int result = 0;
            for (PerSessionInfo info : this.sessions.values()) {
                if (info.hitCount <= 0) continue;
                result += info.hitCount;
            }
            return result > 0 ? result : -1;
        }
    }

    public void setHitCount(int value) throws CoreException {
    }

    public int getHitValue() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_VALUE, -1);
    }

    public void setHitValue(int hitValue) throws CoreException {
        if (this.getHitValue() != hitValue) {
            this.setAttribute(HIT_VALUE, hitValue);
        }
    }

    public int getHitCondition() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_CONDITION, -1);
    }

    public void setHitCondition(int condition) throws CoreException {
        if (this.getHitCondition() != condition) {
            this.setAttribute(HIT_CONDITION, condition);
        }
    }

    public String getResourceName() throws CoreException {
        return this.ensureMarker().getResource().getName();
    }

    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute(EXPRESSION, null);
    }

    public void setExpression(String expression) throws CoreException {
        if (!StrUtils.equals(this.getExpression(), expression)) {
            this.setAttribute(EXPRESSION, expression);
        }
    }

    public boolean getExpressionState() throws CoreException {
        return this.ensureMarker().getAttribute(EXPRESSION_STATE, false);
    }

    public void setExpressionState(boolean state) throws CoreException {
        if (this.getExpressionState() != state) {
            this.setAttribute(EXPRESSION_STATE, state);
        }
    }

    public void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    private static class PerSessionInfo {
        String identifier;
        int hitCount = -1;

        private PerSessionInfo() {
        }
    }
}

