/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.TypeMemberQuery;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementValue
implements IValue {
    public static ElementValue findMember(JSType type, String name) {
        return ElementValue.findMember(type, name, MemberPredicate.ALWAYS_TRUE);
    }

    public static ElementValue findMember(JSType type, String name, MemberPredicate predicate) {
        Type t = TypeUtil.extractType(type);
        if (t != null) {
            List<Member> selection = ElementValue.findMembers(t, name, predicate);
            if (!selection.isEmpty()) {
                return new MemberValue(selection.toArray(new Member[selection.size()]));
            }
        } else if (type instanceof UnionType) {
            EList<JSType> targets = ((UnionType)type).getTargets();
            for (JSType unionTarget : targets) {
                ElementValue member = ElementValue.findMember(unionTarget, name);
                if (member == null) continue;
                return member;
            }
        }
        return null;
    }

    public static List<Member> findMembers(Type type, String name, MemberPredicate predicate) {
        ArrayList<Member> selection = new ArrayList<Member>(4);
        for (Member member : new TypeMemberQuery(type, predicate)) {
            if (!name.equals(member.getName())) continue;
            selection.add(member);
        }
        return selection;
    }

    public static ElementValue createFor(Element element, ITypeInferenceContext context) {
        if (element instanceof Method) {
            return new MethodValue((Method)element);
        }
        if (element instanceof Property) {
            return new PropertyValue((Property)element, context);
        }
        assert (element instanceof Type);
        return new TypeValue(JSTypeSet.singleton(TypeUtil.ref((Type)element)));
    }

    public static ElementValue createClass(Type type) {
        return new ClassValue(JSTypeSet.singleton(TypeUtil.classType(type)));
    }

    protected abstract Object getElements();

    public IValue resolveValue(ITypeInferenceContext context) {
        return this;
    }

    @Override
    public final void clear() {
    }

    @Override
    public final void addValue(IValue src) {
    }

    @Override
    public final void addReference(IValue src) {
    }

    @Override
    public final Object getAttribute(String key) {
        return this.getAttribute(key, false);
    }

    @Override
    public Object getAttribute(String key, boolean includeReferences) {
        Object elements;
        if ("ELEMENT".equals(key)) {
            return this.getElements();
        }
        if ("HIDE_ALLOWED".equals(key) && (elements = this.getElements()) instanceof Element) {
            return ((Element)elements).isHideAllowed() ? Boolean.TRUE : null;
        }
        return null;
    }

    @Override
    public final void setAttribute(String key, Object value) {
    }

    @Override
    public final Set<String> getDirectChildren() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        return Collections.emptySet();
    }

    @Override
    public void deleteChild(String name) {
    }

    @Override
    public final boolean hasChild(String name) {
        return false;
    }

    @Override
    public final IValue createChild(String name) {
        return this.getChild(name, true);
    }

    @Override
    public void putChild(String name, IValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceKind getKind() {
        return ReferenceKind.UNKNOWN;
    }

    @Override
    public final ReferenceLocation getLocation() {
        return ReferenceLocation.UNKNOWN;
    }

    @Override
    public JSTypeSet getTypes() {
        return JSTypeSet.emptySet();
    }

    @Override
    public final void setDeclaredType(JSType declaredType) {
    }

    @Override
    public final void setKind(ReferenceKind kind) {
    }

    @Override
    public final void setLocation(ReferenceLocation location) {
    }

    private static class ClassValue
    extends ElementValue
    implements IValue {
        private final JSTypeSet types;

        public ClassValue(JSTypeSet types) {
            this.types = types;
        }

        protected Type[] getElements() {
            return this.types.toArray();
        }

        public IValue getChild(String name, boolean resolve) {
            if (name.equals("()")) {
                JSType type;
                if (this.types.size() == 1 && (type = this.types.getFirst()) instanceof ClassType) {
                    return new TypeValue(JSTypeSet.singleton(TypeUtil.ref(((ClassType)type).getTarget())));
                }
                JSTypeSet returnTypes = JSTypeSet.create();
                for (JSType type2 : this.types) {
                    if (type2 instanceof ClassType) {
                        returnTypes.add(TypeUtil.ref(((ClassType)type2).getTarget()));
                        continue;
                    }
                    returnTypes.add(type2);
                }
                return new TypeValue(returnTypes);
            }
            for (JSType type : this.types) {
                ElementValue child = ClassValue.findMember(type, name, MemberPredicate.ALWAYS_TRUE);
                if (child == null) continue;
                return child;
            }
            return null;
        }

        public JSType getDeclaredType() {
            return this.types.getFirst();
        }

        public JSTypeSet getDeclaredTypes() {
            return this.types;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.TYPE;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + this.types;
        }
    }

    private static class MemberValue
    extends ElementValue
    implements IValue {
        private TypeValue functionOperator;
        private final Member[] members;

        public MemberValue(Member[] members) {
            this.members = members;
        }

        protected Member[] getElements() {
            return this.members;
        }

        public IValue resolveValue(ITypeInferenceContext context) {
            if (this.members.length == 1) {
                IValue value = context.valueOf(this.members[0]);
                value.setDeclaredType(this.getDeclaredType());
                value.setAttribute("ELEMENT", this.getAttribute("ELEMENT"));
                return value;
            }
            return this;
        }

        public ReferenceKind getKind() {
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                if (member instanceof Method) {
                    return ReferenceKind.METHOD;
                }
                ++n2;
            }
            return ReferenceKind.PROPERTY;
        }

        public IValue getChild(String name, boolean resolve) {
            ElementValue child;
            JSType type;
            if ("()".equals(name)) {
                JSTypeSet types = null;
                Member[] memberArray = this.members;
                int n = this.members.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method;
                    Member member = memberArray[n2];
                    if (member instanceof Method && (method = (Method)member).getType() != null) {
                        if (types == null) {
                            types = JSTypeSet.create();
                        }
                        types.add(method.getType());
                    }
                    ++n2;
                }
                if (types != null) {
                    if (this.functionOperator == null) {
                        this.functionOperator = new TypeValue(types);
                    }
                    return this.functionOperator;
                }
            }
            if ((type = this.getDeclaredType()) != null && (child = ElementValue.findMember(type, name)) != null) {
                return child;
            }
            return null;
        }

        public JSType getDeclaredType() {
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                if (member instanceof Property) {
                    Property property = (Property)member;
                    if (property.getType() != null) {
                        return property.getType();
                    }
                } else if (member instanceof Method) {
                    return TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("Function"));
                }
                ++n2;
            }
            return null;
        }

        public JSTypeSet getDeclaredTypes() {
            JSTypeSet types = null;
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                if (member instanceof Property) {
                    Property property = (Property)member;
                    if (property.getType() != null) {
                        if (types == null) {
                            types = JSTypeSet.create();
                        }
                        types.add(property.getType());
                    }
                } else if (member instanceof Method) {
                    if (types == null) {
                        types = JSTypeSet.create();
                    }
                    types.add(TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("Function")));
                }
                ++n2;
            }
            if (types != null) {
                return types;
            }
            return JSTypeSet.emptySet();
        }
    }

    private static class MethodValue
    extends ElementValue
    implements IValue {
        private TypeValue functionOperator;
        private final Method method;

        public MethodValue(Method method) {
            this.method = method;
        }

        protected Method getElements() {
            return this.method;
        }

        public IValue resolveValue(ITypeInferenceContext context) {
            return context.valueOf(this.method);
        }

        public ReferenceKind getKind() {
            return ReferenceKind.METHOD;
        }

        public IValue getChild(String name, boolean resolve) {
            if ("()".equals(name) && this.method.getType() != null) {
                if (this.functionOperator == null) {
                    this.functionOperator = new TypeValue(JSTypeSet.singleton(this.method.getType()));
                }
                return this.functionOperator;
            }
            return null;
        }

        public JSType getDeclaredType() {
            return null;
        }

        public JSTypeSet getDeclaredTypes() {
            return JSTypeSet.emptySet();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.method + '>';
        }
    }

    private static class PropertyValue
    extends ElementValue
    implements IValue {
        protected final ITypeInferenceContext context;
        private final Property property;
        private final Map<String, IValue> children = new HashMap<String, IValue>();

        public PropertyValue(Property property, ITypeInferenceContext context) {
            this.property = property;
            this.context = context;
        }

        protected Property getElements() {
            return this.property;
        }

        public IValue resolveValue(ITypeInferenceContext context) {
            return context.valueOf(this.property);
        }

        public ReferenceKind getKind() {
            return ReferenceKind.PROPERTY;
        }

        public IValue getChild(String name, boolean resolve) {
            IValue child = this.children.get(name);
            if (child == null) {
                ElementValue eValue;
                if (name.equals("[]") && this.property.getType() != null) {
                    Type arrayType = null;
                    if (this.property.getType() instanceof ArrayType) {
                        arrayType = TypeUtil.extractType(((ArrayType)this.property.getType()).getItemType());
                    }
                    if (this.property.getType() instanceof MapType) {
                        arrayType = TypeUtil.extractType(((MapType)this.property.getType()).getValueType());
                    }
                    if (arrayType != null) {
                        ElementValue arrayOpChild = PropertyValue.createFor(arrayType, this.context);
                        this.children.put(name, arrayOpChild);
                        return arrayOpChild;
                    }
                }
                if ((eValue = ElementValue.findMember(this.property.getType(), name)) != null) {
                    child = eValue.resolveValue(this.context);
                    this.children.put(name, child);
                }
            }
            return child;
        }

        public JSType getDeclaredType() {
            return this.property.getType();
        }

        public JSTypeSet getDeclaredTypes() {
            if (this.property.getType() != null) {
                return JSTypeSet.singleton(this.property.getType());
            }
            return JSTypeSet.emptySet();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.property + '>';
        }
    }

    private static class TypeValue
    extends ElementValue
    implements IValue {
        private Value arrayLookup;
        private final JSTypeSet types;

        public TypeValue(JSTypeSet types) {
            this.types = types;
        }

        protected Type[] getElements() {
            return this.types.toArray();
        }

        public IValue resolveValue(ITypeInferenceContext context) {
            return this;
        }

        public IValue getChild(String name, boolean resolve) {
            if (name.equals("[]")) {
                if (this.arrayLookup == null) {
                    this.arrayLookup = new Value();
                }
                return this.arrayLookup;
            }
            for (JSType type : this.types) {
                ElementValue child = TypeValue.findMember(type, name);
                if (child == null) continue;
                return child;
            }
            return null;
        }

        public JSType getDeclaredType() {
            return this.types.getFirst();
        }

        public JSTypeSet getDeclaredTypes() {
            return this.types;
        }

        public final JSTypeSet getTypes() {
            return this.types;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + this.types;
        }
    }
}

