/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultClause;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.Documentable;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.ErrorExpression;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.LoopStatement;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.MultiLineComment;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.SingleLineComment;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlExpressionFragment;
import org.eclipse.dltk.javascript.ast.XmlFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.internal.parser.NodeTransformerManager;
import org.eclipse.dltk.javascript.parser.JSLexer;
import org.eclipse.dltk.javascript.parser.JSProblemIdentifier;
import org.eclipse.dltk.javascript.parser.JSVisitor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserProblems;
import org.eclipse.dltk.javascript.parser.NodeTransformer;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.parser.SymbolKind;
import org.eclipse.dltk.javascript.parser.SymbolTable;
import org.eclipse.dltk.utils.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTransformer
extends JSVisitor<ASTNode> {
    private final NodeTransformer[] transformers;
    private final List<Token> tokens;
    private final int[] tokenOffsets;
    private Stack<ASTNode> parents = new Stack();
    private final boolean ignoreUnknown;
    private final Map<Integer, Comment> documentationMap = new HashMap<Integer, Comment>();
    private Reporter reporter;
    private SymbolTable scope = new SymbolTable();
    private static final int MAX_RECURSION_DEPTH = 512;

    private final void checkRecursionDepth() {
        if (this.parents.size() > 512) {
            throw new IllegalArgumentException("Too nested AST");
        }
    }

    public JSTransformer(List<Token> tokens) {
        this(NodeTransformerManager.NO_TRANSFORMERS, tokens, false);
    }

    public JSTransformer(NodeTransformer[] transformers, List<Token> tokens, boolean ignoreUnknown) {
        Assert.isNotNull(tokens);
        this.transformers = transformers;
        this.tokens = tokens;
        this.ignoreUnknown = ignoreUnknown;
        this.tokenOffsets = JSTransformer.prepareOffsetMap(tokens);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public Script transform(RuleReturnScope root) {
        Assert.isNotNull((Object)root);
        Tree tree = (Tree)root.getTree();
        if (tree == null) {
            return new Script();
        }
        Script script = new Script();
        this.addComments(script);
        if (tree.getType() != 0) {
            script.addStatement(this.transformStatementNode(tree, script));
        } else {
            int i = 0;
            while (i < tree.getChildCount()) {
                script.addStatement(this.transformStatementNode(tree.getChild(i), script));
                ++i;
            }
        }
        script.setStart(0);
        script.setEnd(this.tokenOffsets[this.tokenOffsets.length - 1]);
        return script;
    }

    private ASTNode getParent() {
        if (this.parents.isEmpty()) {
            return null;
        }
        return this.parents.peek();
    }

    private ASTNode transformNode(Tree node, ASTNode parent) {
        this.checkRecursionDepth();
        this.parents.push(parent);
        try {
            this.checkRecursionDepth();
            ASTNode result = (ASTNode)this.visitNode(node);
            Assert.isNotNull((Object)result, (String)node.toString());
            ASTNode aSTNode = result;
            return aSTNode;
        }
        catch (AssertionFailedException e) {
            if (this.ignoreUnknown) {
                ASTNode aSTNode = this.createErrorExpression(node);
                return aSTNode;
            }
            throw e;
        }
        finally {
            this.parents.pop();
        }
    }

    private static int[] prepareOffsetMap(List<Token> tokens) {
        int[] offsets = new int[tokens.size() + 1];
        int offset = 0;
        int i = 0;
        while (i < tokens.size()) {
            offsets[i] = offset;
            offset += tokens.get(i).getText().length();
            ++i;
        }
        offsets[tokens.size()] = offset;
        return offsets;
    }

    private int getTokenOffset(int tokenIndex) {
        Assert.isTrue((this.tokenOffsets != null ? 1 : 0) != 0);
        Assert.isTrue((tokenIndex >= -1 && tokenIndex < this.tokenOffsets.length ? 1 : 0) != 0);
        return this.tokenOffsets[tokenIndex];
    }

    private void setRangeByToken(ASTNode node, int tokenIndex) {
        node.setStart(this.getTokenOffset(tokenIndex));
        node.setEnd(this.getTokenOffset(tokenIndex + 1));
    }

    private void setRange(ASTNode node, Tree treeNode) {
        node.setStart(this.getTokenOffset(treeNode.getTokenStartIndex()));
        this.setEndByTokenIndex(node, treeNode.getTokenStopIndex());
    }

    private void setEndByTokenIndex(ASTNode node, int stopIndex) {
        while (stopIndex >= 0 && JSTransformer.isHidden(this.tokens.get(stopIndex))) {
            --stopIndex;
        }
        node.setEnd(this.getTokenOffset(stopIndex + 1));
    }

    private static boolean isHidden(Token token) {
        return token.getType() == 169 || token.getType() == 171 || token.getType() == 170;
    }

    private int getTokenOffset(int tokenType, int startTokenIndex, int endTokenIndex) {
        Assert.isTrue((startTokenIndex >= 0 ? 1 : 0) != 0);
        Assert.isTrue((endTokenIndex >= 0 ? 1 : 0) != 0);
        Assert.isTrue((startTokenIndex <= endTokenIndex ? 1 : 0) != 0);
        Token token = null;
        int i = startTokenIndex;
        while (i <= endTokenIndex) {
            Token item = this.tokens.get(i);
            if (item.getType() == tokenType) {
                token = item;
                break;
            }
            ++i;
        }
        if (token == null) {
            return -1;
        }
        return this.getTokenOffset(token.getTokenIndex());
    }

    private int getTokenOffset(int tokenType, int startTokenIndex, int endTokenIndex, int skipCount) {
        Assert.isTrue((startTokenIndex >= 0 ? 1 : 0) != 0);
        Assert.isTrue((endTokenIndex > 0 ? 1 : 0) != 0);
        Assert.isTrue((startTokenIndex <= endTokenIndex ? 1 : 0) != 0);
        Token token = null;
        int skipped = 0;
        int i = startTokenIndex;
        while (i <= endTokenIndex) {
            Token item = this.tokens.get(i);
            if (item.getType() == tokenType) {
                if (skipped == skipCount) {
                    token = item;
                    break;
                }
                ++skipped;
            }
            ++i;
        }
        if (token == null) {
            return -1;
        }
        return this.getTokenOffset(token.getTokenIndex());
    }

    private final Expression transformExpression(Tree node, ASTNode parent) {
        return (Expression)this.transformNode(node, parent);
    }

    private Statement transformStatementNode(Tree node, ASTNode parent) {
        Token token;
        ASTNode expression = this.transformNode(node, parent);
        if (expression instanceof Statement) {
            return (Statement)expression;
        }
        VoidExpression voidExpression = new VoidExpression(parent);
        voidExpression.setExpression((Expression)expression);
        if (node.getTokenStopIndex() >= 0 && node.getTokenStopIndex() < this.tokens.size() && (token = this.tokens.get(node.getTokenStopIndex())).getType() == 76) {
            voidExpression.setSemicolonPosition(this.getTokenOffset(token.getTokenIndex()));
            voidExpression.getExpression().setEnd(Math.min(voidExpression.getSemicolonPosition(), expression.sourceEnd()));
        }
        Assert.isTrue((expression.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((expression.sourceEnd() > 0 ? 1 : 0) != 0);
        voidExpression.setStart(expression.sourceStart());
        voidExpression.setEnd(Math.max(expression.sourceEnd(), voidExpression.getSemicolonPosition() + 1));
        return voidExpression;
    }

    @Override
    protected ASTNode visit(Tree tree) {
        ASTNode node = (ASTNode)super.visit(tree);
        if (node != null && this.transformers.length != 0) {
            ASTNode parent = this.getParent();
            NodeTransformer[] nodeTransformerArray = this.transformers;
            int n = this.transformers.length;
            int n2 = 0;
            while (n2 < n) {
                NodeTransformer transformer = nodeTransformerArray[n2];
                ASTNode transformed = transformer.transform(node, parent);
                if (transformed != null && transformed != node) {
                    return transformed;
                }
                ++n2;
            }
        }
        return node;
    }

    private void locateDocumentation(Documentable node, Tree tree) {
        int tokenIndex = tree.getTokenStartIndex();
        while (tokenIndex > 0) {
            Comment comment;
            Token token;
            if ((token = this.tokens.get(--tokenIndex)).getType() == 162 || token.getType() == 169) continue;
            if (token.getType() != 170 || (comment = this.documentationMap.get(token.getTokenIndex())) == null) break;
            node.setDocumentation(comment);
            break;
        }
    }

    @Override
    protected ASTNode visitUnknown(Tree node) {
        if (this.ignoreUnknown) {
            return this.createErrorExpression(node);
        }
        return (ASTNode)super.visitUnknown(node);
    }

    private ASTNode createErrorExpression(Tree node) {
        if (node != null) {
            ErrorExpression error = new ErrorExpression(this.getParent(), node.getText());
            error.setStart(this.getTokenOffset(node.getTokenStartIndex()));
            error.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
            return error;
        }
        return new ErrorExpression(this.getParent(), "");
    }

    @Override
    protected ASTNode visitBinaryOperation(Tree node) {
        if (node.getType() == 88) {
            switch (node.getChildCount()) {
                case 0: {
                    return this.visitAsterisk(node);
                }
                case 1: {
                    return this.visit(node.getChild(0));
                }
            }
        }
        Assert.isNotNull((Object)node.getChild(0));
        Assert.isNotNull((Object)node.getChild(1));
        BinaryOperation operation = new BinaryOperation(this.getParent());
        operation.setOperation(node.getType());
        operation.setLeftExpression(this.transformExpression(node.getChild(0), operation));
        operation.setRightExpression(this.transformExpression(node.getChild(1), operation));
        operation.setOperationPosition(this.getTokenOffset(node.getType(), JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        Assert.isTrue((operation.getOperationPosition() >= operation.getLeftExpression().sourceEnd() ? 1 : 0) != 0);
        Assert.isTrue((operation.getOperationPosition() + operation.getOperationText().length() <= operation.getRightExpression().sourceStart() ? 1 : 0) != 0);
        operation.setStart(operation.getLeftExpression().sourceStart());
        operation.setEnd(operation.getRightExpression().sourceEnd());
        return operation;
    }

    @Override
    protected ASTNode visitBlock(Tree node) {
        StatementBlock block = new StatementBlock(this.getParent());
        List<Statement> statements = block.getStatements();
        int i = 0;
        while (i < node.getChildCount()) {
            statements.add(this.transformStatementNode(node.getChild(i), block));
            ++i;
        }
        block.setLC(this.getTokenOffset(69, node.getTokenStartIndex(), node.getTokenStopIndex()));
        block.setRC(this.getTokenOffset(70, node.getTokenStopIndex(), node.getTokenStopIndex()));
        if (block.getLC() > -1) {
            block.setStart(block.getLC());
        } else if (!statements.isEmpty()) {
            block.setStart(statements.get(0).sourceStart());
        } else {
            block.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        }
        if (block.getRC() > -1) {
            block.setEnd(block.getRC() + 1);
        } else if (!statements.isEmpty()) {
            block.setEnd(statements.get(statements.size() - 1).sourceStart());
        } else {
            block.setEnd(this.getTokenOffset(node.getTokenStopIndex()));
        }
        return block;
    }

    private Keyword createKeyword(Tree node, String text) {
        assert (text.equals(node.getText()));
        Keyword keyword = new Keyword(text);
        this.setRangeByToken(keyword, node.getTokenStartIndex());
        return keyword;
    }

    @Override
    protected ASTNode visitBreak(Tree node) {
        BreakStatement statement = new BreakStatement(this.getParent());
        statement.setBreakKeyword(this.createKeyword(node, "break"));
        if (node.getChildCount() > 0) {
            Label label = new Label(statement);
            Tree labelNode = node.getChild(0);
            label.setText(labelNode.getText());
            this.setRangeByToken(label, labelNode.getTokenStartIndex());
            statement.setLabel(label);
            this.validateLabel(label);
        }
        statement.setSemicolonPosition(this.getTokenOffset(76, node.getTokenStopIndex(), node.getTokenStopIndex()));
        statement.setStart(statement.getBreakKeyword().sourceStart());
        if (statement.getLabel() != null) {
            statement.setEnd(Math.max(statement.getSemicolonPosition() + 1, statement.getLabel().sourceEnd()));
        } else {
            statement.setEnd(Math.max(statement.getSemicolonPosition() + 1, statement.getBreakKeyword().sourceEnd()));
        }
        if (statement.getLabel() == null) {
            this.validateParent(JavaScriptParserProblems.BAD_BREAK, statement, LoopStatement.class, SwitchStatement.class);
        }
        return statement;
    }

    @Override
    protected ASTNode visitCall(Tree node) {
        CallExpression call = new CallExpression(this.getParent());
        Assert.isNotNull((Object)node.getChild(0));
        Assert.isNotNull((Object)node.getChild(1));
        call.setExpression(this.transformExpression(node.getChild(0), call));
        Tree callArgs = node.getChild(1);
        IntList commas = new IntList();
        int i = 0;
        while (i < callArgs.getChildCount()) {
            Tree callArg = callArgs.getChild(i);
            ASTNode argument = this.transformNode(callArg, call);
            if (i > 0) {
                commas.add(this.getTokenOffset(77, callArgs.getChild(i - 1).getTokenStopIndex() + 1, callArg.getTokenStartIndex()));
            }
            call.addArgument(argument);
            ++i;
        }
        call.setCommas(commas);
        call.setLP(this.getTokenOffset(71, node.getChild(1).getTokenStartIndex(), node.getChild(1).getTokenStartIndex()));
        call.setRP(this.getTokenOffset(72, node.getChild(1).getTokenStopIndex(), node.getChild(1).getTokenStopIndex()));
        call.setStart(call.getExpression().sourceStart());
        if (call.getRP() > -1) {
            call.setEnd(call.getRP() + 1);
        } else {
            call.setEnd(call.getExpression().sourceEnd());
        }
        return call;
    }

    @Override
    protected ASTNode visitCase(Tree node) {
        CaseClause caseClause = new CaseClause(this.getParent());
        caseClause.setCaseKeyword(this.createKeyword(node, "case"));
        Tree condition = node.getChild(0);
        if (condition != null) {
            caseClause.setCondition(this.transformExpression(condition, caseClause));
            caseClause.setColonPosition(this.getTokenOffset(103, condition.getTokenStopIndex() + 1, node.getTokenStopIndex()));
        } else {
            caseClause.setCondition(new ErrorExpression(caseClause, ""));
            caseClause.setColonPosition(caseClause.getCaseKeyword().sourceEnd());
        }
        int i = 1;
        while (i < node.getChildCount()) {
            caseClause.getStatements().add(this.transformStatementNode(node.getChild(i), caseClause));
            ++i;
        }
        caseClause.setStart(caseClause.getCaseKeyword().sourceStart());
        caseClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return caseClause;
    }

    @Override
    protected ASTNode visitDecimalLiteral(Tree node) {
        DecimalLiteral number = new DecimalLiteral(this.getParent());
        number.setText(node.getText());
        number.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        number.setEnd(number.sourceStart() + number.getText().length());
        return number;
    }

    @Override
    protected ASTNode visitDefault(Tree node) {
        DefaultClause defaultClause = new DefaultClause(this.getParent());
        defaultClause.setDefaultKeyword(this.createKeyword(node, "default"));
        defaultClause.setColonPosition(this.getTokenOffset(103, node.getTokenStartIndex() + 1, node.getTokenStopIndex() + 1));
        int i = 0;
        while (i < node.getChildCount()) {
            defaultClause.getStatements().add(this.transformStatementNode(node.getChild(i), defaultClause));
            ++i;
        }
        defaultClause.setStart(defaultClause.getDefaultKeyword().sourceStart());
        defaultClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return defaultClause;
    }

    @Override
    protected ASTNode visitExpression(Tree node) {
        if (node.getChildCount() > 0) {
            return this.transformNode(node.getChild(0), this.getParent());
        }
        return new EmptyExpression(this.getParent());
    }

    @Override
    protected ASTNode visitFor(Tree node) {
        switch (node.getChild(0).getType()) {
            case 135: {
                return this.visitForStatement(node);
            }
            case 134: {
                return this.visitForInStatement(node);
            }
            case 126: {
                if (node.getChildCount() != 1) break;
                ForStatement statement = new ForStatement(this.getParent());
                statement.setForKeyword(this.createKeyword(node, "for"));
                statement.setInitial(new EmptyExpression(statement));
                statement.setCondition(new EmptyExpression(statement));
                statement.setStep(new EmptyExpression(statement));
                statement.setBody(this.transformStatementNode(node.getChild(0), statement));
                return statement;
            }
        }
        throw new IllegalArgumentException("FORSTEP or FORITER expected");
    }

    private ASTNode visitForStatement(Tree node) {
        ForStatement statement = new ForStatement(this.getParent());
        statement.setForKeyword(this.createKeyword(node, "for"));
        statement.setLP(this.getTokenOffset(71, node.getTokenStartIndex() + 1, node.getTokenStopIndex()));
        statement.setInitial(this.transformExpression(node.getChild(0).getChild(0), statement));
        statement.setCondition(this.transformExpression(node.getChild(0).getChild(1), statement));
        statement.setStep(this.transformExpression(node.getChild(0).getChild(2), statement));
        if (statement.getInitial() instanceof EmptyExpression) {
            statement.setInitialSemicolonPosition(this.getTokenOffset(76, node.getTokenStartIndex() + 2, node.getTokenStopIndex()));
            statement.getInitial().setStart(statement.getInitialSemicolonPosition());
            statement.getInitial().setEnd(statement.getInitialSemicolonPosition());
            if (statement.getCondition() instanceof EmptyExpression) {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(76, node.getTokenStartIndex(), node.getTokenStopIndex(), 1));
                statement.getCondition().setStart(statement.getConditionalSemicolonPosition());
                statement.getCondition().setEnd(statement.getConditionalSemicolonPosition());
            } else {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(76, node.getChild(0).getChild(1).getTokenStopIndex() + 1, node.getTokenStopIndex()));
            }
        } else {
            statement.setInitialSemicolonPosition(this.getTokenOffset(76, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(0)) + 1, node.getTokenStopIndex()));
            if (statement.getCondition() instanceof EmptyExpression) {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(76, node.getChild(0).getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex(), 1));
                statement.getCondition().setStart(statement.getConditionalSemicolonPosition());
                statement.getCondition().setEnd(statement.getConditionalSemicolonPosition());
            } else {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(76, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(1)) + 1, node.getTokenStopIndex()));
            }
        }
        if (statement.getStep() instanceof EmptyExpression) {
            statement.setStart(statement.getConditionalSemicolonPosition() + 1);
            statement.setEnd(statement.getConditionalSemicolonPosition() + 1);
        }
        statement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(statement.getForKeyword().sourceStart());
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    private ASTNode visitForInStatement(Tree node) {
        ForInStatement statement = new ForInStatement(this.getParent());
        statement.setForKeyword(this.createKeyword(node, "for"));
        statement.setLP(this.getTokenOffset(71, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        statement.setItem(this.transformExpression(node.getChild(0).getChild(0), statement));
        Keyword inKeyword = new Keyword("in");
        int iteratorStart = node.getChild(0).getChild(1).getTokenStartIndex();
        if (iteratorStart == -1 && node.getChild(0).getChild(1).getType() == 133 && node.getChild(0).getChild(1).getChildCount() > 0) {
            iteratorStart = node.getChild(0).getChild(1).getChild(0).getTokenStartIndex();
        }
        inKeyword.setStart(this.getTokenOffset(20, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(0)) + 1, iteratorStart));
        inKeyword.setEnd(inKeyword.sourceStart() + "in".length());
        statement.setInKeyword(inKeyword);
        statement.setIterator(this.transformExpression(node.getChild(0).getChild(1), statement));
        statement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(statement.getForKeyword().sourceStart());
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    private Argument transformArgument(Tree node, ASTNode parent) {
        Assert.isTrue((node.getType() == 178 || JSLexer.isIdentifierKeyword(node.getType()) ? 1 : 0) != 0);
        Argument argument = new Argument(parent);
        argument.setIdentifier((Identifier)this.visitIdentifier(node));
        argument.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        argument.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return argument;
    }

    @Override
    protected ASTNode visitFunction(Tree node) {
        SymbolKind replaced;
        FunctionStatement fn = new FunctionStatement(this.getParent(), node.getType() == 152);
        this.locateDocumentation(fn, node);
        fn.setFunctionKeyword(this.createKeyword(node, "function"));
        int index = 0;
        if (node.getChild(index).getType() != 124) {
            fn.setName((Identifier)this.transformNode(node.getChild(index), fn));
        }
        int n = ++index;
        ++index;
        Tree argsNode = node.getChild(n);
        assert (argsNode.getType() == 124);
        fn.setLP(this.getTokenOffset(71, node.getTokenStartIndex() + 1, argsNode.getTokenStartIndex()));
        SymbolTable functionScope = new SymbolTable();
        int i = 0;
        int childCount = argsNode.getChildCount();
        while (i < childCount) {
            Tree argNode = argsNode.getChild(i);
            Argument argument = this.transformArgument(argNode, fn);
            if (i + 1 < childCount) {
                argument.setCommaPosition(this.getTokenOffset(77, argNode.getTokenStopIndex() + 1, argsNode.getChild(i + 1).getTokenStartIndex()));
            }
            fn.addArgument(argument);
            if (functionScope.add(argument.getArgumentName(), SymbolKind.PARAM) != null && this.reporter != null) {
                this.reporter.setFormattedMessage(JavaScriptParserProblems.DUPLICATE_PARAMETER, argument.getArgumentName());
                this.reporter.setRange(argument.sourceStart(), argument.sourceEnd());
                this.reporter.report();
            }
            ++i;
        }
        fn.setRP(this.getTokenOffset(72, argsNode.getTokenStopIndex(), node.getChild(index).getTokenStartIndex()));
        Identifier nameNode = fn.getName();
        if (fn.isDeclaration() && nameNode != null && (replaced = this.scope.add(fn.getName().getName(), SymbolKind.FUNCTION)) != null && this.reporter != null) {
            if (replaced == SymbolKind.FUNCTION) {
                this.reporter.setFormattedMessage(JavaScriptParserProblems.DUPLICATE_FUNCTION, nameNode.getName());
            } else {
                this.reporter.setFormattedMessage(JavaScriptParserProblems.FUNCTION_DUPLICATES_OTHER, nameNode.getName(), replaced.verboseName());
            }
            this.reporter.setRange(nameNode.sourceStart(), nameNode.sourceEnd());
            this.reporter.report();
        }
        Tree bodyNode = node.getChild(index);
        SymbolTable savedScope = this.scope;
        try {
            this.scope = functionScope;
            fn.setBody((StatementBlock)this.transformNode(bodyNode, fn));
        }
        finally {
            this.scope = savedScope;
        }
        fn.setStart(fn.getFunctionKeyword().sourceStart());
        fn.setEnd(fn.getBody().sourceEnd());
        return fn;
    }

    @Override
    protected ASTNode visitIdentifier(Tree node) {
        Identifier id = new Identifier(this.getParent());
        this.locateDocumentation(id, node);
        id.setName(node.getText());
        this.setRangeByToken(id, node.getTokenStartIndex());
        return id;
    }

    @Override
    protected ASTNode visitReturn(Tree node) {
        Token token;
        ReturnStatement returnStatement = new ReturnStatement(this.getParent());
        returnStatement.setReturnKeyword(this.createKeyword(node, "return"));
        if (node.getChildCount() > 0) {
            returnStatement.setValue(this.transformExpression(node.getChild(0), returnStatement));
        }
        if ((token = this.tokens.get(node.getTokenStopIndex())).getType() == 76) {
            returnStatement.setSemicolonPosition(this.getTokenOffset(node.getTokenStopIndex()));
            returnStatement.setEnd(returnStatement.getSemicolonPosition() + 1);
        } else if (returnStatement.getValue() != null) {
            returnStatement.setEnd(returnStatement.getValue().sourceEnd());
        } else {
            returnStatement.setEnd(returnStatement.getReturnKeyword().sourceEnd());
        }
        returnStatement.setStart(returnStatement.getReturnKeyword().sourceStart());
        this.validateParent(JavaScriptParserProblems.INVALID_RETURN, returnStatement, FunctionStatement.class, Method.class);
        return returnStatement;
    }

    @Override
    protected ASTNode visitStringLiteral(Tree node) {
        StringLiteral literal = new StringLiteral(this.getParent());
        this.locateDocumentation(literal, node);
        literal.setText(node.getText());
        literal.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        literal.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return literal;
    }

    @Override
    protected ASTNode visitSwitch(Tree node) {
        SwitchStatement statement = new SwitchStatement(this.getParent());
        statement.setSwitchKeyword(this.createKeyword(node, "switch"));
        statement.setLP(this.getTokenOffset(71, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        statement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        statement.setCondition(this.transformExpression(node.getChild(0), statement));
        statement.setLC(this.getTokenOffset(69, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        ArrayList<Tree> caseNodes = new ArrayList<Tree>(node.getChildCount() - 1);
        int i = 1;
        while (i < node.getChildCount()) {
            caseNodes.add(node.getChild(i));
            ++i;
        }
        Collections.sort(caseNodes, new Comparator<Tree>(){

            @Override
            public int compare(Tree o1, Tree o2) {
                return o1.getTokenStartIndex() - o2.getTokenStartIndex();
            }
        });
        int defaultCount = 0;
        for (Tree child : caseNodes) {
            switch (child.getType()) {
                case 8: {
                    statement.addCase((SwitchComponent)this.transformNode(child, statement));
                    break;
                }
                case 11: {
                    if (defaultCount != 0 && this.reporter != null) {
                        this.reporter.setMessage(JavaScriptParserProblems.DOUBLE_SWITCH_DEFAULT);
                        this.reporter.setSeverity(ProblemSeverity.ERROR);
                        this.reporter.setStart(this.reporter.getOffset(child.getLine(), child.getCharPositionInLine()));
                        this.reporter.setEnd(this.reporter.getStart() + child.getText().length());
                        this.reporter.report();
                    }
                    ++defaultCount;
                    statement.addCase((SwitchComponent)this.transformNode(child, statement));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        statement.setRC(this.getTokenOffset(70, node.getTokenStopIndex(), node.getTokenStopIndex()));
        statement.setStart(statement.getSwitchKeyword().sourceStart());
        statement.setEnd(statement.getRC() + 1);
        return statement;
    }

    @Override
    protected ASTNode visitUnaryOperation(Tree node) {
        UnaryOperation operation = new UnaryOperation(this.getParent());
        operation.setOperation(node.getType());
        int operationType = node.getType();
        if (operation.isPostfix()) {
            operation.setOperationPosition(this.getTokenOffset(operationType, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        } else {
            operation.setOperationPosition(this.getTokenOffset(operationType, node.getTokenStartIndex(), node.getTokenStopIndex()));
        }
        if (operation.getOperationPosition() == -1) {
            switch (operationType) {
                case 147: {
                    operationType = 90;
                    break;
                }
                case 146: {
                    operationType = 91;
                    break;
                }
                case 148: {
                    operationType = 86;
                    break;
                }
                case 143: {
                    operationType = 87;
                }
            }
            if (operation.isPostfix()) {
                operation.setOperationPosition(this.getTokenOffset(operationType, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
            } else {
                operation.setOperationPosition(this.getTokenOffset(operationType, node.getTokenStartIndex(), node.getTokenStopIndex()));
            }
        }
        Assert.isTrue((operation.getOperationPosition() > -1 ? 1 : 0) != 0);
        operation.setExpression(this.transformExpression(node.getChild(0), operation));
        this.setRange(operation, node);
        return operation;
    }

    @Override
    protected ASTNode visitContinue(Tree node) {
        ContinueStatement statement = new ContinueStatement(this.getParent());
        statement.setContinueKeyword(this.createKeyword(node, "continue"));
        if (node.getChildCount() > 0) {
            Label label = new Label(statement);
            Tree labelNode = node.getChild(0);
            label.setText(labelNode.getText());
            this.setRangeByToken(label, labelNode.getTokenStartIndex());
            statement.setLabel(label);
            this.validateLabel(label);
        }
        statement.setSemicolonPosition(this.getTokenOffset(76, node.getTokenStopIndex(), node.getTokenStopIndex()));
        this.setRange(statement, node);
        if (statement.getLabel() == null) {
            this.validateParent(JavaScriptParserProblems.BAD_CONTINUE, statement, LoopStatement.class);
        }
        return statement;
    }

    private void validateLabel(Label label) {
        if (this.reporter == null) {
            return;
        }
        if (!this.scope.hasLabel(label.getText())) {
            this.reporter.setFormattedMessage(JavaScriptParserProblems.UNDEFINED_LABEL, label.getText());
            this.reporter.setSeverity(ProblemSeverity.ERROR);
            this.reporter.setRange(label.sourceStart(), label.sourceEnd());
            this.reporter.report();
        }
    }

    private void validateParent(JSProblemIdentifier messageId, Statement statement, Class<?> ... classes) {
        if (this.reporter == null) {
            return;
        }
        ListIterator i = this.parents.listIterator(this.parents.size());
        while (i.hasPrevious()) {
            ASTNode parent = (ASTNode)i.previous();
            Class<?>[] classArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                if (clazz.isInstance(parent)) {
                    return;
                }
                ++n2;
            }
        }
        this.reporter.setMessage(messageId);
        this.reporter.setRange(statement.sourceStart(), statement.sourceEnd());
        this.reporter.setSeverity(ProblemSeverity.ERROR);
        this.reporter.report();
    }

    private VariableDeclaration transformVariableDeclaration(Tree node, IVariableStatement statement) {
        Assert.isTrue((node.getType() == 178 || JSLexer.isIdentifierKeyword(node.getType()) ? 1 : 0) != 0);
        VariableDeclaration declaration = new VariableDeclaration(statement);
        declaration.setIdentifier((Identifier)this.transformNode(node, declaration));
        declaration.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        declaration.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        int i = 0;
        if (i + 2 <= node.getChildCount() && node.getChild(i).getType() == 104) {
            declaration.setAssignPosition(this.getTokenOffset(node.getChild(i).getTokenStartIndex()));
            declaration.setInitializer(this.transformExpression(node.getChild(i + 1), declaration));
            i += 2;
        }
        return declaration;
    }

    @Override
    protected ASTNode visitVarDeclaration(Tree node) {
        VariableStatement var = new VariableStatement(this.getParent());
        this.locateDocumentation(var, node);
        var.setVarKeyword(this.createKeyword(node, "var"));
        this.processVariableDeclarations(node, var, SymbolKind.VAR);
        this.setRange(var, node);
        return var;
    }

    private void processVariableDeclarations(Tree node, IVariableStatement var, SymbolKind kind) {
        int i = 0;
        int childCount = node.getChildCount();
        while (i < childCount) {
            SymbolKind replaced;
            Tree varNode = node.getChild(i);
            VariableDeclaration declaration = this.transformVariableDeclaration(varNode, var);
            var.addVariable(declaration);
            if (i + 1 < childCount) {
                declaration.setCommaPosition(this.getTokenOffset(77, varNode.getTokenStopIndex() + 1, node.getChild(i + 1).getTokenStartIndex()));
            }
            if ((replaced = this.scope.add(declaration.getVariableName(), kind)) != null && this.reporter != null) {
                Identifier identifier = declaration.getIdentifier();
                this.reporter.setRange(identifier.sourceStart(), identifier.sourceEnd());
                if (replaced == kind) {
                    this.reporter.setFormattedMessage(kind.duplicateProblem, declaration.getVariableName());
                } else {
                    this.reporter.setFormattedMessage(kind.hideProblem, declaration.getVariableName(), replaced.verboseName());
                }
                this.reporter.report();
            }
            ++i;
        }
    }

    @Override
    protected ASTNode visitObjectInitializer(Tree node) {
        ObjectInitializer initializer = new ObjectInitializer(this.getParent());
        IntList commas = new IntList();
        int i = 0;
        while (i < node.getChildCount()) {
            Tree child = node.getChild(i);
            if (child.getType() == 77) {
                commas.add(this.getTokenOffset(child.getTokenStartIndex()));
            } else {
                initializer.addInitializer((ObjectInitializerPart)this.transformNode(child, initializer));
            }
            ++i;
        }
        if (!commas.isEmpty() && commas.size() >= initializer.getInitializers().size()) {
            this.reporter.setMessage(JavaScriptParserProblems.TRAILING_COMMA_OBJECT_INITIALIZER);
            int comma = commas.get(commas.size() - 1);
            this.reporter.setRange(comma, comma + 1);
            this.reporter.report();
        }
        initializer.setCommas(commas);
        initializer.setLC(this.getTokenOffset(node.getTokenStartIndex()));
        initializer.setRC(this.getTokenOffset(node.getTokenStopIndex()));
        Token LC = this.tokens.get(node.getTokenStartIndex());
        Token RC = this.tokens.get(node.getTokenStopIndex());
        initializer.setMultiline(LC.getLine() != RC.getLine());
        initializer.setStart(initializer.getLC());
        initializer.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return initializer;
    }

    @Override
    protected ASTNode visitPropertyInitializer(Tree node) {
        PropertyInitializer initializer = new PropertyInitializer(this.getParent());
        initializer.setName(this.transformExpression(node.getChild(0), initializer));
        initializer.setColon(this.getTokenOffset(103, node.getChild(0).getTokenStopIndex() + 1, node.getChildCount() == 2 ? node.getChild(1).getTokenStartIndex() : node.getTokenStopIndex()));
        initializer.setValue(this.transformExpression(node.getChild(1), initializer));
        initializer.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        initializer.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return initializer;
    }

    @Override
    protected ASTNode visitForEachInStatement(Tree node) {
        ForEachInStatement statement = new ForEachInStatement(this.getParent());
        statement.setForKeyword(this.createKeyword(node, "for"));
        Keyword eachKeyword = new Keyword("each");
        eachKeyword.setStart(this.getTokenOffset(17, node.getTokenStartIndex(), node.getTokenStopIndex()));
        eachKeyword.setEnd(eachKeyword.sourceStart() + "each".length());
        statement.setEachKeyword(eachKeyword);
        statement.setLP(this.getTokenOffset(71, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        statement.setItem(this.transformExpression(node.getChild(0).getChild(0), statement));
        Keyword inKeyword = new Keyword("in");
        int iteratorStart = node.getChild(0).getChild(1).getTokenStartIndex();
        if (iteratorStart == -1 && node.getChild(0).getChild(1).getType() == 133 && node.getChild(0).getChild(1).getChildCount() > 0) {
            iteratorStart = node.getChild(0).getChild(1).getChild(0).getTokenStartIndex();
        }
        inKeyword.setStart(this.getTokenOffset(20, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(0)) + 1, iteratorStart));
        inKeyword.setEnd(inKeyword.sourceStart() + "in".length());
        statement.setInKeyword(inKeyword);
        statement.setIterator(this.transformExpression(node.getChild(0).getChild(1), statement));
        statement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    private static int getRealTokenStopIndex(Tree node) {
        if (node.getTokenStopIndex() == -1) {
            return JSTransformer.getRealTokenStopIndex(node.getChild(node.getChildCount() - 1));
        }
        if (node.getChildCount() > 0) {
            return Math.max(node.getTokenStopIndex(), JSTransformer.getRealTokenStopIndex(node.getChild(node.getChildCount() - 1)));
        }
        return node.getTokenStopIndex();
    }

    @Override
    protected ASTNode visitByField(Tree node) {
        PropertyExpression property = new PropertyExpression(this.getParent());
        this.locateDocumentation(property, node);
        property.setObject(this.transformExpression(node.getChild(0), property));
        int dotPosition = this.getTokenOffset(node.getChild(1).getTokenStartIndex());
        property.setDotPosition(dotPosition);
        if (node.getChild(2) != null) {
            property.setProperty(this.transformExpression(node.getChild(2), property));
        } else {
            ErrorExpression error = new ErrorExpression(property, "");
            error.setStart(dotPosition + 1);
            error.setEnd(dotPosition + 1);
            property.setProperty(error);
        }
        Assert.isTrue((property.getObject().sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((property.getProperty().sourceEnd() > 0 ? 1 : 0) != 0);
        property.setStart(property.getObject().sourceStart());
        property.setEnd(property.getProperty().sourceEnd());
        return property;
    }

    @Override
    protected ASTNode visitWhile(Tree node) {
        WhileStatement statement = new WhileStatement(this.getParent());
        statement.setWhileKeyword(this.createKeyword(node, "while"));
        statement.setLP(this.getTokenOffset(71, node.getTokenStartIndex(), node.getChild(0).getTokenStartIndex()));
        statement.setCondition(this.transformExpression(node.getChild(0), statement));
        statement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    @Override
    protected ASTNode visitIf(Tree node) {
        IfStatement ifStatement = new IfStatement(this.getParent());
        ifStatement.setIfKeyword(this.createKeyword(node, "if"));
        ifStatement.setLP(this.getTokenOffset(71, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        ifStatement.setCondition(this.transformExpression(node.getChild(0), ifStatement));
        if (node.getChildCount() > 1) {
            ifStatement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
            ifStatement.setThenStatement(this.transformStatementNode(node.getChild(1), ifStatement));
        } else {
            ifStatement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getChild(0).getTokenStopIndex() + 1));
        }
        if (node.getChildCount() > 2) {
            Keyword elseKeyword = new Keyword("else");
            elseKeyword.setStart(this.getTokenOffset(14, node.getChild(1).getTokenStopIndex() + 1, node.getChild(2).getTokenStartIndex()));
            elseKeyword.setEnd(elseKeyword.sourceStart() + "else".length());
            ifStatement.setElseKeyword(elseKeyword);
            ifStatement.setElseStatement(this.transformStatementNode(node.getChild(2), ifStatement));
        }
        ifStatement.setStart(ifStatement.getIfKeyword().sourceStart());
        this.setEndByTokenIndex(ifStatement, node.getTokenStopIndex());
        return ifStatement;
    }

    @Override
    protected ASTNode visitDoWhile(Tree node) {
        DoWhileStatement statement = new DoWhileStatement(this.getParent());
        statement.setDoKeyword(this.createKeyword(node, "do"));
        statement.setBody(this.transformStatementNode(node.getChild(0), statement));
        Keyword whileKeyword = new Keyword("while");
        whileKeyword.setStart(this.getTokenOffset(31, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        whileKeyword.setEnd(whileKeyword.sourceStart() + "while".length());
        statement.setWhileKeyword(whileKeyword);
        statement.setLP(this.getTokenOffset(71, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        statement.setCondition(this.transformExpression(node.getChild(1), statement));
        statement.setRP(this.getTokenOffset(72, node.getChild(1).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        statement.setSemicolonPosition(this.getTokenOffset(76, node.getChild(1).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    @Override
    protected ASTNode visitConditional(Tree node) {
        ConditionalOperator operator = new ConditionalOperator(this.getParent());
        operator.setCondition(this.transformExpression(node.getChild(0), operator));
        operator.setTrueValue(this.transformExpression(node.getChild(1), operator));
        operator.setFalseValue(this.transformExpression(node.getChild(2), operator));
        operator.setQuestionPosition(this.getTokenOffset(102, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        operator.setColonPosition(this.getTokenOffset(103, node.getChild(1).getTokenStopIndex() + 1, node.getChild(2).getTokenStartIndex()));
        operator.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        operator.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return operator;
    }

    @Override
    protected ASTNode visitParenthesizedExpression(Tree node) {
        ParenthesizedExpression expression = new ParenthesizedExpression(this.getParent());
        expression.setExpression(this.transformExpression(node.getChild(0), expression));
        expression.setLP(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setRP(this.getTokenOffset(node.getTokenStopIndex()));
        expression.setStart(expression.getLP());
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return expression;
    }

    @Override
    protected ASTNode visitTry(Tree node) {
        TryStatement statement = new TryStatement(this.getParent());
        statement.setTryKeyword(this.createKeyword(node, "try"));
        statement.setBody((StatementBlock)this.transformStatementNode(node.getChild(0), statement));
        boolean sawDefaultCatch = false;
        int i = 1;
        while (i < node.getChildCount()) {
            Tree child = node.getChild(i);
            switch (child.getType()) {
                case 9: {
                    CatchClause catchClause = (CatchClause)this.transformNode(child, statement);
                    if (this.reporter != null && sawDefaultCatch) {
                        this.reporter.setMessage(JavaScriptParserProblems.CATCH_UNREACHABLE);
                        this.reporter.setRange(catchClause.sourceStart(), catchClause.getRP() + 1);
                        this.reporter.report();
                    }
                    if (!sawDefaultCatch && catchClause.getFilterExpression() == null) {
                        sawDefaultCatch = true;
                    }
                    statement.getCatches().add(catchClause);
                    break;
                }
                case 15: {
                    statement.setFinally((FinallyClause)this.transformNode(child, statement));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("CATCH or FINALLY expected");
                }
            }
            ++i;
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    @Override
    protected ASTNode visitThrow(Tree node) {
        ThrowStatement statement = new ThrowStatement(this.getParent());
        statement.setThrowKeyword(this.createKeyword(node, "throw"));
        if (node.getChildCount() > 0) {
            statement.setException(this.transformExpression(node.getChild(0), statement));
        }
        statement.setSemicolonPosition(this.getTokenOffset(76, node.getTokenStopIndex(), node.getTokenStopIndex()));
        this.setRange(statement, node);
        return statement;
    }

    @Override
    protected ASTNode visitNew(Tree node) {
        NewExpression expression = new NewExpression(this.getParent());
        expression.setNewKeyword(this.createKeyword(node, "new"));
        expression.setObjectClass(this.transformExpression(node.getChild(0), expression));
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return expression;
    }

    @Override
    protected ASTNode visitCatch(Tree node) {
        CatchClause catchClause = new CatchClause(this.getParent());
        catchClause.setCatchKeyword(this.createKeyword(node, "catch"));
        catchClause.setLP(this.getTokenOffset(71, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        catchClause.setException((Identifier)this.transformNode(node.getChild(0), catchClause));
        int statementIndex = 1;
        if (statementIndex < node.getChildCount() && node.getChild(statementIndex).getType() == 19) {
            catchClause.setIfKeyword(this.createKeyword(node.getChild(statementIndex++), "if"));
            catchClause.setFilterExpression(this.transformExpression(node.getChild(statementIndex++), catchClause));
        }
        if (statementIndex < node.getChildCount()) {
            catchClause.setRP(this.getTokenOffset(72, node.getChild(statementIndex - 1).getTokenStopIndex() + 1, node.getChild(statementIndex).getTokenStartIndex()));
            catchClause.setStatement(this.transformStatementNode(node.getChild(statementIndex), catchClause));
        }
        catchClause.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        catchClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return catchClause;
    }

    @Override
    protected ASTNode visitFinally(Tree node) {
        FinallyClause finallyClause = new FinallyClause(this.getParent());
        finallyClause.setFinallyKeyword(this.createKeyword(node, "finally"));
        if (node.getChildCount() >= 1) {
            finallyClause.setStatement(this.transformStatementNode(node.getChild(0), finallyClause));
        }
        finallyClause.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        finallyClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return finallyClause;
    }

    @Override
    protected ASTNode visitArray(Tree node) {
        int itemCount = node.getChildCount() - 1;
        ArrayInitializer array = new ArrayInitializer(this.getParent(), itemCount);
        array.setLB(this.getTokenOffset(node.getTokenStartIndex()));
        int i = 0;
        while (i < itemCount) {
            Tree child = node.getChild(i);
            assert (child.getType() == 140) : "ITEM expected";
            Tree item = child.getChild(0);
            if (item != null) {
                array.getItems().add(this.transformExpression(item, array));
            } else {
                array.getItems().add(new EmptyExpression(this.getParent()));
            }
            if (i > 0) {
                array.getCommas().add(this.getTokenOffset(77, node.getChild(i - 1).getTokenStopIndex() + 1, child.getTokenStartIndex()));
            }
            ++i;
        }
        array.setRB(this.getTokenOffset(node.getChild(itemCount).getTokenStartIndex()));
        array.setStart(array.getLB());
        array.setEnd(array.getRB() + 1);
        return array;
    }

    @Override
    protected ASTNode visitByIndex(Tree node) {
        GetArrayItemExpression item = new GetArrayItemExpression(this.getParent());
        item.setArray(this.transformExpression(node.getChild(0), item));
        item.setLB(this.getTokenOffset(((CommonTree)node).getToken().getTokenIndex()));
        if (node.getChildCount() == 2) {
            item.setIndex(this.transformExpression(node.getChild(1), item));
            item.setRB(this.getTokenOffset(74, node.getChild(1).getTokenStopIndex() + 1, this.tokens.size() - 1));
        } else {
            item.setIndex(new ErrorExpression(item, ""));
            item.setRB(this.getTokenOffset(74, node.getChild(0).getTokenStopIndex() + 1, this.tokens.size() - 1));
        }
        item.setStart(item.getArray().sourceStart());
        if (item.getRB() > -1) {
            item.setEnd(item.getRB() + 1);
        } else {
            item.setEnd(item.getIndex().sourceEnd());
        }
        return item;
    }

    @Override
    protected ASTNode visitCommaExpression(Tree node) {
        CommaExpression expression = new CommaExpression(this.getParent());
        ArrayList<ASTNode> items = new ArrayList<ASTNode>(node.getChildCount());
        IntList commas = new IntList();
        int i = 0;
        while (i < node.getChildCount()) {
            items.add(this.transformNode(node.getChild(i), expression));
            if (i > 0) {
                commas.add(this.getTokenOffset(77, node.getChild(i - 1).getTokenStopIndex(), node.getChild(i).getTokenStartIndex()));
            }
            ++i;
        }
        expression.setItems(items);
        expression.setCommas(commas);
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return expression;
    }

    @Override
    protected ASTNode visitRegExp(Tree node) {
        RegExpLiteral regexp = new RegExpLiteral(this.getParent());
        regexp.setText(node.getText());
        regexp.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        regexp.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return regexp;
    }

    @Override
    protected ASTNode visitWith(Tree node) {
        WithStatement statement = new WithStatement(this.getParent());
        statement.setWithKeyword(this.createKeyword(node, "with"));
        statement.setLP(this.getTokenOffset(71, node.getTokenStartIndex(), node.getChild(0).getTokenStartIndex()));
        statement.setExpression(this.transformExpression(node.getChild(0), statement));
        statement.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setStatement(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    @Override
    protected ASTNode visitThis(Tree node) {
        ThisExpression expression = new ThisExpression(this.getParent());
        expression.setThisKeyword(this.createKeyword(node, "this"));
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return expression;
    }

    @Override
    protected ASTNode visitLabelled(Tree node) {
        LabelledStatement statement = new LabelledStatement(this.getParent());
        Label label = new Label(statement);
        label.setText(node.getChild(0).getText());
        this.setRangeByToken(label, node.getChild(0).getTokenStartIndex());
        statement.setLabel(label);
        statement.setColonPosition(this.getTokenOffset(103, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex() + 1));
        if (!this.scope.addLabel(statement) && this.reporter != null) {
            this.reporter.setMessage(JavaScriptParserProblems.DUPLICATE_LABEL);
            this.reporter.setSeverity(ProblemSeverity.ERROR);
            this.reporter.setRange(label.sourceStart(), label.sourceEnd());
            this.reporter.report();
        }
        if (node.getChildCount() > 1) {
            statement.setStatement(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    @Override
    protected ASTNode visitDelete(Tree node) {
        DeleteStatement statement = new DeleteStatement(this.getParent());
        statement.setDeleteKeyword(this.createKeyword(node, "delete"));
        statement.setExpression(this.transformExpression(node.getChild(0), statement));
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return statement;
    }

    @Override
    protected ASTNode visitGet(Tree node) {
        GetMethod method = new GetMethod(this.getParent());
        method.setGetKeyword(this.createKeyword(node, "get"));
        method.setName((Identifier)this.transformNode(node.getChild(0), method));
        method.setLP(this.getTokenOffset(71, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        method.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        method.setBody((StatementBlock)this.transformStatementNode(node.getChild(1), method));
        method.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        method.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return method;
    }

    @Override
    protected ASTNode visitSet(Tree node) {
        SetMethod method = new SetMethod(this.getParent());
        method.setSetKeyword(this.createKeyword(node, "set"));
        method.setName((Identifier)this.transformNode(node.getChild(0), method));
        method.setLP(this.getTokenOffset(71, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        method.setArgument((Identifier)this.transformNode(node.getChild(1), method));
        method.setRP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getChild(2).getTokenStartIndex()));
        method.setBody((StatementBlock)this.transformStatementNode(node.getChild(2), method));
        method.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        method.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return method;
    }

    @Override
    protected ASTNode visitNull(Tree node) {
        NullExpression expression = new NullExpression(this.getParent());
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return expression;
    }

    @Override
    protected ASTNode visitTypeOf(Tree node) {
        TypeOfExpression expression = new TypeOfExpression(this.getParent());
        expression.setTypeOfKeyword(this.createKeyword(node, "typeof"));
        expression.setExpression(this.transformExpression(node.getChild(0), expression));
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return expression;
    }

    @Override
    protected ASTNode visitConst(Tree node) {
        ConstStatement declaration = new ConstStatement(this.getParent());
        declaration.setConstKeyword(this.createKeyword(node, "const"));
        this.processVariableDeclarations(node, declaration, SymbolKind.CONST);
        declaration.setSemicolonPosition(this.getTokenOffset(76, node.getTokenStopIndex(), node.getTokenStopIndex()));
        declaration.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        declaration.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return declaration;
    }

    private void addComments(Script script) {
        int i = 0;
        while (i < this.tokens.size()) {
            block7: {
                Comment comment;
                Token token;
                block6: {
                    Comment c;
                    block5: {
                        token = this.tokens.get(i);
                        if (token.getType() != 170) break block5;
                        c = new MultiLineComment();
                        c.setText(token.getText());
                        c.setStart(this.getTokenOffset(token.getTokenIndex()));
                        c.setEnd(c.sourceStart() + token.getText().length());
                        comment = c;
                        break block6;
                    }
                    if (token.getType() != 171) break block7;
                    c = new SingleLineComment();
                    c.setText(token.getText());
                    c.setStart(this.getTokenOffset(token.getTokenIndex()));
                    c.setEnd(c.sourceStart() + token.getText().length());
                    comment = c;
                }
                script.addComment(comment);
                if (comment.isDocumentation()) {
                    this.documentationMap.put(token.getTokenIndex(), comment);
                }
            }
            ++i;
        }
    }

    @Override
    protected ASTNode visitBooleanLiteral(Tree node) {
        BooleanLiteral bool = new BooleanLiteral(this.getParent(), node.getText());
        bool.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        bool.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        return bool;
    }

    @Override
    protected ASTNode visitVoid(Tree node) {
        VoidOperator expression = new VoidOperator(this.getParent());
        expression.setVoidKeyword(this.createKeyword(node, "void"));
        expression.setExpression(this.transformExpression(node.getChild(0), expression));
        expression.setStart(expression.getVoidKeyword().sourceStart());
        expression.setEnd(expression.getExpression().sourceEnd());
        return expression;
    }

    @Override
    protected ASTNode visitXmlLiteral(Tree node) {
        XmlLiteral xml = new XmlLiteral(this.getParent());
        ArrayList<XmlFragment> fragments = new ArrayList<XmlFragment>();
        int i = 0;
        while (i < node.getChildCount()) {
            XmlFragment fragment;
            Tree child = node.getChild(i);
            if (child.getType() == 120 || child.getType() == 121) {
                fragment = new XmlTextFragment(xml);
                fragment.setStart(this.getTokenOffset(child.getTokenStartIndex()));
                fragment.setEnd(this.getTokenOffset(child.getTokenStopIndex() + 1));
                ((XmlTextFragment)fragment).setXml(child.getText());
                fragments.add(fragment);
            } else {
                fragment = new XmlExpressionFragment(xml);
                Expression expression = this.transformExpression(child, fragment);
                ((XmlExpressionFragment)fragment).setExpression(expression);
                fragment.setStart(expression.sourceStart());
                fragment.setEnd(expression.sourceEnd());
                fragments.add(fragment);
            }
            ++i;
        }
        if (fragments.size() > 1) {
            Collections.sort(fragments, new Comparator<XmlFragment>(){

                @Override
                public int compare(XmlFragment o1, XmlFragment o2) {
                    return o1.sourceStart() - o2.sourceStart();
                }
            });
        }
        xml.setFragments(fragments);
        xml.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        xml.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return xml;
    }

    @Override
    protected ASTNode visitNamespace(Tree node) {
        DefaultXmlNamespaceStatement statement = new DefaultXmlNamespaceStatement(this.getParent());
        statement.setDefaultKeyword(this.createKeyword(node.getChild(0), "default"));
        statement.setXmlKeyword(this.createKeyword(node.getChild(1), "xml"));
        Keyword namespaceKeyword = new Keyword("namespace");
        namespaceKeyword.setStart(this.getTokenOffset(37, node.getTokenStartIndex(), node.getTokenStopIndex()));
        namespaceKeyword.setEnd(namespaceKeyword.sourceStart() + "namespace".length());
        statement.setNamespaceKeyword(namespaceKeyword);
        statement.setAssignOperation(this.getTokenOffset(node.getChild(2).getTokenStartIndex()));
        statement.setValue(this.transformExpression(node.getChild(3), statement));
        Token token = this.tokens.get(node.getTokenStopIndex());
        if (token.getType() == 76) {
            statement.setSemicolonPosition(this.getTokenOffset(node.getTokenStopIndex()));
            statement.setEnd(statement.getSemicolonPosition() + 1);
        } else {
            statement.setEnd(statement.getValue().sourceEnd());
        }
        statement.setStart(statement.getDefaultKeyword().sourceStart());
        return statement;
    }

    @Override
    protected ASTNode visitXmlAttribute(Tree node) {
        XmlAttributeIdentifier id = new XmlAttributeIdentifier(this.getParent());
        Expression expression = this.transformExpression(node.getChild(1), id);
        id.setExpression(expression);
        id.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        id.setEnd(expression.sourceEnd());
        return id;
    }

    protected ASTNode visitAsterisk(Tree node) {
        AsteriskExpression asterisk = new AsteriskExpression(this.getParent());
        asterisk.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        asterisk.setEnd(asterisk.sourceStart() + node.getText().length());
        return asterisk;
    }

    @Override
    protected ASTNode visitGetAllChildren(Tree node) {
        GetAllChildrenExpression expression = new GetAllChildrenExpression(this.getParent());
        expression.setObject(this.transformExpression(node.getChild(0), expression));
        expression.setProperty(this.transformExpression(node.getChild(1), expression));
        expression.setDotDotPosition(this.getTokenOffset(118, JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        Assert.isTrue((expression.getObject().sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((expression.getProperty().sourceEnd() > 0 ? 1 : 0) != 0);
        expression.setStart(expression.getObject().sourceStart());
        expression.setEnd(expression.getProperty().sourceEnd());
        return expression;
    }

    @Override
    protected ASTNode visitGetLocalName(Tree node) {
        GetLocalNameExpression expression = new GetLocalNameExpression(this.getParent());
        expression.setNamespace(this.transformExpression(node.getChild(0), expression));
        expression.setLocalName(this.transformExpression(node.getChild(1), expression));
        expression.setColonColonPosition(this.getTokenOffset(119, JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        Assert.isTrue((expression.getNamespace().sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((expression.getLocalName().sourceEnd() > 0 ? 1 : 0) != 0);
        expression.setStart(expression.getNamespace().sourceStart());
        expression.setEnd(expression.getLocalName().sourceEnd());
        return expression;
    }

    @Override
    protected ASTNode visitHexIntegerLiteral(Tree node) {
        DecimalLiteral number = new DecimalLiteral(this.getParent());
        number.setText(node.getText());
        number.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        number.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return number;
    }

    @Override
    protected ASTNode visitOctalIntegerLiteral(Tree node) {
        DecimalLiteral number = new DecimalLiteral(this.getParent());
        number.setText(node.getText());
        number.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        number.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        return number;
    }

    @Override
    protected ASTNode visitYield(Tree node) {
        YieldOperator expression = new YieldOperator(this.getParent());
        expression.setYieldKeyword(this.createKeyword(node, "yield"));
        expression.setExpression(this.transformExpression(node.getChild(0), expression));
        expression.setStart(expression.getYieldKeyword().sourceStart());
        expression.setEnd(expression.getExpression().sourceEnd());
        return expression;
    }

    @Override
    protected ASTNode visitEmptyStatement(Tree node) {
        EmptyStatement statement = new EmptyStatement(this.getParent());
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        return statement;
    }
}

