/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser.jsdoc;

public class JSDocTag {
    public static final String PARAM = "@param";
    public static final String RETURN = "@return";
    public static final String RETURNS = "@returns";
    public static final String THROWS = "@throws";
    public static final String TYPE = "@type";
    public static final String DEPRECATED = "@deprecated";
    public static final String CONSTRUCTOR = "@constructor";
    public static final String PROTECTED = "@protected";
    public static final String PRIVATE = "@private";
    public static final String AUTHOR = "@author";
    public static final String VERSION = "@version";
    public static final String SEE = "@see";
    public static final String SINCE = "@since";
    public static final String EXAMPLE = "@example";
    public static final String SUPPRESS_WARNINGS = "@SuppressWarnings";
    private final String tag;
    private final String value;
    private final int start;
    private final int end;

    public static String[] getTags() {
        return new String[]{PARAM, RETURN, RETURNS, THROWS, TYPE, DEPRECATED, CONSTRUCTOR, PRIVATE, PROTECTED, AUTHOR, VERSION, SEE, SINCE, EXAMPLE, SUPPRESS_WARNINGS};
    }

    public JSDocTag(String tag, String value, int start, int end) {
        this.tag = tag;
        this.value = value;
        this.start = start;
        this.end = end;
    }

    public String name() {
        return this.tag;
    }

    public String value() {
        return this.value;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    @Deprecated
    public String getValue() {
        return this.value;
    }

    @Deprecated
    public int getStart() {
        return this.start;
    }

    @Deprecated
    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return this.value != null && this.value.length() != 0 ? String.valueOf(this.tag) + " " + this.value : this.tag;
    }
}

