/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclGlobalVariableDeclaration;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclVisibilityUtils;

public class TclGlobalVariableProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        int statementsCount = statement.getCount();
        if (statementsCount < 2) {
            this.report(parser, "Syntax error: at least one argument expected.", (ASTNode)statement, ProblemSeverities.Error);
            return null;
        }
        TclGlobalVariableDeclaration ret = null;
        int i = 1;
        while (i < statementsCount) {
            Expression at = statement.getAt(i);
            Expression variableName = at;
            if (variableName != null) {
                SimpleReference variable = TclParseUtil.makeVariable(variableName);
                if (variable != null) {
                    TclGlobalVariableDeclaration var = new TclGlobalVariableDeclaration(variable, at.sourceStart(), at.sourceEnd());
                    if (TclVisibilityUtils.isPrivate(variable.getName())) {
                        var.setModifier(16);
                    } else {
                        var.setModifier(64);
                    }
                    var.setModifier(8192);
                    if (ret == null) {
                        ret = var;
                    } else {
                        if (!(ret instanceof Block)) {
                            Block list = new Block();
                            list.addStatement((ASTNode)ret);
                            list.setStart(ret.sourceStart());
                            list.setEnd(ret.sourceEnd());
                            ret = list;
                        }
                        ((Block)ret).addStatement((ASTNode)var);
                        ((Block)ret).setEnd(var.sourceEnd());
                    }
                }
            } else {
                this.report(parser, "Incorect global variable", (ASTNode)statement, ProblemSeverities.Error);
            }
            ++i;
        }
        if (ret != null) {
            this.addToParent(parent, (ASTNode)ret);
        }
        return ret;
    }
}

