/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierExtension3;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.core.builder.Messages;

public class BuildProblemReporter
extends ProblemCollector {
    private final IProblemFactory problemFactory;
    final IResource resource;
    private boolean oldMarkersDeleted = false;

    public BuildProblemReporter(IProblemFactory problemFactory, IResource resource) {
        this.problemFactory = problemFactory;
        this.resource = resource;
    }

    public void flush() {
        try {
            if (!this.oldMarkersDeleted) {
                this.oldMarkersDeleted = true;
                this.problemFactory.deleteMarkers(this.resource);
            }
            this.createMarkers(this.resource, this.problemFactory);
            this.problems.clear();
        }
        catch (CoreException e) {
            DLTKCore.error(Messages.BuildProblemReporter_errorUpdatingMarkers, e);
        }
    }

    public boolean hasCategory(IProblemCategory category) {
        for (IProblem problem : this.getProblems()) {
            IProblemIdentifier id = problem.getID();
            if (id == null || !(id instanceof IProblemIdentifierExtension3) || !((IProblemIdentifierExtension3)((Object)id)).belongsTo(category)) continue;
            return true;
        }
        return false;
    }
}

