/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser.jsdoc;

import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTags;
import org.eclipse.dltk.utils.IntList;

public class SimpleJSDocParser {
    private static final char FORM_FEED = '\f';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char TAB = '\t';
    private static final char SPACE = ' ';
    private char[] buffer;
    private int index;
    private int end;
    private final StringBuilder value = new StringBuilder();
    private final IntList ends = new IntList();

    public JSDocTags parse(String content, int offset) {
        JSDocTags tags = new JSDocTags();
        this.index = "/**".length();
        this.buffer = content.toCharArray();
        this.end = this.buffer.length;
        if (this.index + 2 <= this.end && this.buffer[this.end - 2] == '*' && this.buffer[this.end - 1] == '/') {
            this.end -= 2;
        }
        while (this.index < this.end) {
            switch (this.readChar()) {
                case '\t': 
                case '\f': 
                case ' ': 
                case '*': {
                    break;
                }
                case '\n': {
                    this.skipChar('\r');
                    break;
                }
                case '\r': {
                    this.skipChar('\n');
                    break;
                }
                case '@': {
                    JSDocTag tag = this.parseTag(offset);
                    if (tag != null) {
                        tags.add(tag);
                        break;
                    }
                    this.skipEndOfLine();
                    break;
                }
                default: {
                    this.skipEndOfLine();
                }
            }
        }
        return tags;
    }

    private JSDocTag parseTag(int offset) {
        int tagStart = this.index - 1;
        while (this.index < this.end && (this.buffer[this.index] == '.' || Character.isLetter(this.buffer[this.index]))) {
            ++this.index;
        }
        if (this.index == tagStart + 1) {
            return null;
        }
        String tag = new String(this.buffer, tagStart, this.index - tagStart);
        int valueStart = this.index;
        this.value.setLength(0);
        this.ends.clear();
        this.skipSpaces();
        boolean lineStart = false;
        block7: while (this.index < this.end) {
            char c = this.readChar();
            switch (c) {
                case '@': {
                    if (lineStart) {
                        this.unread();
                        break block7;
                    }
                    this.value.append(c);
                    this.ends.add(this.index);
                    break;
                }
                case '\r': {
                    this.skipChar('\n');
                    lineStart = true;
                    this.skipSpaces();
                    if (!this.skipAll('*') || !this.skipChar('/')) continue block7;
                    break block7;
                }
                case '\n': {
                    this.skipChar('\r');
                    lineStart = true;
                    this.skipSpaces();
                    if (!this.skipAll('*') || !this.skipChar('/')) continue block7;
                    break block7;
                }
                case '\t': 
                case '\f': 
                case ' ': {
                    this.value.append(c);
                    this.ends.add(this.index);
                    break;
                }
                default: {
                    lineStart = false;
                    this.value.append(c);
                    this.ends.add(this.index);
                }
            }
        }
        int len = this.value.length();
        while (len > 0 && Character.isWhitespace(this.value.charAt(len - 1))) {
            --len;
        }
        if (len != this.value.length()) {
            this.value.setLength(len);
            this.ends.setSize(len);
        }
        return new JSDocTag(tag, this.value.toString(), offset + tagStart, offset + (this.ends.isEmpty() ? valueStart : this.ends.get(this.ends.size() - 1)));
    }

    private boolean skipAll(char expected) {
        boolean result = false;
        while (this.index < this.end && this.buffer[this.index] == expected) {
            ++this.index;
            result = true;
        }
        return result;
    }

    private void skipSpaces() {
        while (this.index < this.end && (this.buffer[this.index] == ' ' || this.buffer[this.index] == '\t')) {
            ++this.index;
        }
    }

    private void skipEndOfLine() {
        block4: while (this.index < this.end) {
            switch (this.readChar()) {
                case '\r': {
                    this.skipChar('\n');
                    break block4;
                }
                case '\n': {
                    this.skipChar('\r');
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    private boolean skipChar(char expected) {
        if (this.index < this.end && this.buffer[this.index] == expected) {
            ++this.index;
            return true;
        }
        return false;
    }

    private void unread() {
        --this.index;
    }

    private char readChar() {
        return this.buffer[this.index++];
    }
}

