/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

public class IntList {
    public static final IntList EMPTY_LIST = new IntList(0){

        public void add(int value) {
            throw new UnsupportedOperationException();
        }

        public void setSize(int newSize) {
            throw new UnsupportedOperationException();
        }
    };
    private int[] values;
    private int length = 0;

    public IntList() {
        this(16);
    }

    public IntList(int initialSize) {
        this.values = new int[initialSize];
    }

    public void add(int value) {
        if (this.values.length == this.length) {
            this.values = new int[this.length * 2];
            System.arraycopy(this.values, 0, this.values, 0, this.length);
        }
        this.values[this.length++] = value;
    }

    public int get(int index) {
        assert (index < this.length);
        return this.values[index];
    }

    public int size() {
        return this.length;
    }

    public void setSize(int newSize) {
        this.length = newSize;
    }

    public int[] toArray() {
        if (this.length == this.values.length) {
            return this.values;
        }
        int[] result = new int[this.length];
        System.arraycopy(this.values, 0, result, 0, this.length);
        return result;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.length) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.values[i]);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public void clear() {
        this.length = 0;
    }
}

