/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.IValueTypeFactory;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.ti.ValueTypeFactoryImpl;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.parser.JSProblem;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IElementResolver;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeProvider;
import org.eclipse.dltk.javascript.typeinfo.JSType2;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.AnyType;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeRef;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInferencer2
implements ITypeInferenceContext {
    private TypeInferencerVisitor visitor;
    private ReferenceSource source;
    private static final boolean DEBUG = false;
    private final Map<String, Type> types = new ConcurrentHashMap<String, Type>();
    private final Map<String, Boolean> activeTypeRequests = new HashMap<String, Boolean>();
    private ITypeProvider[] typeProviders = null;
    private final TypeResourceSet typeRS = new TypeResourceSet(){

        protected Type resolveTypeProxy(String typeName) {
            return TypeInferencer2.this.getType(typeName, null, true, false, false, false);
        }
    };
    static final ConcurrentHashMap<String, InvariantTypeResourceSet> invariantContextRS = new ConcurrentHashMap();
    static final InvariantTypeResourceSet invariantRS = new InvariantTypeResourceSet(invariantContextRS);
    private IValueTypeFactory factory = new ValueTypeFactoryImpl(this);
    private boolean resolve = true;
    private Map<String, Member> elements = new HashMap<String, Member>();
    private IModelBuilder[] modelBuilders = null;

    private void initializeVisitor() {
        if (this.visitor == null) {
            this.visitor = new TypeInferencerVisitor(this);
        }
        this.visitor.initialize();
    }

    public void setVisitor(TypeInferencerVisitor visitor) {
        this.visitor = visitor;
    }

    public void setModelElement(IModelElement modelElement) {
        this.setSource(new ReferenceSource(modelElement));
    }

    public void setSource(ReferenceSource source) {
        this.source = source;
    }

    public void doInferencing(Script script) {
        try {
            this.elements.clear();
            this.modelBuilders = null;
            this.typeProviders = null;
            this.initializeVisitor();
            this.visitor.visit((ASTNode)script);
        }
        catch (PositionReachedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.log(e);
        }
        catch (AssertionError e) {
            this.log((Throwable)((Object)e));
        }
    }

    protected void log(Throwable e) {
        JSProblemReporter reporter = this.visitor.getProblemReporter();
        if (reporter != null) {
            reporter.reportProblem((IProblem)new JSProblem(e));
        } else {
            JavaScriptPlugin.error(e);
        }
    }

    public IValueReference evaluate(ASTNode node) {
        this.initializeVisitor();
        return this.visitor.visit(node);
    }

    public IValueCollection getCollection() {
        return this.visitor.getCollection();
    }

    public IValueCollection currentCollection() {
        return this.visitor.peekContext();
    }

    @Override
    public Type getType(String typeName) {
        boolean queryProviders;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        return this.getType(typeName, null, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), true);
    }

    @Override
    public TypeRef getTypeRef(String typeName) {
        return TypeUtil.ref(this.getType(typeName));
    }

    @Override
    public Type getKnownType(String typeName, TypeMode mode) {
        boolean queryProviders;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        return this.getType(typeName, mode, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), false);
    }

    private boolean isResolved(JSType type) {
        if (type instanceof TypeRef) {
            return !((TypeRef)type).getTarget().isProxy();
        }
        if (type instanceof ClassType) {
            Type t = ((ClassType)type).getTarget();
            return t == null || !t.isProxy();
        }
        if (type instanceof ArrayType) {
            return this.isResolved(((ArrayType)type).getItemType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return this.isResolved(mapType.getValueType()) && this.isResolved(mapType.getKeyType());
        }
        if (type instanceof AnyType || type instanceof UndefinedType) {
            return true;
        }
        if (type instanceof UnionType) {
            for (JSType t : ((UnionType)type).getTargets()) {
                if (this.isResolved(t)) continue;
                return false;
            }
            return true;
        }
        if (type instanceof RecordType) {
            for (Member member : ((RecordType)type).getMembers()) {
                if (this.isResolved(member.getType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof FunctionType) {
            FunctionType funcType = (FunctionType)type;
            if (!this.isResolved(funcType.getReturnType())) {
                return false;
            }
            for (Parameter parameter : funcType.getParameters()) {
                if (this.isResolved(parameter.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public JSType resolveTypeRef(JSType type) {
        if (type == null || this.isResolved(type)) {
            return type;
        }
        return this.doResolveTypeRef(type);
    }

    private JSType2 doResolveTypeRef(JSType type) {
        if (type instanceof TypeRef) {
            TypeRef r = (TypeRef)type;
            return JSTypeSet.ref(this.doResolveType(r.getTarget()));
        }
        if (type instanceof ClassType) {
            ClassType c = (ClassType)type;
            Type target = c.getTarget();
            return JSTypeSet.classType(target != null ? this.doResolveType(target) : null);
        }
        if (type instanceof ArrayType) {
            return JSTypeSet.arrayOf(this.doResolveTypeRef(((ArrayType)type).getItemType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return JSTypeSet.mapOf(this.doResolveTypeRef(mapType.getKeyType()), this.doResolveTypeRef(mapType.getValueType()));
        }
        if (type instanceof UnionType) {
            ArrayList<JSType2> targets = new ArrayList<JSType2>();
            for (JSType t : ((UnionType)type).getTargets()) {
                targets.add(this.doResolveTypeRef(t));
            }
            return JSTypeSet.union(targets);
        }
        if (type instanceof AnyType) {
            return JSTypeSet.any();
        }
        if (type instanceof FunctionType) {
            FunctionType funcType = (FunctionType)type;
            BasicEList params = new BasicEList();
            for (Parameter parameter : funcType.getParameters()) {
                params.add((Object)JSTypeSet.parameter(parameter.getName(), this.doResolveTypeRef(parameter.getType())));
            }
            return JSTypeSet.functionType(funcType.getParameters(), this.doResolveTypeRef(funcType.getReturnType()));
        }
        if (type instanceof RecordType) {
            Type target = ((RecordType)type).getTarget();
            for (Member member : target.getMembers()) {
                if (!(member.getType() instanceof TypeRef)) continue;
                TypeRef ref = (TypeRef)member.getType();
                ref.setTarget(this.doResolveType(ref.getTarget()));
            }
            return JSTypeSet.record(target);
        }
        return (JSType2)type;
    }

    private Type doResolveType(Type type) {
        String typeName;
        Type resolved;
        if (type.isProxy() && (resolved = this.getType(typeName = URI.decode((String)((InternalEObject)type).eProxyURI().fragment()), null, true, true, false, true)) != null) {
            return resolved;
        }
        return type;
    }

    @Override
    public Set<String> listTypes(TypeMode mode, String prefix) {
        HashSet<String> result = new HashSet<String>();
        Set<String> typeNames = TypeInfoModelLoader.getInstance().listTypes(prefix);
        if (typeNames != null) {
            result.addAll(typeNames);
        }
        ITypeProvider[] iTypeProviderArray = this.getTypeProviders();
        int n = iTypeProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeProvider provider = iTypeProviderArray[n2];
            typeNames = provider.listTypes(this, mode, prefix);
            if (typeNames != null) {
                result.addAll(typeNames);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public ReferenceSource getSource() {
        return this.source;
    }

    @Override
    public IValueCollection getTopValueCollection() {
        if (this.resolve) {
            IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
            int n = iMemberEvaluatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
                IValueCollection collection = evaluator.getTopValueCollection(this);
                if (collection != null) {
                    return collection;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IModelElement getModelElement() {
        return this.source != null ? this.source.getModelElement() : null;
    }

    @Override
    public String getContext() {
        return null;
    }

    private Type getType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined, boolean allowProxy, boolean allowUnknown) {
        Type type = this.types.get(typeName);
        if (type != null) {
            if (!allowUnknown && type.getKind() == TypeKind.UNKNOWN) {
                return null;
            }
            return type;
        }
        type = invariantRS.getCachedType(typeName);
        if (type != null) {
            this.types.put(typeName, type);
            return type;
        }
        type = this.loadType(typeName, mode, queryProviders, queryPredefined);
        if (type != null) {
            this.validateTypeInfo(type);
            this.types.put(typeName, type);
            this.typeRS.addToResource(type);
            return type;
        }
        if (allowProxy) {
            type = TypeUtil.createProxy(typeName);
            return type;
        }
        if (allowUnknown) {
            type = TypeInferencer2.createUnknown(typeName);
            this.typeRS.addToResource(type);
            this.types.put(typeName, type);
            return type;
        }
        return null;
    }

    private void validateTypeInfo(Type type) {
        Resource resource = ((EObject)type).eResource();
        if (resource != null) {
            boolean validResource;
            URI u = resource.getURI();
            if (u != null && (u.isFile() || u.isPlatform())) {
                return;
            }
            boolean bl = validResource = resource == invariantRS.getResource() || TypeInfoModelLoader.getInstance().hasResource(resource);
            if (!validResource) {
                Iterator<InvariantTypeResourceSet> iterator = invariantContextRS.values().iterator();
                while (iterator.hasNext()) {
                    boolean bl2 = validResource = iterator.next().getResource() == resource;
                    if (validResource) break;
                }
                Assert.isTrue((boolean)validResource, (String)("Type " + type.getName() + " has invalid resource: " + resource));
            }
        }
    }

    @Override
    public void markInvariant(Type type) {
        if (((EObject)type).eResource() != null) {
            return;
        }
        invariantRS.add(type);
    }

    @Override
    public void markInvariant(Type type, String context) {
        if (((EObject)type).eResource() != null) {
            return;
        }
        if (context == null) {
            this.markInvariant(type);
        } else {
            InvariantTypeResourceSet set;
            Assert.isLegal((((EObject)type).eContainer() == null ? 1 : 0) != 0);
            Assert.isLegal((((EObject)type).eResource() == null ? 1 : 0) != 0);
            InvariantTypeResourceSet invariantTypeResourceSet = invariantContextRS.get(context);
            if (invariantTypeResourceSet == null && (set = invariantContextRS.putIfAbsent(context, invariantTypeResourceSet = new InvariantTypeResourceSet(context, invariantRS, invariantContextRS))) != null) {
                invariantTypeResourceSet = set;
            }
            invariantTypeResourceSet.add(type);
        }
    }

    @Override
    public Type getInvariantType(String typeName, String context) {
        if (context == null) {
            return invariantRS.getCachedType(typeName);
        }
        InvariantTypeResourceSet invariantTypeResourceSet = invariantContextRS.get(context);
        if (invariantTypeResourceSet != null) {
            return invariantTypeResourceSet.getCachedType(typeName);
        }
        return null;
    }

    protected static Type createUnknown(String typeName) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        type.setName(typeName);
        type.setKind(TypeKind.UNKNOWN);
        return type;
    }

    private boolean canQueryTypeProviders() {
        return this.activeTypeRequests.isEmpty();
    }

    private Type loadType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined) {
        Type type;
        if (queryProviders && this.activeTypeRequests.put(typeName, Boolean.FALSE) == null) {
            try {
                type = invariantRS.getCachedType(typeName);
                if (type != null) {
                    Type type2 = type;
                    return type2;
                }
                ITypeProvider[] iTypeProviderArray = this.getTypeProviders();
                int n = iTypeProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeProvider provider = iTypeProviderArray[n2];
                    type = provider.getType(this, mode, typeName);
                    if (type != null && !TypeInferencer2.isProxy(type)) {
                        Type type3 = type;
                        return type3;
                    }
                    ++n2;
                }
            }
            finally {
                this.activeTypeRequests.remove(typeName);
            }
        }
        if (queryPredefined && (type = TypeInfoModelLoader.getInstance().getType(typeName)) != null) {
            return type;
        }
        return null;
    }

    @Override
    public ITypeProvider[] getTypeProviders() {
        if (this.typeProviders == null) {
            this.typeProviders = this.createTypeProviders();
        }
        return this.typeProviders;
    }

    protected ITypeProvider[] createTypeProviders() {
        return TypeInfoManager.createTypeProviders(this);
    }

    protected static boolean isProxy(Type type) {
        return type instanceof EObject && ((EObject)type).eIsProxy();
    }

    @Override
    public IValueTypeFactory getFactory() {
        return this.factory;
    }

    @Override
    public Member resolve(String name) {
        if (name == null) {
            return null;
        }
        Member element = this.elements.get(name);
        if (element != null) {
            return element;
        }
        element = TypeInfoModelLoader.getInstance().getMember(name);
        if (element != null) {
            this.elements.put(name, element);
            return element;
        }
        if (this.resolve) {
            IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
            int n = iElementResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElementResolver resolver = iElementResolverArray[n2];
                element = resolver.resolveElement(this, name);
                if (element != null) {
                    this.elements.put(name, element);
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IValue valueOf(Member member) {
        IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
        int n = iMemberEvaluatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
            IValueCollection collection = evaluator.valueOf(this, member);
            if (collection != null) {
                if (!(collection instanceof IValueProvider)) break;
                IValue value = ((IValueProvider)((Object)collection)).getValue();
                if (member.getType() != null) {
                    value.setDeclaredType(member.getType());
                }
                if (value.getKind() == ReferenceKind.UNKNOWN) {
                    if (member instanceof Property) {
                        value.setKind(ReferenceKind.PROPERTY);
                    } else {
                        value.setKind(ReferenceKind.METHOD);
                    }
                }
                return value;
            }
            ++n2;
        }
        return ElementValue.createFor(member, this);
    }

    @Override
    public Set<String> listGlobals(String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (Member member : TypeInfoModelLoader.getInstance().listMembers(prefix)) {
            result.add(member.getName());
        }
        IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
        int n = iElementResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementResolver resolver = iElementResolverArray[n2];
            Set<String> globals = resolver.listGlobals(this, prefix);
            if (globals != null) {
                result.addAll(globals);
            }
            ++n2;
        }
        return result;
    }

    public void setDoResolve(boolean resolve) {
        this.resolve = resolve;
    }

    @Override
    public IModelBuilder[] getModelBuilders() {
        if (this.modelBuilders == null) {
            this.modelBuilders = TypeInfoManager.getModelBuilders(this);
        }
        return this.modelBuilders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InvariantTypeResourceSet
    extends TypeResourceSet
    implements ITypeInfoContext {
        private final String context;
        private final InvariantTypeResourceSet staticInvariants;
        private final ConcurrentMap<String, InvariantTypeResourceSet> contextInvariants;
        private final Set<String> activeTypeRequests = new HashSet<String>();
        private final Map<String, Type> types = new ConcurrentHashMap<String, Type>();
        private ITypeProvider[] typeProviders = null;

        public InvariantTypeResourceSet(ConcurrentMap<String, InvariantTypeResourceSet> contextInvariants) {
            this(null, null, contextInvariants);
        }

        public InvariantTypeResourceSet(String context, InvariantTypeResourceSet staticInvariants, ConcurrentMap<String, InvariantTypeResourceSet> contextInvariants) {
            this.context = context;
            this.staticInvariants = staticInvariants;
            this.contextInvariants = contextInvariants;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canQueryTypeProviders() {
            Set<String> set = this.activeTypeRequests;
            synchronized (set) {
                return this.activeTypeRequests.isEmpty();
            }
        }

        @Override
        public String getContext() {
            return this.context;
        }

        private Type getType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined, boolean allowProxy, boolean allowUnknown) {
            Type type = this.types.get(typeName);
            if (type != null) {
                return type;
            }
            type = this.loadType(typeName, mode, queryProviders, queryPredefined);
            if (type != null) {
                this.addToResource(type);
                return type;
            }
            if (allowProxy) {
                type = TypeUtil.createProxy(typeName);
                return type;
            }
            if (allowUnknown) {
                type = TypeInferencer2.createUnknown(typeName);
                this.addToResource(type);
                return type;
            }
            return null;
        }

        @Override
        public TypeRef getTypeRef(String typeName) {
            return TypeUtil.ref(this.getType(typeName));
        }

        public ITypeProvider[] getTypeProviders() {
            if (this.typeProviders == null) {
                this.typeProviders = TypeInfoManager.createTypeProviders(this);
            }
            return this.typeProviders;
        }

        /*
         * Exception decompiling
         */
        private Type loadType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        protected Type resolveTypeProxy(String typeName) {
            Type cachedType;
            if (this.staticInvariants != null && (cachedType = this.staticInvariants.getCachedType(typeName)) != null) {
                return cachedType;
            }
            return this.getType(typeName, null, true, false, false, false);
        }

        @Override
        public Type getType(String typeName) {
            boolean queryProviders;
            if (typeName == null || typeName.length() == 0) {
                return null;
            }
            return this.getType(typeName, null, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), true);
        }

        @Override
        public Type getKnownType(String typeName, TypeMode mode) {
            boolean queryProviders;
            if (typeName == null || typeName.length() == 0) {
                return null;
            }
            return this.getType(typeName, null, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), false);
        }

        @Override
        public void markInvariant(Type type) {
            if (((EObject)type).eResource() != null) {
                return;
            }
            if (this.staticInvariants == null) {
                this.add(type);
            } else {
                this.staticInvariants.add(type);
            }
        }

        @Override
        public void markInvariant(Type type, String context) {
            if (((EObject)type).eResource() != null) {
                return;
            }
            if (context.equals(this.context)) {
                this.add(type);
            } else {
                InvariantTypeResourceSet set;
                InvariantTypeResourceSet invariantTypeResourceSet = (InvariantTypeResourceSet)this.contextInvariants.get(context);
                if (invariantTypeResourceSet == null && (set = invariantContextRS.putIfAbsent(context, invariantTypeResourceSet = new InvariantTypeResourceSet(context, invariantRS, invariantContextRS))) != null) {
                    invariantTypeResourceSet = set;
                }
                invariantTypeResourceSet.add(type);
            }
        }

        @Override
        public Type getInvariantType(String typeName, String context) {
            if (context == null) {
                if (this.staticInvariants == null) {
                    return this.getCachedType(typeName);
                }
                return this.staticInvariants.getCachedType(typeName);
            }
            if (context.equals(this.context)) {
                return this.getCachedType(typeName);
            }
            InvariantTypeResourceSet invariantTypeResourceSet = invariantContextRS.get(context);
            if (invariantTypeResourceSet != null) {
                return invariantTypeResourceSet.getCachedType(typeName);
            }
            return null;
        }

        @Override
        public IModelElement getModelElement() {
            return null;
        }

        @Override
        public ReferenceSource getSource() {
            return ReferenceSource.UNKNOWN;
        }

        @Override
        public void add(Type type) {
            super.add(type);
            this.types.put(type.getName(), type);
        }

        public Type getCachedType(String typeName) {
            return this.types.get(typeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.types.clear();
            InvariantTypeResourceSet invariantTypeResourceSet = this;
            synchronized (invariantTypeResourceSet) {
                this.getResource().getContents().clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeResolveMode {
        SIMPLE,
        PROXY,
        UNKNOWN;

    }

    static abstract class TypeResourceSet
    extends ResourceSetImpl {
        private Resource typesResource = null;

        TypeResourceSet() {
        }

        public EObject getEObject(URI uri, boolean loadOnDemand) {
            if (TypeUtil.isTypeProxy(uri)) {
                String typeName = URI.decode((String)uri.fragment());
                Type type = this.resolveTypeProxy(typeName);
                if (type == null) {
                    return (EObject)TypeInferencer2.createUnknown(typeName);
                }
                if (type instanceof EObject) {
                    return (EObject)type;
                }
                JavaScriptPlugin.error("proxy resolved to " + type.getClass().getName() + " which is not EObject");
                return (EObject)TypeInferencer2.createUnknown(typeName);
            }
            return super.getEObject(uri, loadOnDemand);
        }

        protected abstract Type resolveTypeProxy(String var1);

        public synchronized Resource getResource() {
            if (this.typesResource == null) {
                this.typesResource = new ResourceImpl(TypeUtil.createProxyResourceURI());
                this.getResources().add((Object)this.typesResource);
            }
            return this.typesResource;
        }

        public void addToResource(Type type) {
            EObject object = (EObject)type;
            if (object.eResource() == null) {
                this.add(type);
            }
        }

        protected synchronized void add(Type type) {
            this.getResource().getContents().add((Object)((EObject)type));
        }
    }
}

