/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinference;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.ImmutableValue;
import org.eclipse.dltk.internal.javascript.ti.ImmutableValueCollection;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;

public class ValueCollectionFactory {
    public static IValueCollection createValueCollection() {
        return new ValueCollection(null, new Value()){

            public boolean isScope() {
                return false;
            }
        };
    }

    public static IValueCollection createValueCollection(IValueCollection parent) {
        return new ValueCollection(parent, new Value()){

            public boolean isScope() {
                return false;
            }
        };
    }

    public static IValueCollection createScopeValueCollection() {
        return new ValueCollection(null, new Value()){

            public boolean isScope() {
                return true;
            }
        };
    }

    public static IValueCollection createScopeValueCollection(IValueCollection parent) {
        return new ValueCollection(parent, new Value()){

            public boolean isScope() {
                return true;
            }
        };
    }

    public static IValueCollection createValueCollection(IFile file, boolean resolve) {
        ISourceModule sourceModule;
        Script script;
        if (file.exists() && (script = JavaScriptParserUtil.parse((ISourceModule)(sourceModule = DLTKCore.createSourceModuleFrom((IFile)file)))) != null) {
            TypeInferencer2 inferencer = new TypeInferencer2();
            inferencer.setModelElement((IModelElement)sourceModule);
            inferencer.setDoResolve(resolve);
            inferencer.doInferencing(script);
            IValueCollection collection = inferencer.getCollection();
            inferencer.setVisitor(null);
            return collection;
        }
        return null;
    }

    public static IValueCollection makeImmutable(IValueCollection collection) {
        return ImmutableValueCollection.getImmutableValueCollection(collection, new HashMap<Object, Object>());
    }

    public static void copyInto(IValueCollection target, IValueCollection source) {
        if (target instanceof IValueProvider && source instanceof IValueProvider) {
            IValue targetValue = ((IValueProvider)((Object)target)).getValue();
            IValue sourceValue = ((IValueProvider)((Object)source)).getValue();
            if (targetValue instanceof Value && sourceValue instanceof ImmutableValue) {
                Set<String> children = sourceValue.getDirectChildren();
                for (String childName : children) {
                    ((Value)targetValue).putDirectChild(childName, (ImmutableValue)sourceValue.getChild(childName, false));
                }
            } else {
                targetValue.addValue(((IValueProvider)((Object)source)).getValue());
            }
        }
    }
}

