/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.model.LocalVariable;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;
import org.eclipse.dltk.internal.core.search.matching.VariablePattern;
import org.eclipse.dltk.internal.core.util.Util;

public class LocalVariablePattern
extends VariablePattern
implements IIndexConstants {
    private final ILocalVariable localVariable;

    public LocalVariablePattern(ILocalVariable localVariable, int limitTo, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(localVariable, LocalVariablePattern.isDeclarations(limitTo), LocalVariablePattern.isReferences(limitTo), matchRule, toolkit);
    }

    private static boolean isReferences(int limitTo) {
        return limitTo == 1 || limitTo == 2;
    }

    private static boolean isDeclarations(int limitTo) {
        return limitTo == 0 || limitTo == 2;
    }

    private LocalVariablePattern(ILocalVariable localVariable, boolean declarations, boolean references, int matchRule, IDLTKLanguageToolkit toolkit) {
        super(512, declarations, references, references, localVariable.getElementName().toCharArray(), matchRule, toolkit);
        this.localVariable = localVariable;
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IDLTKSearchScope scope, IProgressMonitor progressMonitor) {
        DLTKSearchScope javaSearchScope;
        AccessRuleSet access;
        String relativePath;
        String documentPath;
        IProjectFragment root = (IProjectFragment)this.localVariable.getAncestor(3);
        if (root.isArchive()) {
            documentPath = "";
            relativePath = "";
        } else {
            IPath path = this.localVariable.getPath();
            documentPath = path.toString();
            relativePath = Util.relativePath(path, 1);
        }
        if (scope instanceof DLTKSearchScope ? (access = (javaSearchScope = (DLTKSearchScope)scope).getAccessRuleSet(relativePath, index.containerPath)) != DLTKSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath, this, participant, access) : scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, this, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "LocalVarCombinedPattern: " : "LocalVarDeclarationPattern: ");
        } else {
            output.append("LocalVarReferencePattern: ");
        }
        if (this.localVariable instanceof LocalVariable) {
            output.append(((LocalVariable)this.localVariable).toStringWithAncestors());
        } else {
            output.append(this.localVariable.getElementName());
        }
        return super.print(output);
    }

    public ILocalVariable getLocalVariable() {
        return this.localVariable;
    }
}

